/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kurtymckurt.TestPojo.PojoBuilder;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunction;

public class TestPojoBuilder<T> {
    private final Class<T> clazz;
    private final ProviderFunction providerFunction;
    private final Map<Class, ProviderFunction> providerFunctions;
    private final List<Generator> customGenerators;
    private final Map<String, Limiter> fieldToLimiter;
    private final Set<String> excludedFields;

    public TestPojoBuilder(Class<T> clazz) {
        this(clazz, null);
    }

    public TestPojoBuilder(Class<T> clazz, ProviderFunction providerFunction) {
        this.clazz = clazz;
        this.providerFunction = providerFunction;
        this.customGenerators = new ArrayList<Generator>();
        this.providerFunctions = new HashMap<Class, ProviderFunction>();
        this.addProviderFunction(providerFunction, clazz);
        this.fieldToLimiter = new HashMap<String, Limiter>();
        this.excludedFields = new HashSet<String>();
    }

    public TestPojoBuilder<T> addGenerator(Generator generator) {
        this.customGenerators.add(generator);
        return this;
    }

    public TestPojoBuilder<T> addProviderFunction(ProviderFunction providerFunction, Class<?> ... clazzes) {
        for (Class<?> aClass : clazzes) {
            this.providerFunctions.put(aClass, providerFunction);
        }
        return this;
    }

    public TestPojoBuilder<T> addLimiter(String fieldName, Limiter limiter) {
        this.fieldToLimiter.put(fieldName, limiter);
        return this;
    }

    public TestPojoBuilder<T> addExcludedField(String fieldName) {
        this.excludedFields.add(fieldName);
        return this;
    }

    public T build() {
        return (T)new PojoBuilder(PojoBuilderConfiguration.builder().clazz(this.clazz).providerFunctions(this.providerFunctions).generators(this.customGenerators).limiters(this.fieldToLimiter).excludedFields(this.excludedFields).build()).buildObject();
    }
}

