/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo.util;

import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;

public class RandomUtils {
    private static final SecureRandom random = new SecureRandom();

    public static int getRandomIntWithinRange(int max) {
        return random.nextInt(max);
    }

    public static int getRandomIntWithinRange(long min, long max) {
        if (max > Integer.MAX_VALUE) {
            max = Integer.MAX_VALUE;
        }
        if (min < Integer.MIN_VALUE) {
            min = Integer.MIN_VALUE;
        }
        return (int)(random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    public static Double getRandomDoubleWithinRange(double min, double max) {
        return random.nextDouble() * (max - min + 1.0) + min;
    }

    public static Float getRandomFloatWithinRange(long min, long max) {
        float floatMin = (float)max > Float.MAX_VALUE ? Float.MAX_VALUE : (float)min;
        float floatMax = (float)min < Float.MIN_VALUE ? Float.MIN_VALUE : (float)max;
        return Float.valueOf(random.nextFloat() * (floatMax - floatMin + 1.0f) + floatMin);
    }

    public static Long getRandomLongObject() {
        return random.nextLong();
    }

    public static Long getRandomLongWithinRange(long min, long max) {
        return (long)(random.nextDouble() * (double)(max - min + 1L)) + min;
    }

    public static Short getRandomShortWithinRange(long min, long max) {
        if (max > 32767L) {
            max = 32767L;
        }
        if (min < -32768L) {
            min = -32768L;
        }
        return (short)(random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    public static byte getRandomByte() {
        byte[] bytes = new byte[1];
        random.nextBytes(bytes);
        return bytes[0];
    }

    public static Boolean getRandomBoolean() {
        return random.nextBoolean();
    }

    public static Character getRandomCharacter() {
        String uuid = UUID.randomUUID().toString();
        return Character.valueOf(uuid.charAt(RandomUtils.getRandomIntWithinRange(uuid.length())));
    }

    public static LocalDate getRandomLocalDate() {
        return LocalDate.of(RandomUtils.getRandomIntWithinRange(1990L, 9999L), RandomUtils.getRandomIntWithinRange(1L, 12L), RandomUtils.getRandomIntWithinRange(1L, 28L));
    }

    public static LocalDateTime getRandomLocalDateTime() {
        return LocalDateTime.of(RandomUtils.getRandomIntWithinRange(1990L, 9999L), RandomUtils.getRandomIntWithinRange(1L, 12L), RandomUtils.getRandomIntWithinRange(1L, 28L), RandomUtils.getRandomIntWithinRange(1L, 12L), RandomUtils.getRandomIntWithinRange(1L, 59L), RandomUtils.getRandomIntWithinRange(1L, 59L));
    }
}

