/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.kurtymckurt.TestPojo.PojoBuilder;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunction;
import org.kurtymckurt.TestPojo.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPojoBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(TestPojoBuilder.class);
    private final Class<T> clazz;
    private final Map<Class, ProviderFunction> providerFunctions;
    private final List<Generator> customGenerators;
    private final Map<String, Limiter> fieldToLimiter;
    private final Set<String> excludedFields;
    private long seed;

    public TestPojoBuilder(Class<T> clazz) {
        this(clazz, null);
    }

    public TestPojoBuilder(Class<T> clazz, ProviderFunction providerFunction) {
        this.clazz = clazz;
        this.customGenerators = new ArrayList<Generator>();
        this.providerFunctions = new HashMap<Class, ProviderFunction>();
        this.addProviderFunction(providerFunction, clazz, new Class[0]);
        this.fieldToLimiter = new HashMap<String, Limiter>();
        this.excludedFields = new HashSet<String>();
        this.seed = new Random().nextLong();
    }

    public TestPojoBuilder<T> addGenerator(Generator generator) {
        this.customGenerators.add(generator);
        return this;
    }

    public TestPojoBuilder<T> addProviderFunction(ProviderFunction providerFunction, Class<?> clazz, Class<?> ... clazzes) {
        this.providerFunctions.put(clazz, providerFunction);
        if (clazzes != null && clazzes.length > 0) {
            for (Class<?> aClass : clazzes) {
                this.providerFunctions.put(aClass, providerFunction);
            }
        }
        return this;
    }

    public TestPojoBuilder<T> addLimiter(String fieldName, Limiter limiter) {
        this.fieldToLimiter.put(fieldName, limiter);
        return this;
    }

    public TestPojoBuilder<T> addExcludedField(String fieldName) {
        this.excludedFields.add(fieldName);
        return this;
    }

    public TestPojoBuilder<T> addExcludedFields(String fieldName, String ... fields) {
        this.addExcludedField(fieldName);
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                this.addExcludedField(field);
            }
        }
        return this;
    }

    public TestPojoBuilder<T> setRandomGeneratorSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public T build() {
        log.info("Using seed: " + this.seed);
        return new PojoBuilder(PojoBuilderConfiguration.builder().clazz(this.clazz).providerFunctions(this.providerFunctions).generators(this.customGenerators).limiters(this.fieldToLimiter).excludedFields(this.excludedFields).randomUtils(new RandomUtils(this.seed)).build()).buildObject();
    }
}

