/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo.generators.primatives;

import com.mifmif.common.regex.Generex;
import java.lang.reflect.Field;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.util.RandomUtils;

public class StringGenerator
implements Generator<String> {
    private static final String characters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456780";

    @Override
    public String generate(Class<?> clazz, Field field, Limiter limiter, PojoBuilderConfiguration pojoBuilderConfiguration) {
        if (limiter != null && limiter.getRegex() != null) {
            Generex generex = new Generex(limiter.getRegex());
            return generex.random();
        }
        return this.getStringBasedOnSizeLimits(limiter, pojoBuilderConfiguration.getRandomUtils());
    }

    private String getStringBasedOnSizeLimits(Limiter limiter, RandomUtils randomUtils) {
        boolean hasLimiter;
        long min = 1L;
        long max = 100L;
        long length = randomUtils.getRandomIntWithinRange(min, max);
        boolean bl = hasLimiter = limiter != null;
        if (hasLimiter) {
            if (limiter.getMin() != null) {
                min = limiter.getMin();
            }
            if (limiter.getMax() != null) {
                max = limiter.getMax();
            }
            length = limiter.getLength() != null ? (long)limiter.getLength().intValue() : (long)randomUtils.getRandomIntWithinRange(min, max);
        }
        return this.getChars(length, randomUtils);
    }

    private String getChars(long length, RandomUtils randomUtils) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((long)i < length) {
            builder.append(characters.charAt(randomUtils.getRandomIntWithinRange(0L, characters.length() - 1)));
            ++i;
        }
        return builder.toString();
    }

    @Override
    public boolean supportsType(Class<?> clazz) {
        return clazz.isAssignableFrom(String.class);
    }
}

