/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.exceptions.IllegalAccessException;
import org.kurtymckurt.TestPojo.exceptions.InstantiationException;
import org.kurtymckurt.TestPojo.exceptions.NoSuchFieldException;
import org.kurtymckurt.TestPojo.exceptions.NoSuchMethodException;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.generators.PostGenerator;
import org.kurtymckurt.TestPojo.generators.collections.BlockingDequeGenerator;
import org.kurtymckurt.TestPojo.generators.collections.ListGenerator;
import org.kurtymckurt.TestPojo.generators.collections.MapGenerator;
import org.kurtymckurt.TestPojo.generators.collections.NavigableMapGenerator;
import org.kurtymckurt.TestPojo.generators.collections.NavigableSetGenerator;
import org.kurtymckurt.TestPojo.generators.collections.QueueGenerator;
import org.kurtymckurt.TestPojo.generators.collections.SetGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.BooleanGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.ByteGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.CharacterGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.DateGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.DoubleGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.FloatGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.IntegerGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.LongGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.ShortGenerator;
import org.kurtymckurt.TestPojo.generators.primatives.StringGenerator;
import org.kurtymckurt.TestPojo.generators.time.InstantGenerator;
import org.kurtymckurt.TestPojo.generators.time.LocalDateGenerator;
import org.kurtymckurt.TestPojo.generators.time.LocalDateTimeGenerator;
import org.kurtymckurt.TestPojo.generators.time.OffsetDateTimeGenerator;
import org.kurtymckurt.TestPojo.generators.time.ZonedDateTimeGenerator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunction;
import org.kurtymckurt.TestPojo.providers.ProviderFunctionContainer;
import org.kurtymckurt.TestPojo.util.LimiterUtils;
import org.kurtymckurt.TestPojo.util.NullSafeLimits;
import org.kurtymckurt.TestPojo.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(PojoBuilder.class);
    private final List<Generator> generators;
    private final Map<Class, ProviderFunctionContainer> providerFunctions;
    private final Class<?> clazz;
    private final Map<Field, Limiter> limiters;
    private final Map<Class, Set<Field>> excludedFields;
    private final Set<Field> excludedPostGeneratorFields;
    private final Map<Field, Map<Field, PostGenerator>> postGenerators;
    private final PojoBuilderConfiguration configuration;
    private final RandomUtils randomUtils;
    private final boolean warnOnFieldNotExisting;

    public PojoBuilder(PojoBuilderConfiguration configuration) {
        this.clazz = configuration.getClazz();
        this.providerFunctions = new HashMap<Class, ProviderFunctionContainer>();
        this.providerFunctions.putAll(configuration.getProviderFunctions());
        this.limiters = new HashMap<Field, Limiter>();
        this.postGenerators = new HashMap<Field, Map<Field, PostGenerator>>();
        this.excludedPostGeneratorFields = new HashSet<Field>();
        this.generators = new ArrayList<Generator>();
        this.excludedFields = new HashMap<Class, Set<Field>>();
        this.configuration = configuration;
        this.randomUtils = configuration.getRandomUtils();
        this.warnOnFieldNotExisting = configuration.isWarnOnFieldNotExisting();
        this.verifyAndBuildExcludedFieldSet(this.clazz, configuration.getExcludedFields());
        this.verifyAndBuildLimitersMap(this.clazz, configuration.getLimiters());
        this.verifyAndBuildPostGeneratorsFieldSet(this.clazz, configuration.getPostGenerators());
        this.generators.addAll(configuration.getGenerators());
        this.addCoreGenerators();
    }

    private void verifyAndBuildPostGeneratorsFieldSet(Class clazz, Map<String, Map<String, PostGenerator>> postGenerators) {
        for (Map.Entry<String, Map<String, PostGenerator>> entry : postGenerators.entrySet()) {
            String[] toTriggerFieldNames = entry.getKey().split("\\.");
            List<String> toTriggerFieldNameList = Arrays.stream(toTriggerFieldNames).collect(Collectors.toList());
            Field toTriggerField = this.getFieldByString(clazz, toTriggerFieldNameList);
            Map<String, PostGenerator> value = entry.getValue();
            for (Map.Entry<String, PostGenerator> stringPostGeneratorEntry : value.entrySet()) {
                String[] toSetFieldNames = stringPostGeneratorEntry.getKey().split("\\.");
                List<String> toSetFieldNameList = Arrays.stream(toSetFieldNames).collect(Collectors.toList());
                this.verifyAndBuildPostGeneratorsFieldSetHelper(clazz, toSetFieldNameList, toTriggerField, stringPostGeneratorEntry.getValue());
            }
        }
    }

    private Field getFieldByString(Class<?> type, List<String> fieldNames) {
        block4: {
            try {
                Field declaredField = type.getDeclaredField(fieldNames.get(0));
                if (fieldNames.size() <= 1) {
                    return declaredField;
                }
                fieldNames.remove(0);
                this.verifyAndBuildExcludesSetHelper(declaredField.getType(), fieldNames);
            }
            catch (java.lang.NoSuchFieldException e) {
                if (this.warnOnFieldNotExisting) break block4;
                throw new NoSuchFieldException(fieldNames.get(0), type, e);
            }
        }
        if (!this.warnOnFieldNotExisting) {
            throw new NoSuchFieldException(fieldNames.get(0), type, null);
        }
        return null;
    }

    private void verifyAndBuildPostGeneratorsFieldSetHelper(Class<?> type, List<String> fieldNames, Field toTriggerField, PostGenerator postGenerator) {
        try {
            Field declaredField = type.getDeclaredField(fieldNames.get(0));
            if (fieldNames.size() > 1) {
                fieldNames.remove(0);
                this.verifyAndBuildPostGeneratorsFieldSetHelper(declaredField.getType(), fieldNames, toTriggerField, postGenerator);
            } else {
                Map<Field, PostGenerator> fieldPostGeneratorMap = this.postGenerators.get(toTriggerField);
                if (fieldPostGeneratorMap == null) {
                    HashMap<Field, PostGenerator> fieldPostGeneratorMap1 = new HashMap<Field, PostGenerator>();
                    fieldPostGeneratorMap1.put(declaredField, postGenerator);
                    this.postGenerators.put(toTriggerField, fieldPostGeneratorMap1);
                } else {
                    fieldPostGeneratorMap.put(declaredField, postGenerator);
                }
                this.excludedPostGeneratorFields.add(declaredField);
            }
        }
        catch (java.lang.NoSuchFieldException e) {
            if (!this.warnOnFieldNotExisting) {
                throw new NoSuchFieldException(fieldNames.get(0), type, e);
            }
            log.warn("Could not find field: {} of type: {} for provided post generator.", (Object)fieldNames.get(0), type);
        }
    }

    public PojoBuilderConfiguration getConfigurationWithOnlyProvidersAndGenerators() {
        return this.configuration.toBuilder().clearExcludedFields().clearLimiters().build();
    }

    private void verifyAndBuildExcludedFieldSet(Class clazz, Set<String> fieldsToExclude) {
        for (String field : fieldsToExclude) {
            String[] fieldNames = field.split("\\.");
            List<String> fieldNameList = Arrays.stream(fieldNames).collect(Collectors.toList());
            this.verifyAndBuildExcludesSetHelper(clazz, fieldNameList);
        }
    }

    private void verifyAndBuildExcludesSetHelper(Class<?> type, List<String> fieldNames) {
        try {
            Field declaredField = type.getDeclaredField(fieldNames.get(0));
            if (fieldNames.size() > 1) {
                fieldNames.remove(0);
                this.verifyAndBuildExcludesSetHelper(declaredField.getType(), fieldNames);
            } else {
                Set<Field> fields = this.excludedFields.get(type);
                if (fields == null) {
                    fields = new HashSet<Field>();
                }
                fields.add(declaredField);
                this.excludedFields.put(type, fields);
            }
        }
        catch (java.lang.NoSuchFieldException e) {
            if (!this.warnOnFieldNotExisting) {
                throw new NoSuchFieldException(fieldNames.get(0), type, e);
            }
            log.warn("Could not find field: {} of type: {} for provided excludes.", (Object)fieldNames.get(0), type);
        }
    }

    private void verifyAndBuildLimitersMap(Class clazz, Map<String, Limiter> limiters) {
        Set<Map.Entry<String, Limiter>> entries = limiters.entrySet();
        for (Map.Entry<String, Limiter> entry : entries) {
            String[] fieldNames = entry.getKey().split("\\.");
            List<String> fieldNameList = Arrays.stream(fieldNames).collect(Collectors.toList());
            this.verifyAndBuildLimitersMapHelper(clazz, fieldNameList, entry.getValue());
        }
    }

    private void verifyAndBuildLimitersMapHelper(Class<?> type, List<String> fieldNames, Limiter limiter) {
        try {
            Field declaredField = type.getDeclaredField(fieldNames.get(0));
            if (fieldNames.size() > 1) {
                fieldNames.remove(0);
                this.verifyAndBuildLimitersMapHelper(declaredField.getType(), fieldNames, limiter);
            } else {
                this.limiters.put(declaredField, limiter);
            }
        }
        catch (java.lang.NoSuchFieldException e) {
            if (!this.warnOnFieldNotExisting) {
                throw new NoSuchFieldException(fieldNames.get(0), type, e);
            }
            log.warn("Could not find field: {} of type: {} for provided limiter.", (Object)fieldNames.get(0), type);
        }
    }

    private void addCoreGenerators() {
        this.generators.add(new IntegerGenerator());
        this.generators.add(new LongGenerator());
        this.generators.add(new DoubleGenerator());
        this.generators.add(new FloatGenerator());
        this.generators.add(new ByteGenerator());
        this.generators.add(new BooleanGenerator());
        this.generators.add(new StringGenerator());
        this.generators.add(new ShortGenerator());
        this.generators.add(new CharacterGenerator());
        this.generators.add(new SetGenerator());
        this.generators.add(new ListGenerator());
        this.generators.add(new MapGenerator());
        this.generators.add(new NavigableSetGenerator());
        this.generators.add(new NavigableMapGenerator());
        this.generators.add(new QueueGenerator());
        this.generators.add(new BlockingDequeGenerator());
        this.generators.add(new DateGenerator());
        this.generators.add(new LocalDateTimeGenerator());
        this.generators.add(new LocalDateGenerator());
        this.generators.add(new ZonedDateTimeGenerator());
        this.generators.add(new InstantGenerator());
        this.generators.add(new OffsetDateTimeGenerator());
    }

    public T buildObject() {
        return this.buildObject(this.clazz);
    }

    private T buildObject(Class<?> clazz) {
        for (Generator generator : this.generators) {
            if (!generator.supportsType(clazz)) continue;
            return generator.generate(clazz, null, null, this.getConfigurationWithOnlyProvidersAndGenerators());
        }
        log.debug("[*] creating object {}.", clazz);
        Object instance = null;
        String builderMethod = null;
        try {
            ProviderFunction providerFunction;
            ProviderFunctionContainer providerFunctionContainer = this.providerFunctions.get(clazz);
            if (providerFunctionContainer != null && (providerFunction = providerFunctionContainer.getProviderFunction()) != null) {
                instance = providerFunction.provide();
            }
            if (instance == null) {
                instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            log.debug("[*] created object {}.", instance);
            log.debug("[*] attempting to fill the object {}.", instance);
            instance = this.fillInstanceVariables(instance);
            if (providerFunctionContainer != null && (builderMethod = providerFunctionContainer.getBuilderMethod()) != null) {
                Method method = instance.getClass().getMethod(builderMethod, null);
                instance = method.invoke(instance, new Object[0]);
            }
        }
        catch (java.lang.InstantiationException e) {
            log.info("Problems instantiating the object", (Throwable)e);
            throw new InstantiationException(clazz, e);
        }
        catch (java.lang.IllegalAccessException | InvocationTargetException e) {
            log.info("Problems accessing properties on the object", (Throwable)e);
            throw new IllegalAccessException(clazz, e);
        }
        catch (java.lang.NoSuchMethodException e) {
            log.info("Problems building builder on the object", (Throwable)e);
            throw new NoSuchMethodException(builderMethod, instance.getClass(), e);
        }
        log.debug("[*] completed object: {}", instance);
        return (T)instance;
    }

    private Object fillInstanceVariables(Object instance) {
        Field[] declaredFields = instance.getClass().getDeclaredFields();
        if (declaredFields.length == 0) {
            return instance;
        }
        Set<Field> excludedForThisInstance = this.excludedFields.get(instance.getClass());
        for (Field f : declaredFields) {
            if (Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())) {
                log.debug("[*] Skipping due to field being static final. field name: {}, field: {}.", (Object)f.getName(), f.getType());
                continue;
            }
            if (excludedForThisInstance != null && excludedForThisInstance.contains(f)) {
                log.debug("[*] Skipping due to exclusion. field name: {}, field: {}.", (Object)f.getName(), f.getType());
                continue;
            }
            if (this.excludedPostGeneratorFields.contains(f)) {
                log.debug("[*] Skipping due to post generator. field name: {}, field: {}.", (Object)f.getName(), f.getType());
                continue;
            }
            f.setAccessible(true);
            this.setField(instance, f);
            this.executePostGenerators(instance, f);
        }
        return instance;
    }

    private void executePostGenerators(Object instance, Field f) {
        Map<Field, PostGenerator> fieldPostGeneratorMap = this.postGenerators.get(f);
        if (fieldPostGeneratorMap != null && !fieldPostGeneratorMap.isEmpty()) {
            for (Map.Entry<Field, PostGenerator> fieldPostGeneratorEntry : fieldPostGeneratorMap.entrySet()) {
                Field key = fieldPostGeneratorEntry.getKey();
                PostGenerator postGenerator = fieldPostGeneratorEntry.getValue();
                try {
                    key.setAccessible(true);
                    key.set(instance, postGenerator.generate(f.get(instance)));
                }
                catch (java.lang.IllegalAccessException e) {
                    throw new IllegalAccessException(instance.getClass(), e);
                }
            }
        }
    }

    void setField(Object instance, Field f) {
        Class<Serializable> type = f.getType();
        log.debug("[*] attempting to generate field name: {}, field: {}.", (Object)f.getName(), type);
        try {
            if (type.isAssignableFrom(Integer.TYPE)) {
                f.setInt(instance, (Integer)new IntegerGenerator().generate((Class)type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators()));
            } else if (type.isAssignableFrom(Double.TYPE)) {
                f.setDouble(instance, (Double)new DoubleGenerator().generate((Class)type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators()));
            } else if (type.isAssignableFrom(Long.TYPE)) {
                f.setLong(instance, (Long)new LongGenerator().generate((Class)type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators()));
            } else if (type.isAssignableFrom(Float.TYPE)) {
                f.setFloat(instance, ((Float)new FloatGenerator().generate((Class)type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators())).floatValue());
            } else if (type.isAssignableFrom(Byte.TYPE)) {
                f.setByte(instance, this.randomUtils.getRandomByte());
            } else if (type.isAssignableFrom(Short.TYPE)) {
                f.setShort(instance, (Short)new ShortGenerator().generate((Class)type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators()));
            } else if (type.isAssignableFrom(Boolean.TYPE)) {
                f.setBoolean(instance, this.randomUtils.getRandomBoolean());
            } else if (type.isAssignableFrom(Character.TYPE)) {
                f.setChar(instance, this.randomUtils.getRandomCharacter().charValue());
            } else if (type.isEnum()) {
                f.set(instance, type.getEnumConstants()[this.randomUtils.getRandomIntWithinRange(type.getEnumConstants().length)]);
            } else if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                log.debug("[*] creating array of type: {}", componentType);
                Object arr = this.generateArray(componentType, this.limiters.get(f));
                f.set(instance, arr);
            } else {
                boolean generated = false;
                for (Generator generator : this.generators) {
                    if (!generator.supportsType(type)) continue;
                    generated = true;
                    f.set(instance, generator.generate(type, f, this.limiters.get(f), this.getConfigurationWithOnlyProvidersAndGenerators()));
                    break;
                }
                if (!generated) {
                    f.set(instance, this.buildObject(type));
                }
            }
        }
        catch (java.lang.IllegalAccessException e) {
            log.debug("[*] Exception trying to generate the field {}", (Object)type.getTypeName(), (Object)e);
        }
    }

    Object generateArray(Class<?> type, Limiter limiter) {
        NullSafeLimits nullSafeLimits = LimiterUtils.getNullSafeLimits(0, 10, limiter, this.configuration.getRandomUtils());
        int size = nullSafeLimits.length;
        Object arr = Array.newInstance(type, size);
        for (int i = 0; i < size; ++i) {
            if (type.isAssignableFrom(Integer.TYPE)) {
                Array.setInt(arr, i, (Integer)new IntegerGenerator().generate((Class)type, (Field)null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators()));
                continue;
            }
            if (type.isAssignableFrom(Double.TYPE)) {
                Array.setDouble(arr, i, (Double)new DoubleGenerator().generate((Class)type, (Field)null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators()));
                continue;
            }
            if (type.isAssignableFrom(Float.TYPE)) {
                Array.setFloat(arr, i, ((Float)new FloatGenerator().generate((Class)type, (Field)null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators())).floatValue());
                continue;
            }
            if (type.isAssignableFrom(Long.TYPE)) {
                Array.setLong(arr, i, (Long)new LongGenerator().generate((Class)type, (Field)null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators()));
                continue;
            }
            if (type.isAssignableFrom(Short.TYPE)) {
                Array.setShort(arr, i, (Short)new ShortGenerator().generate((Class)type, (Field)null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators()));
                continue;
            }
            if (type.isAssignableFrom(Byte.TYPE)) {
                Array.setByte(arr, i, this.randomUtils.getRandomByte());
                continue;
            }
            if (type.isAssignableFrom(Character.TYPE)) {
                Array.setChar(arr, i, this.randomUtils.getRandomCharacter().charValue());
                continue;
            }
            if (type.isAssignableFrom(Boolean.TYPE)) {
                Array.setBoolean(arr, i, this.randomUtils.getRandomBoolean());
                continue;
            }
            boolean generated = false;
            for (Generator generator : this.generators) {
                if (!generator.supportsType(type)) continue;
                generated = true;
                Array.set(arr, i, generator.generate(type, null, limiter, this.getConfigurationWithOnlyProvidersAndGenerators()));
            }
            if (generated) continue;
            Array.set(arr, i, this.buildObject(type));
        }
        return arr;
    }
}

