/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.generators.PostGenerator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunctionContainer;
import org.kurtymckurt.TestPojo.util.RandomUtils;

public final class PojoBuilderConfiguration {
    private final Class<?> clazz;
    private final Map<Class, ProviderFunctionContainer> providerFunctions;
    private final List<Generator> generators;
    private final Map<String, Map<String, PostGenerator>> postGenerators;
    private final Map<String, Limiter> limiters;
    private final Set<String> excludedFields;
    private final RandomUtils randomUtils;
    private final boolean warnOnFieldNotExisting;

    PojoBuilderConfiguration(Class<?> clazz, Map<Class, ProviderFunctionContainer> providerFunctions, List<Generator> generators, Map<String, Map<String, PostGenerator>> postGenerators, Map<String, Limiter> limiters, Set<String> excludedFields, RandomUtils randomUtils, boolean warnOnFieldNotExisting) {
        this.clazz = clazz;
        this.providerFunctions = providerFunctions;
        this.generators = generators;
        this.postGenerators = postGenerators;
        this.limiters = limiters;
        this.excludedFields = excludedFields;
        this.randomUtils = randomUtils;
        this.warnOnFieldNotExisting = warnOnFieldNotExisting;
    }

    public static PojoBuilderConfigurationBuilder builder() {
        return new PojoBuilderConfigurationBuilder();
    }

    public PojoBuilderConfigurationBuilder toBuilder() {
        PojoBuilderConfigurationBuilder builder = new PojoBuilderConfigurationBuilder().clazz(this.clazz).randomUtils(this.randomUtils).warnOnFieldNotExisting(this.warnOnFieldNotExisting);
        if (this.providerFunctions != null) {
            builder.providerFunctions(this.providerFunctions);
        }
        if (this.generators != null) {
            builder.generators(this.generators);
        }
        if (this.postGenerators != null) {
            builder.postGenerators(this.postGenerators);
        }
        if (this.limiters != null) {
            builder.limiters(this.limiters);
        }
        if (this.excludedFields != null) {
            builder.excludedFields(this.excludedFields);
        }
        return builder;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Map<Class, ProviderFunctionContainer> getProviderFunctions() {
        return this.providerFunctions;
    }

    public List<Generator> getGenerators() {
        return this.generators;
    }

    public Map<String, Map<String, PostGenerator>> getPostGenerators() {
        return this.postGenerators;
    }

    public Map<String, Limiter> getLimiters() {
        return this.limiters;
    }

    public Set<String> getExcludedFields() {
        return this.excludedFields;
    }

    public RandomUtils getRandomUtils() {
        return this.randomUtils;
    }

    public boolean isWarnOnFieldNotExisting() {
        return this.warnOnFieldNotExisting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PojoBuilderConfiguration)) {
            return false;
        }
        PojoBuilderConfiguration other = (PojoBuilderConfiguration)o;
        if (this.isWarnOnFieldNotExisting() != other.isWarnOnFieldNotExisting()) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        Map<Class, ProviderFunctionContainer> this$providerFunctions = this.getProviderFunctions();
        Map<Class, ProviderFunctionContainer> other$providerFunctions = other.getProviderFunctions();
        if (this$providerFunctions == null ? other$providerFunctions != null : !((Object)this$providerFunctions).equals(other$providerFunctions)) {
            return false;
        }
        List<Generator> this$generators = this.getGenerators();
        List<Generator> other$generators = other.getGenerators();
        if (this$generators == null ? other$generators != null : !((Object)this$generators).equals(other$generators)) {
            return false;
        }
        Map<String, Map<String, PostGenerator>> this$postGenerators = this.getPostGenerators();
        Map<String, Map<String, PostGenerator>> other$postGenerators = other.getPostGenerators();
        if (this$postGenerators == null ? other$postGenerators != null : !((Object)this$postGenerators).equals(other$postGenerators)) {
            return false;
        }
        Map<String, Limiter> this$limiters = this.getLimiters();
        Map<String, Limiter> other$limiters = other.getLimiters();
        if (this$limiters == null ? other$limiters != null : !((Object)this$limiters).equals(other$limiters)) {
            return false;
        }
        Set<String> this$excludedFields = this.getExcludedFields();
        Set<String> other$excludedFields = other.getExcludedFields();
        if (this$excludedFields == null ? other$excludedFields != null : !((Object)this$excludedFields).equals(other$excludedFields)) {
            return false;
        }
        RandomUtils this$randomUtils = this.getRandomUtils();
        RandomUtils other$randomUtils = other.getRandomUtils();
        return !(this$randomUtils == null ? other$randomUtils != null : !this$randomUtils.equals(other$randomUtils));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWarnOnFieldNotExisting() ? 79 : 97);
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        Map<Class, ProviderFunctionContainer> $providerFunctions = this.getProviderFunctions();
        result = result * 59 + ($providerFunctions == null ? 43 : ((Object)$providerFunctions).hashCode());
        List<Generator> $generators = this.getGenerators();
        result = result * 59 + ($generators == null ? 43 : ((Object)$generators).hashCode());
        Map<String, Map<String, PostGenerator>> $postGenerators = this.getPostGenerators();
        result = result * 59 + ($postGenerators == null ? 43 : ((Object)$postGenerators).hashCode());
        Map<String, Limiter> $limiters = this.getLimiters();
        result = result * 59 + ($limiters == null ? 43 : ((Object)$limiters).hashCode());
        Set<String> $excludedFields = this.getExcludedFields();
        result = result * 59 + ($excludedFields == null ? 43 : ((Object)$excludedFields).hashCode());
        RandomUtils $randomUtils = this.getRandomUtils();
        result = result * 59 + ($randomUtils == null ? 43 : $randomUtils.hashCode());
        return result;
    }

    public String toString() {
        return "PojoBuilderConfiguration(clazz=" + this.getClazz() + ", providerFunctions=" + this.getProviderFunctions() + ", generators=" + this.getGenerators() + ", postGenerators=" + this.getPostGenerators() + ", limiters=" + this.getLimiters() + ", excludedFields=" + this.getExcludedFields() + ", randomUtils=" + this.getRandomUtils() + ", warnOnFieldNotExisting=" + this.isWarnOnFieldNotExisting() + ")";
    }

    public static class PojoBuilderConfigurationBuilder {
        private Class<?> clazz;
        private ArrayList<Class> providerFunctions$key;
        private ArrayList<ProviderFunctionContainer> providerFunctions$value;
        private ArrayList<Generator> generators;
        private ArrayList<String> postGenerators$key;
        private ArrayList<Map<String, PostGenerator>> postGenerators$value;
        private ArrayList<String> limiters$key;
        private ArrayList<Limiter> limiters$value;
        private ArrayList<String> excludedFields;
        private RandomUtils randomUtils;
        private boolean warnOnFieldNotExisting;

        PojoBuilderConfigurationBuilder() {
        }

        public PojoBuilderConfigurationBuilder clazz(Class<?> clazz) {
            this.clazz = clazz;
            return this;
        }

        public PojoBuilderConfigurationBuilder providerFunction(Class providerFunctionKey, ProviderFunctionContainer providerFunctionValue) {
            if (this.providerFunctions$key == null) {
                this.providerFunctions$key = new ArrayList();
                this.providerFunctions$value = new ArrayList();
            }
            this.providerFunctions$key.add(providerFunctionKey);
            this.providerFunctions$value.add(providerFunctionValue);
            return this;
        }

        public PojoBuilderConfigurationBuilder providerFunctions(Map<? extends Class, ? extends ProviderFunctionContainer> providerFunctions) {
            if (providerFunctions == null) {
                throw new NullPointerException("providerFunctions cannot be null");
            }
            if (this.providerFunctions$key == null) {
                this.providerFunctions$key = new ArrayList();
                this.providerFunctions$value = new ArrayList();
            }
            for (Map.Entry<? extends Class, ? extends ProviderFunctionContainer> $lombokEntry : providerFunctions.entrySet()) {
                this.providerFunctions$key.add($lombokEntry.getKey());
                this.providerFunctions$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder clearProviderFunctions() {
            if (this.providerFunctions$key != null) {
                this.providerFunctions$key.clear();
                this.providerFunctions$value.clear();
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder generator(Generator generator) {
            if (this.generators == null) {
                this.generators = new ArrayList();
            }
            this.generators.add(generator);
            return this;
        }

        public PojoBuilderConfigurationBuilder generators(Collection<? extends Generator> generators) {
            if (generators == null) {
                throw new NullPointerException("generators cannot be null");
            }
            if (this.generators == null) {
                this.generators = new ArrayList();
            }
            this.generators.addAll(generators);
            return this;
        }

        public PojoBuilderConfigurationBuilder clearGenerators() {
            if (this.generators != null) {
                this.generators.clear();
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder postGenerator(String postGeneratorKey, Map<String, PostGenerator> postGeneratorValue) {
            if (this.postGenerators$key == null) {
                this.postGenerators$key = new ArrayList();
                this.postGenerators$value = new ArrayList();
            }
            this.postGenerators$key.add(postGeneratorKey);
            this.postGenerators$value.add(postGeneratorValue);
            return this;
        }

        public PojoBuilderConfigurationBuilder postGenerators(Map<? extends String, ? extends Map<String, PostGenerator>> postGenerators) {
            if (postGenerators == null) {
                throw new NullPointerException("postGenerators cannot be null");
            }
            if (this.postGenerators$key == null) {
                this.postGenerators$key = new ArrayList();
                this.postGenerators$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Map<String, PostGenerator>> $lombokEntry : postGenerators.entrySet()) {
                this.postGenerators$key.add($lombokEntry.getKey());
                this.postGenerators$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder clearPostGenerators() {
            if (this.postGenerators$key != null) {
                this.postGenerators$key.clear();
                this.postGenerators$value.clear();
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder limiter(String limiterKey, Limiter limiterValue) {
            if (this.limiters$key == null) {
                this.limiters$key = new ArrayList();
                this.limiters$value = new ArrayList();
            }
            this.limiters$key.add(limiterKey);
            this.limiters$value.add(limiterValue);
            return this;
        }

        public PojoBuilderConfigurationBuilder limiters(Map<? extends String, ? extends Limiter> limiters) {
            if (limiters == null) {
                throw new NullPointerException("limiters cannot be null");
            }
            if (this.limiters$key == null) {
                this.limiters$key = new ArrayList();
                this.limiters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Limiter> $lombokEntry : limiters.entrySet()) {
                this.limiters$key.add($lombokEntry.getKey());
                this.limiters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder clearLimiters() {
            if (this.limiters$key != null) {
                this.limiters$key.clear();
                this.limiters$value.clear();
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder excludedField(String excludedField) {
            if (this.excludedFields == null) {
                this.excludedFields = new ArrayList();
            }
            this.excludedFields.add(excludedField);
            return this;
        }

        public PojoBuilderConfigurationBuilder excludedFields(Collection<? extends String> excludedFields) {
            if (excludedFields == null) {
                throw new NullPointerException("excludedFields cannot be null");
            }
            if (this.excludedFields == null) {
                this.excludedFields = new ArrayList();
            }
            this.excludedFields.addAll(excludedFields);
            return this;
        }

        public PojoBuilderConfigurationBuilder clearExcludedFields() {
            if (this.excludedFields != null) {
                this.excludedFields.clear();
            }
            return this;
        }

        public PojoBuilderConfigurationBuilder randomUtils(RandomUtils randomUtils) {
            this.randomUtils = randomUtils;
            return this;
        }

        public PojoBuilderConfigurationBuilder warnOnFieldNotExisting(boolean warnOnFieldNotExisting) {
            this.warnOnFieldNotExisting = warnOnFieldNotExisting;
            return this;
        }

        public PojoBuilderConfiguration build() {
            Set<Object> excludedFields;
            Map<String, Limiter> limiters;
            Map<Object, Object> postGenerators;
            List<Generator> generators;
            Map<Object, Object> providerFunctions;
            switch (this.providerFunctions$key == null ? 0 : this.providerFunctions$key.size()) {
                case 0: {
                    providerFunctions = Collections.emptyMap();
                    break;
                }
                case 1: {
                    providerFunctions = Collections.singletonMap(this.providerFunctions$key.get(0), this.providerFunctions$value.get(0));
                    break;
                }
                default: {
                    providerFunctions = new LinkedHashMap(this.providerFunctions$key.size() < 0x40000000 ? 1 + this.providerFunctions$key.size() + (this.providerFunctions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.providerFunctions$key.size(); ++$i) {
                        providerFunctions.put(this.providerFunctions$key.get($i), this.providerFunctions$value.get($i));
                    }
                    providerFunctions = Collections.unmodifiableMap(providerFunctions);
                }
            }
            switch (this.generators == null ? 0 : this.generators.size()) {
                case 0: {
                    generators = Collections.emptyList();
                    break;
                }
                case 1: {
                    generators = Collections.singletonList(this.generators.get(0));
                    break;
                }
                default: {
                    generators = Collections.unmodifiableList(new ArrayList<Generator>(this.generators));
                }
            }
            switch (this.postGenerators$key == null ? 0 : this.postGenerators$key.size()) {
                case 0: {
                    postGenerators = Collections.emptyMap();
                    break;
                }
                case 1: {
                    postGenerators = Collections.singletonMap(this.postGenerators$key.get(0), this.postGenerators$value.get(0));
                    break;
                }
                default: {
                    postGenerators = new LinkedHashMap(this.postGenerators$key.size() < 0x40000000 ? 1 + this.postGenerators$key.size() + (this.postGenerators$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.postGenerators$key.size(); ++$i) {
                        postGenerators.put(this.postGenerators$key.get($i), this.postGenerators$value.get($i));
                    }
                    postGenerators = Collections.unmodifiableMap(postGenerators);
                }
            }
            switch (this.limiters$key == null ? 0 : this.limiters$key.size()) {
                case 0: {
                    limiters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    limiters = Collections.singletonMap(this.limiters$key.get(0), this.limiters$value.get(0));
                    break;
                }
                default: {
                    limiters = new LinkedHashMap(this.limiters$key.size() < 0x40000000 ? 1 + this.limiters$key.size() + (this.limiters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.limiters$key.size(); ++$i) {
                        limiters.put(this.limiters$key.get($i), this.limiters$value.get($i));
                    }
                    limiters = Collections.unmodifiableMap(limiters);
                }
            }
            switch (this.excludedFields == null ? 0 : this.excludedFields.size()) {
                case 0: {
                    excludedFields = Collections.emptySet();
                    break;
                }
                case 1: {
                    excludedFields = Collections.singleton(this.excludedFields.get(0));
                    break;
                }
                default: {
                    excludedFields = new LinkedHashSet(this.excludedFields.size() < 0x40000000 ? 1 + this.excludedFields.size() + (this.excludedFields.size() - 3) / 3 : Integer.MAX_VALUE);
                    excludedFields.addAll(this.excludedFields);
                    excludedFields = Collections.unmodifiableSet(excludedFields);
                }
            }
            return new PojoBuilderConfiguration(this.clazz, providerFunctions, generators, postGenerators, limiters, excludedFields, this.randomUtils, this.warnOnFieldNotExisting);
        }

        public String toString() {
            return "PojoBuilderConfiguration.PojoBuilderConfigurationBuilder(clazz=" + this.clazz + ", providerFunctions$key=" + this.providerFunctions$key + ", providerFunctions$value=" + this.providerFunctions$value + ", generators=" + this.generators + ", postGenerators$key=" + this.postGenerators$key + ", postGenerators$value=" + this.postGenerators$value + ", limiters$key=" + this.limiters$key + ", limiters$value=" + this.limiters$value + ", excludedFields=" + this.excludedFields + ", randomUtils=" + this.randomUtils + ", warnOnFieldNotExisting=" + this.warnOnFieldNotExisting + ")";
        }
    }
}

