/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.kurtymckurt.TestPojo.PojoBuilder;
import org.kurtymckurt.TestPojo.PojoBuilderConfiguration;
import org.kurtymckurt.TestPojo.generators.Generator;
import org.kurtymckurt.TestPojo.generators.PostGenerator;
import org.kurtymckurt.TestPojo.limiters.Limiter;
import org.kurtymckurt.TestPojo.providers.ProviderFunction;
import org.kurtymckurt.TestPojo.providers.ProviderFunctionContainer;
import org.kurtymckurt.TestPojo.util.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPojoBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(TestPojoBuilder.class);
    private final Class<T> clazz;
    private final Map<Class, ProviderFunctionContainer> providerFunctions;
    private final List<Generator> customGenerators;
    private final Map<String, Map<String, PostGenerator>> postGenerators;
    private final Map<String, Limiter> fieldToLimiter;
    private final Set<String> excludedFields;
    private long seed;
    private boolean warnOnFieldNotExisting;

    public TestPojoBuilder(Class<T> clazz) {
        this(clazz, null);
    }

    public TestPojoBuilder(Class<T> clazz, ProviderFunction providerFunction) {
        this(clazz, null, providerFunction);
    }

    public TestPojoBuilder(Class<T> clazz, String builderMethod, ProviderFunction providerFunction) {
        this.clazz = clazz;
        this.customGenerators = new ArrayList<Generator>();
        this.postGenerators = new HashMap<String, Map<String, PostGenerator>>();
        this.providerFunctions = new HashMap<Class, ProviderFunctionContainer>();
        this.addProviderFunction(providerFunction, builderMethod, clazz, new Class[0]);
        this.fieldToLimiter = new HashMap<String, Limiter>();
        this.excludedFields = new HashSet<String>();
        this.seed = new Random().nextLong();
        this.warnOnFieldNotExisting = false;
    }

    public TestPojoBuilder<T> addGenerator(Generator generator) {
        this.customGenerators.add(generator);
        return this;
    }

    public TestPojoBuilder<T> addProviderFunction(ProviderFunction providerFunction, Class<?> clazz, Class<?> ... clazzes) {
        return this.addProviderFunction(providerFunction, (String)null, clazz, clazzes);
    }

    public TestPojoBuilder<T> addProviderFunction(ProviderFunction providerFunction, String builderMethod, Class<?> clazz, Class<?> ... clazzes) {
        this.providerFunctions.put(clazz, new ProviderFunctionContainer(providerFunction, builderMethod));
        if (clazzes != null && clazzes.length > 0) {
            for (Class<?> aClass : clazzes) {
                this.providerFunctions.put(aClass, new ProviderFunctionContainer(providerFunction, builderMethod));
            }
        }
        return this;
    }

    public TestPojoBuilder<T> addLimiter(String fieldName, Limiter limiter) {
        this.fieldToLimiter.put(fieldName, limiter);
        return this;
    }

    public TestPojoBuilder<T> addExcludedField(String fieldName) {
        this.excludedFields.add(fieldName);
        return this;
    }

    public TestPojoBuilder<T> addPostGenerator(String fieldTriggered, String fieldToSet, PostGenerator postGenerator) {
        Map<String, PostGenerator> stringPostGeneratorMap = this.postGenerators.get(fieldTriggered);
        if (stringPostGeneratorMap == null) {
            HashMap<String, PostGenerator> postGeneratorMap = new HashMap<String, PostGenerator>();
            postGeneratorMap.put(fieldToSet, postGenerator);
            this.postGenerators.put(fieldTriggered, postGeneratorMap);
        }
        return this;
    }

    public TestPojoBuilder<T> addExcludedFields(String fieldName, String ... fields) {
        this.addExcludedField(fieldName);
        if (fields != null && fields.length > 0) {
            for (String field : fields) {
                this.addExcludedField(field);
            }
        }
        return this;
    }

    public TestPojoBuilder<T> setRandomGeneratorSeed(long seed) {
        this.seed = seed;
        return this;
    }

    public TestPojoBuilder<T> setWarnOnFieldNotExisting(boolean warn) {
        this.warnOnFieldNotExisting = warn;
        return this;
    }

    public T build() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        log.info("Building [{}] using seed: [{}] from corresponding line {}:{}", new Object[]{this.clazz, this.seed, stackTrace[2].getFileName(), stackTrace[2].getLineNumber()});
        return new PojoBuilder(PojoBuilderConfiguration.builder().clazz(this.clazz).providerFunctions(this.providerFunctions).generators(this.customGenerators).postGenerators(this.postGenerators).limiters(this.fieldToLimiter).excludedFields(this.excludedFields).randomUtils(new RandomUtils(this.seed)).warnOnFieldNotExisting(this.warnOnFieldNotExisting).build()).buildObject();
    }
}

