/*
 * Decompiled with CFR 0.152.
 */
package org.kurtymckurt.TestPojo.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Random;
import java.util.UUID;

public class RandomUtils {
    private final Random random;
    private final long seed;

    public RandomUtils(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public long getSeed() {
        return this.seed;
    }

    public int getRandomIntWithinRange(int max) {
        return this.random.nextInt(max);
    }

    public int getRandomIntWithinRange(long min, long max) {
        if (max > Integer.MAX_VALUE) {
            max = Integer.MAX_VALUE;
        }
        if (min < Integer.MIN_VALUE) {
            min = Integer.MIN_VALUE;
        }
        return (int)(this.random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    public Double getRandomDoubleWithinRange(double min, double max) {
        return this.random.nextDouble() * (max - min + 1.0) + min;
    }

    public Float getRandomFloatWithinRange(long min, long max) {
        float floatMin = (float)max > Float.MAX_VALUE ? Float.MAX_VALUE : (float)min;
        float floatMax = (float)min < Float.MIN_VALUE ? Float.MIN_VALUE : (float)max;
        return Float.valueOf(this.random.nextFloat() * (floatMax - floatMin + 1.0f) + floatMin);
    }

    public Long getRandomLongObject() {
        return this.random.nextLong();
    }

    public Long getRandomLongWithinRange(long min, long max) {
        return (long)(this.random.nextDouble() * (double)(max - min + 1L)) + min;
    }

    public Short getRandomShortWithinRange(long min, long max) {
        if (max > 32767L) {
            max = 32767L;
        }
        if (min < -32768L) {
            min = -32768L;
        }
        return (short)(this.random.nextDouble() * (double)(max - min + 1L) + (double)min);
    }

    public byte getRandomByte() {
        byte[] bytes = new byte[1];
        this.random.nextBytes(bytes);
        return bytes[0];
    }

    public Boolean getRandomBoolean() {
        return this.random.nextBoolean();
    }

    public Character getRandomCharacter() {
        String uuid = UUID.randomUUID().toString();
        return Character.valueOf(uuid.charAt(this.getRandomIntWithinRange(uuid.length())));
    }

    public LocalDate getRandomLocalDate() {
        return LocalDate.of(this.getRandomIntWithinRange(1990L, 9999L), this.getRandomIntWithinRange(1L, 12L), this.getRandomIntWithinRange(1L, 28L));
    }

    public LocalDateTime getRandomLocalDateTime() {
        return LocalDateTime.of(this.getRandomIntWithinRange(1990L, 9999L), this.getRandomIntWithinRange(1L, 12L), this.getRandomIntWithinRange(1L, 28L), this.getRandomIntWithinRange(1L, 12L), this.getRandomIntWithinRange(1L, 59L), this.getRandomIntWithinRange(1L, 59L));
    }
}

