/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne;

import org.kynosarges.tektosyne.MathUtils;

public final class Fortran {
    private Fortran() {
    }

    public static double aint(double n) {
        return n >= 0.0 ? Math.floor(n) : Math.ceil(n);
    }

    public static float aint(float n) {
        return (float)(n >= 0.0f ? Math.floor(n) : Math.ceil(n));
    }

    public static double anint(double n) {
        if (n > 0.0) {
            return Math.floor(n + 0.5);
        }
        if (n < 0.0) {
            return Math.ceil(n - 0.5);
        }
        return 0.0;
    }

    public static float anint(float n) {
        if (n > 0.0f) {
            return (float)Math.floor(n + 0.5f);
        }
        if (n < 0.0f) {
            return (float)Math.ceil(n - 0.5f);
        }
        return 0.0f;
    }

    public static int ceiling(double n) {
        return MathUtils.toIntExact(Math.ceil(n));
    }

    public static int ceiling(float n) {
        return MathUtils.toIntExact(Math.ceil(n));
    }

    public static int floor(double n) {
        return MathUtils.toIntExact(Math.floor(n));
    }

    public static int floor(float n) {
        return MathUtils.toIntExact(Math.floor(n));
    }

    public static long knint(double n) {
        if (n > 0.0) {
            return MathUtils.toLongExact(n + 0.5);
        }
        if (n < 0.0) {
            return MathUtils.toLongExact(n - 0.5);
        }
        return 0L;
    }

    public static long knint(float n) {
        if (n > 0.0f) {
            return MathUtils.toLongExact(n + 0.5f);
        }
        if (n < 0.0f) {
            return MathUtils.toLongExact(n - 0.5f);
        }
        return 0L;
    }

    public static double max(double ... args) {
        double max = Double.NEGATIVE_INFINITY;
        for (double n : args) {
            if (!(n > max)) continue;
            max = n;
        }
        return max;
    }

    public static float max(float ... args) {
        float max = Float.NEGATIVE_INFINITY;
        for (float n : args) {
            if (!(n > max)) continue;
            max = n;
        }
        return max;
    }

    public static int max(int ... args) {
        int max = Integer.MIN_VALUE;
        for (int n : args) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static long max(long ... args) {
        long max = Long.MIN_VALUE;
        for (long n : args) {
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    public static double min(double ... args) {
        double min = Double.POSITIVE_INFINITY;
        for (double n : args) {
            if (!(n < min)) continue;
            min = n;
        }
        return min;
    }

    public static float min(float ... args) {
        float min = Float.POSITIVE_INFINITY;
        for (float n : args) {
            if (!(n < min)) continue;
            min = n;
        }
        return min;
    }

    public static int min(int ... args) {
        int min = Integer.MAX_VALUE;
        for (int n : args) {
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public static long min(long ... args) {
        long min = Long.MAX_VALUE;
        for (long n : args) {
            if (n >= min) continue;
            min = n;
        }
        return min;
    }

    public static double modulo(double a, double p) {
        if (p == 0.0) {
            throw new ArithmeticException("p == 0");
        }
        return a - (double)Fortran.floor(a / p) * p;
    }

    public static float modulo(float a, float p) {
        if (p == 0.0f) {
            throw new ArithmeticException("p == 0");
        }
        return a - (float)Fortran.floor(a / p) * p;
    }

    public static int modulo(int a, int p) {
        return Math.floorMod(a, p);
    }

    public static long modulo(long a, long p) {
        return Math.floorMod(a, p);
    }

    public static int nint(double n) {
        if (n > 0.0) {
            return MathUtils.toIntExact(n + 0.5);
        }
        if (n < 0.0) {
            return MathUtils.toIntExact(n - 0.5);
        }
        return 0;
    }

    public static int nint(float n) {
        if (n > 0.0f) {
            return MathUtils.toIntExact(n + 0.5f);
        }
        if (n < 0.0f) {
            return MathUtils.toIntExact(n - 0.5f);
        }
        return 0;
    }

    public static double sum(double ... args) {
        double sum = 0.0;
        for (double n : args) {
            sum += n;
        }
        return sum;
    }

    public static float sum(float ... args) {
        float sum = 0.0f;
        for (float n : args) {
            sum += n;
        }
        return sum;
    }

    public static int sum(int ... args) {
        int sum = 0;
        for (int n : args) {
            sum = Math.addExact(sum, n);
        }
        return sum;
    }

    public static long sum(long ... args) {
        long sum = 0L;
        for (long n : args) {
            sum = Math.addExact(sum, n);
        }
        return sum;
    }
}

