/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public final class MathUtils {
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    private MathUtils() {
    }

    public static int compare(double a, double b, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        double delta = a - b;
        if (Math.abs(delta) <= epsilon) {
            return 0;
        }
        return delta < 0.0 ? -1 : 1;
    }

    public static int compare(float a, float b, float epsilon) {
        if (epsilon < 0.0f) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        float delta = a - b;
        if (Math.abs(delta) <= epsilon) {
            return 0;
        }
        return delta < 0.0f ? -1 : 1;
    }

    public static boolean equals(double a, double b, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        return Math.abs(a - b) <= epsilon;
    }

    public static boolean equals(float a, float b, float epsilon) {
        if (epsilon < 0.0f) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        return Math.abs(a - b) <= epsilon;
    }

    public static <T> T getAny(T[] array) {
        try {
            return array[RANDOM.nextInt(array.length)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("empty array", e);
        }
    }

    public static <T> T getAny(Collection<T> collection) {
        int index = RANDOM.nextInt(collection.size());
        for (T t : collection) {
            if (--index >= 0) continue;
            return t;
        }
        throw new IllegalArgumentException("empty collection");
    }

    public static <T> T getAny(List<T> list) {
        try {
            return list.get(RANDOM.nextInt(list.size()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("empty list", e);
        }
    }

    public static boolean isPrime(int candidate) {
        if (candidate <= 0) {
            throw new IllegalArgumentException("candidate <= 0");
        }
        if ((candidate & 1) == 0) {
            return candidate == 2;
        }
        int root = (int)Math.sqrt(candidate);
        for (int i = 3; i <= root; i += 2) {
            if (candidate % i != 0) continue;
            return false;
        }
        return true;
    }

    public static double normalize(double[] array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        double sum = 0.0;
        for (double element : array) {
            if (element < 0.0) {
                throw new IllegalArgumentException("array element < 0");
            }
            sum += element;
        }
        if (sum != 0.0) {
            int i = 0;
            while (i < array.length) {
                int n = i++;
                array[n] = array[n] / sum;
            }
        } else {
            double value = 1.0 / (double)array.length;
            for (int i = 0; i < array.length; ++i) {
                array[i] = value;
            }
        }
        return sum;
    }

    public static float normalize(float[] array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        float sum = 0.0f;
        for (float element : array) {
            if (element < 0.0f) {
                throw new IllegalArgumentException("array element < 0");
            }
            sum += element;
        }
        if (sum != 0.0f) {
            int i = 0;
            while (i < array.length) {
                int n = i++;
                array[n] = array[n] / sum;
            }
        } else {
            float value = 1.0f / (float)array.length;
            for (int i = 0; i < array.length; ++i) {
                array[i] = value;
            }
        }
        return sum;
    }

    public static double restrict(double a, double min, double max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static float restrict(float a, float min, float max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static int restrict(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static long restrict(long a, long min, long max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static int toIntExact(double value) {
        if (value < -2.147483648E9 || value > 2.147483647E9) {
            throw new ArithmeticException("value <> Integer: " + value);
        }
        return (int)value;
    }

    public static int toIntExact(float value) {
        if (value < -2.1474836E9f || value > 2.1474836E9f) {
            throw new ArithmeticException("value <> Integer: " + value);
        }
        return (int)value;
    }

    public static long toLongExact(double value) {
        if (value < -9.223372036854776E18 || value > 9.223372036854776E18) {
            throw new ArithmeticException("value <> Long: " + value);
        }
        return (long)value;
    }

    public static long toLongExact(float value) {
        if (value < -9.223372E18f || value > 9.223372E18f) {
            throw new ArithmeticException("value <> Long: " + value);
        }
        return (long)value;
    }
}

