/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class NodeList<T>
extends AbstractSequentialList<T>
implements Deque<T> {
    private Node<T> _first;
    private Node<T> _last;
    private int _size;

    public NodeList() {
    }

    public NodeList(Collection<? extends T> collection) {
        for (T value : collection) {
            this.addLast(value);
        }
    }

    public Node<T> first() {
        return this._first;
    }

    public Node<T> last() {
        return this._last;
    }

    public void addAfter(Node<T> node, T value) {
        if (((Node)node)._owner != this) {
            throw new IllegalArgumentException("node not in list");
        }
        Node newNode = new Node(this, value);
        ++this._size;
        ++this.modCount;
        if (node == this._last) {
            this._last = newNode;
        } else {
            ((Node)node)._next._previous = newNode;
            newNode._next = ((Node)node)._next;
        }
        ((Node)node)._next = newNode;
        newNode._previous = (Node)node;
        assert (((Node)this._first)._previous == null);
        assert (((Node)this._last)._next == null);
    }

    public void addBefore(Node<T> node, T value) {
        if (((Node)node)._owner != this) {
            throw new IllegalArgumentException("node not in list");
        }
        Node newNode = new Node(this, value);
        ++this._size;
        ++this.modCount;
        if (node == this._first) {
            this._first = newNode;
        } else {
            ((Node)node)._previous._next = newNode;
            newNode._previous = ((Node)node)._previous;
        }
        ((Node)node)._previous = newNode;
        newNode._next = (Node)node;
        assert (((Node)this._first)._previous == null);
        assert (((Node)this._last)._next == null);
    }

    public int countNodes() {
        int size = 0;
        Node node = this._first;
        while (node != null) {
            ++size;
            node = node._next;
        }
        return size;
    }

    public Node<T> findFirstNode(T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        Node node = this._first;
        while (node != null) {
            if (value.equals(node._value)) {
                return node;
            }
            node = node._next;
        }
        return null;
    }

    public Node<T> findLastNode(T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        Node node = this._last;
        while (node != null) {
            if (value.equals(node._value)) {
                return node;
            }
            node = node._previous;
        }
        return null;
    }

    public Node<T> getNode(int index) {
        if (index < this._size / 2) {
            int i = 0;
            Node node = this._first;
            while (node != null) {
                if (i == index) {
                    return node;
                }
                node = node._next;
                ++i;
            }
            throw new IndexOutOfBoundsException("index < 0");
        }
        int i = this._size - 1;
        Node node = this._last;
        while (node != null) {
            if (i == index) {
                return node;
            }
            node = node._previous;
            --i;
        }
        throw new IndexOutOfBoundsException("index >= size");
    }

    public void remove(Node<T> node) {
        if (((Node)node)._owner != this) {
            throw new IllegalArgumentException("node not in list");
        }
        --this._size;
        ++this.modCount;
        ((Node)node)._owner = null;
        if (this._first == this._last) {
            assert (node == this._first);
            this._last = null;
            this._first = null;
        } else if (node == this._first) {
            this._first = ((Node)node)._next;
            ((Node)this._first)._previous = null;
        } else if (node == this._last) {
            this._last = ((Node)node)._previous;
            ((Node)this._last)._next = null;
        } else {
            ((Node)node)._previous._next = ((Node)node)._next;
            ((Node)node)._next._previous = ((Node)node)._previous;
        }
        ((Node)node)._previous = null;
        ((Node)node)._next = null;
    }

    @Override
    public boolean add(T value) {
        this.addLast(value);
        return true;
    }

    @Override
    public void add(int index, T value) {
        if (index == this._size) {
            this.addLast(value);
        } else {
            Node<T> node = this.getNode(index);
            this.addBefore(node, value);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        if (index == this._size) {
            for (T value : collection) {
                this.addLast(value);
            }
        } else {
            Node<T> node = this.getNode(index);
            for (T value : collection) {
                this.addBefore(node, value);
            }
        }
        return !collection.isEmpty();
    }

    @Override
    public void clear() {
        if (this._size == 0) {
            assert (this._first == null);
            assert (this._last == null);
            return;
        }
        Node node = this._first;
        while (node != null) {
            node._owner = null;
            if (node._previous != null) {
                node._previous._next = null;
                node._previous = null;
            }
            node = node._next;
        }
        ((Node)this._last)._previous = null;
        this._last = null;
        this._first = null;
        this._size = 0;
        ++this.modCount;
    }

    @Override
    public boolean contains(Object obj) {
        Node<Object> node = this.findFirstNode(obj);
        return node != null;
    }

    @Override
    public T get(int index) {
        Node<T> node = this.getNode(index);
        return (T)((Node)node)._value;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new NodeIterator(index);
    }

    @Override
    public T remove(int index) {
        Node<T> node = this.getNode(index);
        this.remove(node);
        return (T)((Node)node)._value;
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeFirstOccurrence(obj);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > this._size) {
            throw new IndexOutOfBoundsException("toIndex > size");
        }
        if (fromIndex == this._size || fromIndex == toIndex) {
            return;
        }
        Node node = this.getNode(fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            Node next = node._next;
            this.remove(node);
            node = next;
        }
    }

    @Override
    public T set(int index, T value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        Node<T> node = this.getNode(index);
        Object oldValue = ((Node)node)._value;
        ((Node)node)._value = value;
        return (T)oldValue;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void addFirst(T value) {
        Node newNode = new Node(this, value);
        ++this._size;
        ++this.modCount;
        if (this._first == null) {
            assert (this._last == null);
            this._last = newNode;
            this._first = this._last;
        } else {
            assert (this._last != null);
            ((Node)this._first)._previous = newNode;
            newNode._next = (Node)this._first;
            this._first = newNode;
        }
        assert (((Node)this._first)._previous == null);
        assert (((Node)this._last)._next == null);
    }

    @Override
    public void addLast(T value) {
        Node newNode = new Node(this, value);
        ++this._size;
        ++this.modCount;
        if (this._first == null) {
            assert (this._last == null);
            this._last = newNode;
            this._first = this._last;
        } else {
            assert (this._last != null);
            ((Node)this._last)._next = newNode;
            newNode._previous = (Node)this._last;
            this._last = newNode;
        }
        assert (((Node)this._first)._previous == null);
        assert (((Node)this._last)._next == null);
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new ReverseNodeIterator();
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public T getFirst() {
        if (this._first == null) {
            throw new NoSuchElementException("empty list");
        }
        return (T)((Node)this._first)._value;
    }

    @Override
    public T getLast() {
        if (this._last == null) {
            throw new NoSuchElementException("empty list");
        }
        return (T)((Node)this._last)._value;
    }

    @Override
    public boolean offer(T value) {
        this.addLast(value);
        return true;
    }

    @Override
    public boolean offerFirst(T value) {
        this.addFirst(value);
        return true;
    }

    @Override
    public boolean offerLast(T value) {
        this.addLast(value);
        return true;
    }

    @Override
    public T peek() {
        return this.peekFirst();
    }

    @Override
    public T peekFirst() {
        return (T)(this._first == null ? null : ((Node)this._first)._value);
    }

    @Override
    public T peekLast() {
        return (T)(this._last == null ? null : ((Node)this._last)._value);
    }

    @Override
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public T pollFirst() {
        return this._first == null ? null : (T)this.removeFirst();
    }

    @Override
    public T pollLast() {
        return this._last == null ? null : (T)this.removeLast();
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public void push(T value) {
        this.addFirst(value);
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    @Override
    public T removeFirst() {
        if (this._first == null) {
            throw new NoSuchElementException("empty list");
        }
        --this._size;
        ++this.modCount;
        ((Node)this._first)._owner = null;
        assert (((Node)this._first)._previous == null);
        Object value = ((Node)this._first)._value;
        if (this._first == this._last) {
            assert (((Node)this._first)._next == null);
            this._last = null;
            this._first = null;
        } else {
            this._first = ((Node)this._first)._next;
            ((Node)this._first)._previous._next = null;
            ((Node)this._first)._previous = null;
        }
        return (T)value;
    }

    @Override
    public boolean removeFirstOccurrence(Object obj) {
        Node<Object> node = this.findFirstNode(obj);
        if (node == null) {
            return false;
        }
        this.remove(node);
        return true;
    }

    @Override
    public T removeLast() {
        if (this._last == null) {
            throw new NoSuchElementException("empty list");
        }
        --this._size;
        ++this.modCount;
        ((Node)this._last)._owner = null;
        assert (((Node)this._last)._next == null);
        Object value = ((Node)this._last)._value;
        if (this._first == this._last) {
            assert (((Node)this._first)._previous == null);
            this._last = null;
            this._first = null;
        } else {
            this._last = ((Node)this._last)._previous;
            ((Node)this._last)._next._previous = null;
            ((Node)this._last)._next = null;
        }
        return (T)value;
    }

    @Override
    public boolean removeLastOccurrence(Object obj) {
        Node<Object> node = this.findLastNode(obj);
        if (node == null) {
            return false;
        }
        this.remove(node);
        return true;
    }

    private final class ReverseNodeIterator
    implements Iterator<T> {
        private int _expectedModCount;
        private Node<T> _nextNode;
        private Node<T> _gotNode;

        ReverseNodeIterator() {
            this._expectedModCount = NodeList.this.modCount;
            this._nextNode = NodeList.this._last;
        }

        @Override
        public boolean hasNext() {
            return this._nextNode != null;
        }

        @Override
        public T next() {
            if (this._nextNode == null) {
                throw new NoSuchElementException("no next element");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this._gotNode = this._nextNode;
            this._nextNode = this._nextNode._previous;
            return this._gotNode._value;
        }

        @Override
        public void remove() {
            if (this._gotNode == null) {
                throw new IllegalStateException("no next result");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            NodeList.this.remove(this._gotNode);
            ++this._expectedModCount;
            this._gotNode = null;
        }
    }

    private final class NodeIterator
    implements ListIterator<T> {
        private int _nextIndex;
        private int _expectedModCount;
        private Node<T> _nextNode;
        private Node<T> _gotNode;

        NodeIterator() {
            this._expectedModCount = NodeList.this.modCount;
            this._nextIndex = 0;
            this._nextNode = NodeList.this._first;
        }

        NodeIterator(int index) {
            this._expectedModCount = NodeList.this.modCount;
            this._nextIndex = index;
            this._nextNode = index == NodeList.this._size ? null : NodeList.this.getNode(index);
        }

        @Override
        public void add(T value) {
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this._nextNode == null) {
                NodeList.this.addLast(value);
            } else {
                NodeList.this.addBefore(this._nextNode, value);
            }
            ++this._expectedModCount;
            ++this._nextIndex;
            this._gotNode = null;
        }

        @Override
        public boolean hasNext() {
            return this._nextNode != null;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex > 0;
        }

        @Override
        public T next() {
            if (this._nextNode == null) {
                throw new NoSuchElementException("no next element");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ++this._nextIndex;
            this._gotNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._gotNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextNode == null ? this._nextIndex : this._nextIndex + 1;
        }

        @Override
        public T previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException("no previous element");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            --this._nextIndex;
            this._nextNode = this._nextNode == null ? NodeList.this._last : this._nextNode._previous;
            this._gotNode = this._nextNode;
            return this._gotNode._value;
        }

        @Override
        public int previousIndex() {
            assert (this._nextIndex >= 0);
            return this._nextIndex - 1;
        }

        @Override
        public void remove() {
            if (this._gotNode == null) {
                throw new IllegalStateException("no next/previous result");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this._nextNode == this._gotNode) {
                this._nextNode = this._nextNode._next;
            }
            NodeList.this.remove(this._gotNode);
            ++this._expectedModCount;
            this._gotNode = null;
        }

        @Override
        public void set(T value) {
            if (this._gotNode == null) {
                throw new IllegalStateException("no next/previous result");
            }
            if (NodeList.this.modCount != this._expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            this._gotNode._value = value;
        }
    }

    public static final class Node<T> {
        private NodeList<T> _owner;
        private T _value;
        private Node<T> _next;
        private Node<T> _previous;

        private Node(NodeList<T> owner, T value) {
            if (owner == null) {
                throw new NullPointerException("owner");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            this._owner = owner;
            this._value = value;
        }

        public Node<T> next() {
            return this._next;
        }

        public NodeList<T> owner() {
            return this._owner;
        }

        public Node<T> previous() {
            return this._previous;
        }

        public void setValue(T value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            this._value = value;
        }

        public T value() {
            return this._value;
        }
    }
}

