/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.RectD;

public class QuadTree<V>
extends AbstractMap<PointD, V> {
    public static final int MAX_LEVEL = 14;
    public static final int PROBE_LEVEL = 4;
    public final RectD bounds;
    public final int capacity;
    public final Node<V> rootNode;
    private final EntrySet _entrySet = new EntrySet();
    private final ProbeStatus _probe = new ProbeStatus();
    private final HashMap<Integer, Node<V>> _nodes;
    private int _size;

    public QuadTree(RectD bounds) {
        this(bounds, 128);
    }

    public QuadTree(RectD bounds, int capacity) {
        if (bounds.width() <= 0.0) {
            throw new IllegalArgumentException("bounds.width <= 0");
        }
        if (bounds.height() <= 0.0) {
            throw new IllegalArgumentException("bounds.height <= 0");
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        this.bounds = bounds;
        this.capacity = capacity;
        this._nodes = new HashMap();
        this.rootNode = new Node(this, 0, null, bounds);
    }

    public QuadTree(RectD bounds, Map<PointD, V> map) {
        this(bounds, 128);
        this.putAll(map);
    }

    public boolean containsKey(PointD key, Node<V> node) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (this.checkLeaf(node) && ((Node)node)._entries.containsKey(key)) {
            return true;
        }
        node = this.findNode(key);
        return this.checkLeaf(node) && ((Node)node)._entries.containsKey(key);
    }

    public boolean containsValue(V value, Node<V> node) {
        if (this.checkLeaf(node) && ((Node)node)._entries.containsValue(value)) {
            return true;
        }
        node = this.findNodeByValue(value);
        return node != null;
    }

    public void copyTo(Map.Entry<PointD, V>[] array, int arrayIndex) {
        for (Map.Entry<PointD, V> entry : this.entrySet()) {
            array[arrayIndex++] = entry;
        }
    }

    public Node<V> findNode(int level, int gridX, int gridY) {
        if (level < 0 || level > 14) {
            return null;
        }
        int sideCount = 1 << level;
        if (gridX < 0 || gridX >= sideCount || gridY < 0 || gridY >= sideCount) {
            return null;
        }
        int signature = level | gridX << 4 | gridY << 18;
        return this._nodes.get(signature);
    }

    public Node<V> findNode(PointD key) {
        Node<V> node;
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.bounds.contains(key)) {
            return null;
        }
        int count = this._nodes.size() >> 8;
        if (count == 0) {
            node = this.rootNode;
        } else {
            int signature;
            int level = this._probe.level;
            int gridCount = 1 << level;
            if (count != this._probe.nodeCount) {
                if (this._probe.useBitMask) {
                    level = (count & 0xF00000) != 0 ? 14 : ((count & 0xFC0000) != 0 ? 13 : ((count & 0xFF0000) != 0 ? 12 : ((count & 0xFFC000) != 0 ? 11 : ((count & 0xFFF000) != 0 ? 10 : ((count & 0xFFFC00) != 0 ? 9 : ((count & 0xFFFF00) != 0 ? 8 : ((count & 0xFFFFC0) != 0 ? 7 : ((count & 0xFFFFF0) != 0 ? 6 : ((count & 0xFFFFFC) != 0 ? 5 : 4)))))))));
                } else {
                    level = 1;
                    while (count >> (level << 1) > 0) {
                        ++level;
                    }
                    if ((level += 3) > 14) {
                        level = 14;
                    }
                }
                this._probe.level = level;
                this._probe.nodeCount = count;
                gridCount = 1 << level;
                this._probe.gridWidth = this.bounds.width() / (double)gridCount;
                this._probe.gridHeight = this.bounds.height() / (double)gridCount;
            }
            int gridX = (int)((key.x - this.bounds.min.x) / this._probe.gridWidth);
            int gridY = (int)((key.y - this.bounds.min.y) / this._probe.gridHeight);
            if (gridX == gridCount) {
                --gridX;
            }
            if (gridY == gridCount) {
                --gridY;
            }
            assert (gridX >= 0 && gridX < gridCount);
            assert (gridY >= 0 && gridY < gridCount);
            while ((node = this._nodes.get(signature = level | gridX << 4 | gridY << 18)) == null || !node.bounds.containsOpen(key)) {
                if (level < 4) {
                    node = this.rootNode;
                    break;
                }
                level -= 2;
                gridX >>= 2;
                gridY >>= 2;
            }
        }
        assert (node != null);
        Node<V> child;
        while ((child = ((Node)node).findChild(key)) != null) {
            node = child;
        }
        return node;
    }

    public Node<V> findNodeByValue(V value) {
        for (Node<V> node : this._nodes.values()) {
            if (((Node)node)._entries == null || !((Node)node)._entries.containsValue(value)) continue;
            return node;
        }
        return null;
    }

    public Map<PointD, V> findRange(PointD center, double radius) {
        RectD range = new RectD(center.x - radius, center.y - radius, center.x + radius, center.y + radius);
        HashMap map = new HashMap();
        if (!this.bounds.intersectsWith(range)) {
            return map;
        }
        ((Node)this.rootNode).findRange(range, true, map);
        return map;
    }

    public Map<PointD, V> findRange(RectD range) {
        HashMap map = new HashMap();
        if (!this.bounds.intersectsWith(range)) {
            return map;
        }
        ((Node)this.rootNode).findRange(range, false, map);
        return map;
    }

    public Node<V> move(PointD oldKey, PointD newKey, Node<V> node) {
        if (!(this.checkLeaf(node) && ((Node)node)._entries.containsKey(oldKey) || (node = this.findNode(oldKey)) != null)) {
            throw new NoSuchElementException("oldKey");
        }
        Object value = ((Node)node)._entries.get(oldKey);
        ((Node)node)._entries.remove(oldKey);
        if (node.bounds.containsOpen(newKey)) {
            ((Node)node)._entries.put(newKey, value);
        } else {
            --this._size;
            if (((Node)node)._entries.isEmpty() && node.parent != null) {
                node.parent.removeChild((Node)node);
                node = null;
            }
            this.put(newKey, value);
        }
        return node;
    }

    public Map<Integer, Node<V>> nodes() {
        return Collections.unmodifiableMap(this._nodes);
    }

    public void setProbeUseBitMask(boolean value) {
        this._probe.useBitMask = value;
    }

    private boolean checkLeaf(Node<V> node) {
        if (node == null) {
            return false;
        }
        if (((Node)node)._owner != this) {
            throw new IllegalArgumentException("node not in tree");
        }
        return ((Node)node)._entries != null;
    }

    @Override
    public boolean containsKey(Object key) {
        PointD realKey = (PointD)key;
        Node<V> node = this.findNode(realKey);
        return this.checkLeaf(node) && ((Node)node)._entries.containsKey(realKey);
    }

    @Override
    public boolean containsValue(Object value) {
        Object realValue = value;
        return this.findNodeByValue(realValue) != null;
    }

    @Override
    public Set<Map.Entry<PointD, V>> entrySet() {
        return this._entrySet;
    }

    @Override
    public V get(Object key) {
        Node<V> node = this.findNode((PointD)key);
        return this.checkLeaf(node) ? (V)((Node)node)._entries.get(key) : null;
    }

    @Override
    public V put(PointD key, V value) {
        Node node = this.findNode(key);
        if (node == null) {
            throw new IllegalArgumentException("key not in bounds");
        }
        if (node._entries != null && node._entries.containsKey(key)) {
            Object oldValue = node._entries.get(key);
            node._entries.put(key, value);
            return oldValue;
        }
        while (node.level() < 14 && !node.hasCapacity()) {
            if (node._entries != null) {
                node.split();
            }
            node = node.findOrCreateChild(key);
        }
        assert (!node._entries.containsKey(key));
        node._entries.put(key, value);
        ++this._size;
        return null;
    }

    @Override
    public void putAll(Map<? extends PointD, ? extends V> map) {
        for (Map.Entry<PointD, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        PointD realKey = (PointD)key;
        Node<V> node = this.findNode(realKey);
        if (!this.checkLeaf(node) || !((Node)node)._entries.containsKey(realKey)) {
            return null;
        }
        --this._size;
        Object oldValue = ((Node)node)._entries.get(realKey);
        ((Node)node)._entries.remove(realKey);
        if (((Node)node)._entries.isEmpty() && node.parent != null) {
            node.parent.removeChild((Node)node);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        PointD realKey = (PointD)key;
        Object realValue = value;
        Node<V> node = this.findNode(realKey);
        if (!this.checkLeaf(node) || !((Node)node)._entries.containsKey(realKey)) {
            return false;
        }
        if (!Objects.equals(realValue, ((Node)node)._entries.get(realKey))) {
            return false;
        }
        --this._size;
        ((Node)node)._entries.remove(realKey);
        if (((Node)node)._entries.isEmpty() && node.parent != null) {
            node.parent.removeChild((Node)node);
        }
        return true;
    }

    @Override
    public V replace(PointD key, V value) {
        Node<V> node = this.findNode(key);
        if (!this.checkLeaf(node) || !((Node)node)._entries.containsKey(key)) {
            return null;
        }
        Object oldValue = ((Node)node)._entries.get(key);
        ((Node)node)._entries.put(key, value);
        return oldValue;
    }

    @Override
    public boolean replace(PointD key, V oldValue, V newValue) {
        Node<V> node = this.findNode(key);
        if (!this.checkLeaf(node) || !((Node)node)._entries.containsKey(key)) {
            return false;
        }
        if (!Objects.equals(oldValue, ((Node)node)._entries.get(key))) {
            return false;
        }
        ((Node)node)._entries.put(key, newValue);
        return true;
    }

    private static final class ProbeStatus {
        double gridHeight;
        double gridWidth;
        int level;
        int nodeCount;
        boolean useBitMask;

        private ProbeStatus() {
        }
    }

    public static final class Node<V> {
        private Node<V> _minXminY;
        private Node<V> _minXmaxY;
        private Node<V> _maxXminY;
        private Node<V> _maxXmaxY;
        private Map<PointD, V> _entries;
        private QuadTree<V> _owner;
        public final RectD bounds;
        public final PointD center;
        public final Node<V> parent;
        public final int signature;

        private Node(QuadTree<V> tree, int signature, Node<V> parent, RectD bounds) {
            if (tree == null) {
                throw new NullPointerException("tree");
            }
            if (bounds.width() <= 0.0) {
                throw new IllegalArgumentException("bounds.width < 0");
            }
            if (bounds.height() <= 0.0) {
                throw new IllegalArgumentException("bounds.height < 0");
            }
            this._owner = tree;
            this.signature = signature;
            this.parent = parent;
            this.bounds = bounds;
            this.center = bounds.center();
            this._entries = new HashMap<PointD, V>(tree.capacity);
            ((QuadTree)tree)._nodes.put(this.signature, this);
        }

        public Map<PointD, V> entries() {
            return this._entries == null ? null : Collections.unmodifiableMap(this._entries);
        }

        public int gridX() {
            return (this.signature & 0x3FFF0) >> 4;
        }

        public int gridY() {
            return (this.signature & 0xFFFC0000) >> 18;
        }

        public boolean hasCapacity() {
            return this._entries != null && this._entries.size() < this._owner.capacity;
        }

        public boolean isLeaf() {
            return this._entries != null;
        }

        public int level() {
            return this.signature & 0xF;
        }

        public Node<V> maxXmaxY() {
            return this._maxXmaxY;
        }

        public Node<V> maxXminY() {
            return this._maxXminY;
        }

        public Node<V> minXmaxY() {
            return this._minXmaxY;
        }

        public Node<V> minXminY() {
            return this._minXminY;
        }

        public QuadTree<V> owner() {
            return this._owner;
        }

        private void clear() {
            if (this._owner == null) {
                throw new IllegalStateException("node already removed");
            }
            this._maxXmaxY = null;
            this._minXmaxY = null;
            this._maxXminY = null;
            this._minXminY = null;
            if (this._entries != null) {
                this._entries.clear();
            }
            if (this != this._owner.rootNode) {
                this._entries = null;
                this._owner = null;
            } else if (this._entries == null) {
                this._entries = new HashMap<PointD, V>(this._owner.capacity);
            }
        }

        private Node<V> createChild(int deltaX, int deltaY) {
            double maxY;
            double minY;
            double maxX;
            double minX;
            assert (deltaX == 0 || deltaX == 1);
            assert (deltaY == 0 || deltaY == 1);
            int x = (this.gridX() << 1) + deltaX;
            int y = (this.gridY() << 1) + deltaY;
            int sig = this.level() + 1 | x << 4 | y << 18;
            if (deltaX == 0) {
                minX = this.bounds.min.x;
                maxX = this.center.x;
            } else {
                minX = this.center.x;
                maxX = this.bounds.max.x;
            }
            if (deltaY == 0) {
                minY = this.bounds.min.y;
                maxY = this.center.y;
            } else {
                minY = this.center.y;
                maxY = this.bounds.max.y;
            }
            return new Node<V>(this._owner, sig, this, new RectD(minX, minY, maxX, maxY));
        }

        private Node<V> findChild(PointD key) {
            assert (this.bounds.contains(key));
            double relX = key.x - this.center.x;
            double relY = key.y - this.center.y;
            return relX < 0.0 ? (relY < 0.0 ? this._minXminY : this._minXmaxY) : (relY < 0.0 ? this._maxXminY : this._maxXmaxY);
        }

        private Node<V> findOrCreateChild(PointD key) {
            assert (this.bounds.contains(key));
            double relX = key.x - this.center.x;
            double relY = key.y - this.center.y;
            if (relX < 0.0) {
                if (relY < 0.0) {
                    if (this._minXminY == null) {
                        this._minXminY = this.createChild(0, 0);
                    }
                    return this._minXminY;
                }
                if (this._minXmaxY == null) {
                    this._minXmaxY = this.createChild(0, 1);
                }
                return this._minXmaxY;
            }
            if (relY < 0.0) {
                if (this._maxXminY == null) {
                    this._maxXminY = this.createChild(1, 0);
                }
                return this._maxXminY;
            }
            if (this._maxXmaxY == null) {
                this._maxXmaxY = this.createChild(1, 1);
            }
            return this._maxXmaxY;
        }

        private void findRange(RectD range, boolean useCircle, Map<PointD, V> output) {
            boolean rightRange;
            assert (this.bounds.intersectsWith(range));
            if (this._entries != null) {
                if (useCircle) {
                    double radius = range.width() / 2.0;
                    double x = range.min.x + radius;
                    double y = range.min.y + radius;
                    for (Map.Entry<PointD, V> pair : this._entries.entrySet()) {
                        double dy;
                        double dx;
                        PointD key = pair.getKey();
                        if (!range.contains(key) || !((dx = key.x - x) * dx + (dy = key.y - y) * dy <= radius * radius)) continue;
                        output.put(key, pair.getValue());
                    }
                } else {
                    for (Map.Entry<PointD, V> pair : this._entries.entrySet()) {
                        if (!range.contains(pair.getKey())) continue;
                        output.put(pair.getKey(), pair.getValue());
                    }
                }
                return;
            }
            boolean topRange = range.min.y < this.center.y;
            boolean bottomRange = range.max.y >= this.center.y;
            boolean leftRange = range.min.x < this.center.x;
            boolean bl = rightRange = range.max.x >= this.center.x;
            if (topRange) {
                if (leftRange && this._minXminY != null) {
                    super.findRange(range, useCircle, output);
                }
                if (rightRange && this._maxXminY != null) {
                    super.findRange(range, useCircle, output);
                }
            }
            if (bottomRange) {
                if (leftRange && this._minXmaxY != null) {
                    super.findRange(range, useCircle, output);
                }
                if (rightRange && this._maxXmaxY != null) {
                    super.findRange(range, useCircle, output);
                }
            }
        }

        private void removeChild(Node<V> child) {
            if (child == this._minXminY) {
                ((QuadTree)this._owner)._nodes.remove(this._minXminY.signature);
                this._minXminY = null;
            } else if (child == this._maxXminY) {
                ((QuadTree)this._owner)._nodes.remove(this._maxXminY.signature);
                this._maxXminY = null;
            } else if (child == this._minXmaxY) {
                ((QuadTree)this._owner)._nodes.remove(this._minXmaxY.signature);
                this._minXmaxY = null;
            } else if (child == this._maxXmaxY) {
                ((QuadTree)this._owner)._nodes.remove(this._maxXmaxY.signature);
                this._maxXmaxY = null;
            } else {
                throw new IllegalArgumentException("child is not a child node");
            }
            if (this._minXminY == null && this._minXmaxY == null && this._maxXminY == null && this._maxXmaxY == null) {
                if (this.parent == null) {
                    this._entries = new HashMap<PointD, V>(this._owner.capacity);
                } else {
                    super.removeChild(this);
                }
            }
        }

        private void split() {
            for (Map.Entry<PointD, V> pair : this._entries.entrySet()) {
                PointD key = pair.getKey();
                Node<V> child = this.findOrCreateChild(key);
                child._entries.put(key, pair.getValue());
            }
            this._entries = null;
        }
    }

    private final class EntryIterator
    implements Iterator<Map.Entry<PointD, V>> {
        private final Iterator<Node<V>> _nodeIter;
        private Iterator<Map.Entry<PointD, V>> _entryIter;
        private int _index;

        private EntryIterator() {
            this._nodeIter = QuadTree.this._nodes.values().iterator();
            this._entryIter = null;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < QuadTree.this._size;
        }

        @Override
        public Map.Entry<PointD, V> next() {
            Node node;
            ++this._index;
            if (this._entryIter != null && this._entryIter.hasNext()) {
                return this._entryIter.next();
            }
            while (!QuadTree.this.checkLeaf(node = this._nodeIter.next()) || node._entries.isEmpty()) {
            }
            this._entryIter = node._entries.entrySet().iterator();
            return this._entryIter.next();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<PointD, V>> {
        private EntrySet() {
        }

        @Override
        public boolean add(Map.Entry<PointD, V> entry) {
            int oldSize = QuadTree.this._size;
            Object value = entry.getValue();
            boolean changed = !Objects.equals(value, QuadTree.this.put(entry.getKey(), value));
            return changed || oldSize != QuadTree.this._size;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<PointD, V>> collection) {
            int oldSize = QuadTree.this._size;
            boolean changed = false;
            for (Map.Entry entry : collection) {
                Object value = entry.getValue();
                if (Objects.equals(value, QuadTree.this.put(entry.getKey(), value))) continue;
                changed = true;
            }
            return changed || oldSize != QuadTree.this._size;
        }

        @Override
        public void clear() {
            if (QuadTree.this._size == 0) {
                assert (QuadTree.this._nodes.size() == 1);
                assert (QuadTree.this._nodes.get(0) == QuadTree.this.rootNode);
                return;
            }
            for (Node node : QuadTree.this._nodes.values()) {
                node.clear();
            }
            QuadTree.this._nodes.clear();
            QuadTree.this._nodes.put(0, QuadTree.this.rootNode);
            QuadTree.this._size = 0;
        }

        @Override
        public boolean contains(Object obj) {
            Map.Entry entry = (Map.Entry)obj;
            PointD key = (PointD)entry.getKey();
            Node node = QuadTree.this.findNode(key);
            if (!QuadTree.this.checkLeaf(node) || !node._entries.containsKey(key)) {
                return false;
            }
            Object value = node._entries.get(key);
            return Objects.equals(value, entry.getValue());
        }

        @Override
        public boolean isEmpty() {
            return QuadTree.this._size == 0;
        }

        @Override
        public Iterator<Map.Entry<PointD, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object obj) {
            Map.Entry entry = (Map.Entry)obj;
            return QuadTree.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return QuadTree.this._size;
        }
    }
}

