/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.geometry.Compass;

public final class Angle {
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;

    private Angle() {
    }

    public static Compass degreesToCompass(double degrees) {
        degrees = Fortran.modulo(degrees + 22.5, 360.0);
        int point = (int)(degrees / 45.0);
        return Compass.fromDegrees(point * 45);
    }

    public static double distanceDegrees(double start, double end) {
        double dist = end - start;
        if (dist > 180.0) {
            dist -= 360.0;
        } else if (dist <= -180.0) {
            dist += 360.0;
        }
        return dist;
    }

    public static double distanceRadians(double start, double end) {
        double dist = end - start;
        if (dist > Math.PI) {
            dist -= Math.PI * 2;
        } else if (dist <= -Math.PI) {
            dist += Math.PI * 2;
        }
        return dist;
    }

    public static double normalizeDegrees(double degrees) {
        if ((degrees %= 360.0) < 0.0) {
            degrees += 360.0;
        }
        return degrees;
    }

    public static int normalizeRoundedDegrees(double degrees) {
        int angle = Fortran.nint(degrees);
        if ((angle %= 360) < 0) {
            angle += 360;
        }
        return angle;
    }

    public static double normalizeRadians(double radians) {
        if ((radians %= Math.PI * 2) < 0.0) {
            radians += Math.PI * 2;
        }
        return radians;
    }
}

