/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineI;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparator;
import org.kynosarges.tektosyne.geometry.PointDComparatorY;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.PolygonLocation;
import org.kynosarges.tektosyne.geometry.RectD;
import org.kynosarges.tektosyne.geometry.RectI;
import org.kynosarges.tektosyne.geometry.SizeD;
import org.kynosarges.tektosyne.geometry.SizeI;

public final class GeoUtils {
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    private GeoUtils() {
    }

    public static LineD[] connectPoints(boolean isClosed, PointD ... points) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        if (points.length < 2) {
            return new LineD[0];
        }
        LineD[] lines = new LineD[isClosed ? points.length : points.length - 1];
        for (int i = 0; i < points.length - 1; ++i) {
            lines[i] = new LineD(points[i], points[i + 1]);
        }
        if (isClosed) {
            lines[lines.length - 1] = new LineD(points[points.length - 1], points[0]);
        }
        return lines;
    }

    public static PointD[] convexHull(PointD ... points) {
        int i;
        if (points == null || points.length == 0) {
            throw new NullPointerException("points");
        }
        switch (points.length) {
            case 1: {
                return new PointD[]{points[0]};
            }
            case 2: {
                if (points[0] == points[1]) {
                    return new PointD[]{points[0]};
                }
                return new PointD[]{points[0], points[1]};
            }
        }
        ConvexHullVertex[] p = new ConvexHullVertex[points.length];
        PointD pnv = points[0];
        p[0] = new ConvexHullVertex(pnv, 0);
        int n = 0;
        for (i = 1; i < p.length; ++i) {
            PointD piv = points[i];
            p[i] = new ConvexHullVertex(piv, i);
            int result = PointDComparatorY.compareExact(piv, pnv);
            if (result < 0) {
                n = i;
                pnv = piv;
                continue;
            }
            if (result != 0) continue;
            p[i].delete = true;
        }
        if (n > 0) {
            ConvexHullVertex swap = p[0];
            p[0] = p[n];
            p[n] = swap;
        }
        Arrays.sort(p, 1, p.length, new ConvexHullVertexComparator(p[0]));
        n = 0;
        for (i = 0; i < p.length; ++i) {
            if (p[i].delete) continue;
            p[n++] = p[i];
        }
        if (n == 1) {
            return new PointD[]{p[0].vertex};
        }
        ConvexHullVertex top = p[1];
        top.next = p[0];
        int hullCount = 2;
        i = 2;
        while (i < n) {
            ConvexHullVertex pi = p[i];
            if (top.next.vertex.crossProductLength(top.vertex, pi.vertex) > 0.0) {
                pi.next = top;
                top = pi;
                ++i;
                ++hullCount;
                continue;
            }
            top = top.next;
            --hullCount;
        }
        PointD[] hull = new PointD[hullCount];
        for (i = 0; i < hull.length; ++i) {
            hull[i] = top.vertex;
            top = top.next;
        }
        assert (top == null);
        return hull;
    }

    public static <T> T[] fromDoubles(Class<T> type, double ... items) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type == LineD.class) {
            return LineD.fromDoubles(items);
        }
        if (type == PointD.class) {
            return PointD.fromDoubles(items);
        }
        if (type == RectD.class) {
            return RectD.fromDoubles(items);
        }
        if (type == SizeD.class) {
            return SizeD.fromDoubles(items);
        }
        throw new IllegalArgumentException("type != LineD, PointD, RectD, SizeD");
    }

    public static <T> T[] fromInts(Class<T> type, int ... items) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type == LineI.class) {
            return LineI.fromInts(items);
        }
        if (type == PointI.class) {
            return PointI.fromInts(items);
        }
        if (type == RectI.class) {
            return RectI.fromInts(items);
        }
        if (type == SizeI.class) {
            return SizeI.fromInts(items);
        }
        throw new IllegalArgumentException("type != LineI, PointI, RectI, SizeI");
    }

    public static int nearestPoint(List<PointD> points, PointD q) {
        if (points == null || points.isEmpty()) {
            throw new NullPointerException("points");
        }
        PointD vector = q.subtract(points.get(0));
        double minDistance = vector.lengthSquared();
        if (minDistance == 0.0) {
            return 0;
        }
        int minIndex = 0;
        for (int i = 1; i < points.size(); ++i) {
            vector = q.subtract(points.get(i));
            double distance = vector.lengthSquared();
            if (!(minDistance > distance)) continue;
            if (distance == 0.0) {
                return i;
            }
            minDistance = distance;
            minIndex = i;
        }
        return minIndex;
    }

    public static PolygonLocation pointInPolygon(PointD q, PointD[] polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon");
        }
        if (polygon.length < 3) {
            throw new IllegalArgumentException("polygon.length < 3");
        }
        int rightCrossings = 0;
        int leftCrossings = 0;
        int lastIndex = polygon.length - 1;
        double x1 = polygon[lastIndex].x - q.x;
        double y1 = polygon[lastIndex].y - q.y;
        for (PointD vertex : polygon) {
            boolean leftStraddle;
            double x0 = vertex.x - q.x;
            double y0 = vertex.y - q.y;
            if (x0 == 0.0 && y0 == 0.0) {
                return PolygonLocation.VERTEX;
            }
            boolean rightStraddle = y0 > 0.0 != y1 > 0.0;
            boolean bl = leftStraddle = y0 < 0.0 != y1 < 0.0;
            if (rightStraddle || leftStraddle) {
                double x = (x0 * y1 - x1 * y0) / (y1 - y0);
                if (rightStraddle && x > 0.0) {
                    ++rightCrossings;
                }
                if (leftStraddle && x < 0.0) {
                    ++leftCrossings;
                }
            }
            x1 = x0;
            y1 = y0;
        }
        if (rightCrossings % 2 != leftCrossings % 2) {
            return PolygonLocation.EDGE;
        }
        return rightCrossings % 2 != 0 ? PolygonLocation.INSIDE : PolygonLocation.OUTSIDE;
    }

    public static PolygonLocation pointInPolygon(PointD q, PointD[] polygon, double epsilon) {
        if (polygon == null) {
            throw new NullPointerException("polygon");
        }
        if (polygon.length < 3) {
            throw new IllegalArgumentException("polygon.length < 3");
        }
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("epsilon <= 0");
        }
        int rightCrossings = 0;
        int leftCrossings = 0;
        int lastIndex = polygon.length - 1;
        double x1 = polygon[lastIndex].x - q.x;
        double y1 = polygon[lastIndex].y - q.y;
        int dy1 = MathUtils.compare(y1, 0.0, epsilon);
        for (PointD vertex : polygon) {
            boolean leftStraddle;
            double x0 = vertex.x - q.x;
            double y0 = vertex.y - q.y;
            int dx0 = MathUtils.compare(x0, 0.0, epsilon);
            int dy0 = MathUtils.compare(y0, 0.0, epsilon);
            if (dx0 == 0 && dy0 == 0) {
                return PolygonLocation.VERTEX;
            }
            boolean rightStraddle = dy0 > 0 != dy1 > 0;
            boolean bl = leftStraddle = dy0 < 0 != dy1 < 0;
            if (rightStraddle || leftStraddle) {
                double x = (x0 * y1 - x1 * y0) / (y1 - y0);
                int dx = MathUtils.compare(x, 0.0, epsilon);
                if (rightStraddle && dx > 0) {
                    ++rightCrossings;
                }
                if (leftStraddle && dx < 0) {
                    ++leftCrossings;
                }
            }
            x1 = x0;
            y1 = y0;
            dy1 = dy0;
        }
        if (rightCrossings % 2 != leftCrossings % 2) {
            return PolygonLocation.EDGE;
        }
        return rightCrossings % 2 != 0 ? PolygonLocation.INSIDE : PolygonLocation.OUTSIDE;
    }

    public static double polygonArea(PointD ... polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon");
        }
        if (polygon.length < 3) {
            throw new IllegalArgumentException("polygon.length < 3");
        }
        double area = 0.0;
        int i = polygon.length - 1;
        int j = 0;
        while (j < polygon.length) {
            area += polygon[i].x * polygon[j].y - polygon[j].x * polygon[i].y;
            i = j++;
        }
        return area / 2.0;
    }

    public static PointD polygonCentroid(PointD ... polygon) {
        if (polygon == null) {
            throw new NullPointerException("polygon");
        }
        if (polygon.length < 3) {
            throw new IllegalArgumentException("polygon.length < 3");
        }
        double area = 0.0;
        double x = 0.0;
        double y = 0.0;
        int i = polygon.length - 1;
        int j = 0;
        while (j < polygon.length) {
            double factor = polygon[i].x * polygon[j].y - polygon[j].x * polygon[i].y;
            area += factor;
            x += (polygon[i].x + polygon[j].x) * factor;
            y += (polygon[i].y + polygon[j].y) * factor;
            i = j++;
        }
        return new PointD(x / (area *= 3.0), y / area);
    }

    public static LineD randomLine(double x, double y, double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("width <= 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height <= 0");
        }
        return new LineD(x + RANDOM.nextDouble(width), y + RANDOM.nextDouble(height), x + RANDOM.nextDouble(width), y + RANDOM.nextDouble(height));
    }

    public static PointD randomPoint(double x, double y, double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("width <= 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height <= 0");
        }
        return new PointD(x + RANDOM.nextDouble(width), y + RANDOM.nextDouble(height));
    }

    public static PointD randomPoint(RectD bounds) {
        double width = bounds.width();
        double height = bounds.height();
        if (width == 0.0) {
            throw new IllegalArgumentException("bounds.width == 0");
        }
        if (height == 0.0) {
            throw new IllegalArgumentException("bounds.height == 0");
        }
        return new PointD(bounds.min.x + RANDOM.nextDouble(width), bounds.min.y + RANDOM.nextDouble(height));
    }

    public static PointD[] randomPoints(int count, RectD bounds) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        double width = bounds.width();
        double height = bounds.height();
        if (width == 0.0) {
            throw new IllegalArgumentException("bounds.width == 0");
        }
        if (height == 0.0) {
            throw new IllegalArgumentException("bounds.height == 0");
        }
        PointD[] points = new PointD[count];
        for (int i = 0; i < points.length; ++i) {
            points[i] = new PointD(bounds.min.x + RANDOM.nextDouble(width), bounds.min.y + RANDOM.nextDouble(height));
        }
        return points;
    }

    public static PointD[] randomPoints(int count, RectD bounds, PointDComparator comparer, double distance) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        if (comparer == null) {
            throw new NullPointerException("comparer");
        }
        if (distance <= 0.0) {
            throw new IllegalArgumentException("distance <= 0");
        }
        double width = bounds.width();
        double height = bounds.height();
        if (width == 0.0) {
            throw new IllegalArgumentException("bounds.width == 0");
        }
        if (height == 0.0) {
            throw new IllegalArgumentException("bounds.height == 0");
        }
        distance *= distance;
        ArrayList<PointD> points = new ArrayList<PointD>(count);
        for (int i = 0; i < count; ++i) {
            int index;
            PointD point;
            double length2;
            do {
                point = new PointD(bounds.min.x + RANDOM.nextDouble(width), bounds.min.y + RANDOM.nextDouble(height));
            } while (!points.isEmpty() && (length2 = point.subtract((PointD)points.get(index = comparer.findNearest(points, point))).lengthSquared()) < distance);
            points.add(point);
            points.sort(comparer);
        }
        return points.toArray(new PointD[count]);
    }

    public static PointD[] randomPolygon(double x, double y, double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("width < = 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height < = 0");
        }
        SizeD range = new SizeD(width / 2.0, height / 2.0);
        PointD center = new PointD(x + range.width, y + range.height);
        double radius = Math.sqrt(range.width * range.width + range.height * range.height);
        ArrayList<PointD> polygon = new ArrayList<PointD>();
        for (double degrees = 0.0; degrees < 360.0 && !((degrees += RANDOM.nextDouble(110.0)) >= 360.0); degrees += 6.0) {
            double radians = degrees * (Math.PI / 180);
            double dx = Math.cos(radians) * radius;
            double dy = Math.sin(radians) * radius;
            double dxLimit = range.width / Math.abs(dx);
            double dyLimit = range.height / Math.abs(dy);
            double factor = Math.min(dxLimit, dyLimit);
            polygon.add(new PointD(center.x + dx * (factor *= RANDOM.nextDouble()), center.y + dy * factor));
        }
        return polygon.toArray(new PointD[polygon.size()]);
    }

    public static RectD randomRect(double x, double y, double width, double height) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("width <= 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height <= 0");
        }
        return new RectD(x + RANDOM.nextDouble(width / 2.0), y + RANDOM.nextDouble(height / 2.0), x + width - RANDOM.nextDouble(width / 2.0), y + height - RANDOM.nextDouble(height / 2.0));
    }

    public static <T> double[] toDoubles(Class<T> type, T ... items) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type == LineD.class) {
            return LineD.toDoubles((LineD[])items);
        }
        if (type == PointD.class) {
            return PointD.toDoubles((PointD[])items);
        }
        if (type == RectD.class) {
            return RectD.toDoubles((RectD[])items);
        }
        if (type == SizeD.class) {
            return SizeD.toDoubles((SizeD[])items);
        }
        throw new IllegalArgumentException("type != LineD, PointD, RectD, SizeD");
    }

    public static <T> int[] toInts(Class<T> type, T ... items) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (type == LineI.class) {
            return LineI.toInts((LineI[])items);
        }
        if (type == PointI.class) {
            return PointI.toInts((PointI[])items);
        }
        if (type == RectI.class) {
            return RectI.toInts((RectI[])items);
        }
        if (type == SizeI.class) {
            return SizeI.toInts((SizeI[])items);
        }
        throw new IllegalArgumentException("type != LineI, PointI, RectI, SizeI");
    }

    private static class ConvexHullVertexComparator
    implements Comparator<ConvexHullVertex> {
        final PointD p0v;

        ConvexHullVertexComparator(ConvexHullVertex p0) {
            if (p0 == null) {
                throw new NullPointerException("p0");
            }
            this.p0v = p0.vertex;
        }

        @Override
        public int compare(ConvexHullVertex pi, ConvexHullVertex pj) {
            if (pi == pj) {
                return 0;
            }
            PointD piv = pi.vertex;
            PointD pjv = pj.vertex;
            double length = this.p0v.crossProductLength(piv, pjv);
            if (length > 0.0) {
                return -1;
            }
            if (length < 0.0) {
                return 1;
            }
            double x = Math.abs(piv.x - this.p0v.x) - Math.abs(pjv.x - this.p0v.x);
            double y = Math.abs(piv.y - this.p0v.y) - Math.abs(pjv.y - this.p0v.y);
            if (x < 0.0 || y < 0.0) {
                pi.delete = true;
                return -1;
            }
            if (x > 0.0 || y > 0.0) {
                pj.delete = true;
                return 1;
            }
            if (pi.index > pj.index) {
                pj.delete = true;
            } else {
                pi.delete = true;
            }
            return 0;
        }
    }

    private static class ConvexHullVertex {
        boolean delete;
        final int index;
        ConvexHullVertex next;
        final PointD vertex;

        ConvexHullVertex(PointD vertex, int index) {
            if (vertex == null) {
                throw new NullPointerException("vertex");
            }
            this.vertex = vertex;
            this.index = index;
        }
    }
}

