/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.LineI;
import org.kynosarges.tektosyne.geometry.LineIntersection;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;

public final class LineD {
    public final PointD start;
    public final PointD end;
    public static final LineD EMPTY = new LineD();

    public LineD() {
        this.start = PointD.EMPTY;
        this.end = PointD.EMPTY;
    }

    public LineD(double startX, double startY, double endX, double endY) {
        this.start = new PointD(startX, startY);
        this.end = new PointD(endX, endY);
    }

    public LineD(PointD start, PointD end) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.start = start;
        this.end = end;
    }

    public double angle() {
        double x = this.end.x - this.start.x;
        double y = this.end.y - this.start.y;
        return Math.atan2(y, x);
    }

    public double distanceSquared(PointD q) {
        if (q.equals(this.start) || q.equals(this.end)) {
            return 0.0;
        }
        double x = this.start.x;
        double y = this.start.y;
        double ax = this.end.x - x;
        double ay = this.end.y - y;
        if (ax != 0.0 || ay != 0.0) {
            double u = ((q.x - x) * ax + (q.y - y) * ay) / (ax * ax + ay * ay);
            if (u > 1.0) {
                x = this.end.x;
                y = this.end.y;
            } else if (u > 0.0) {
                x += u * ax;
                y += u * ay;
            }
        }
        x = q.x - x;
        y = q.y - y;
        return x * x + y * y;
    }

    public static boolean equals(LineD a, LineD b, double epsilon) {
        return PointD.equals(a.start, b.start, epsilon) && PointD.equals(a.end, b.end, epsilon);
    }

    public double findX(double y) {
        double dy = this.end.y - this.start.y;
        if (dy == 0.0) {
            return Double.MAX_VALUE;
        }
        if (y == this.start.y) {
            return this.start.x;
        }
        if (y == this.end.y) {
            return this.end.x;
        }
        double dx = this.end.x - this.start.x;
        return this.start.x + (y - this.start.y) * dx / dy;
    }

    public double findY(double x) {
        double dx = this.end.x - this.start.x;
        if (dx == 0.0) {
            return Double.MAX_VALUE;
        }
        if (x == this.start.x) {
            return this.start.y;
        }
        if (x == this.end.x) {
            return this.end.y;
        }
        double dy = this.end.y - this.start.y;
        return this.start.y + (x - this.start.x) * dy / dx;
    }

    public static LineD[] fromDoubles(double ... lines) {
        if (lines.length % 4 != 0) {
            throw new IllegalArgumentException("lines.length % 4 != 0");
        }
        LineD[] output = new LineD[lines.length / 4];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new LineD(lines[4 * i], lines[4 * i + 1], lines[4 * i + 2], lines[4 * i + 3]);
        }
        return output;
    }

    public static LineD[] fromIndexPoints(PointD[] points, PointI[] indices) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        LineD[] lines = new LineD[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            lines[i] = new LineD(points[indices[i].x], points[indices[i].y]);
        }
        return lines;
    }

    public LineIntersection intersect(LineD line) {
        return LineIntersection.find(this.start, this.end, line.start, line.end);
    }

    public LineIntersection intersect(LineD line, double epsilon) {
        return LineIntersection.find(this.start, this.end, line.start, line.end, epsilon);
    }

    public PointD intersect(PointD q) {
        if (q.equals(this.start)) {
            return this.start;
        }
        if (q.equals(this.end)) {
            return this.end;
        }
        double x = this.start.x;
        double y = this.start.y;
        double dx = this.end.x - x;
        double dy = this.end.y - y;
        if (dx == 0.0 && dy == 0.0) {
            return this.start;
        }
        double u = ((q.x - x) * dx + (q.y - y) * dy) / (dx * dx + dy * dy);
        return new PointD(x + u * dx, y + u * dy);
    }

    public double inverseSlope() {
        double dy = this.end.y - this.start.y;
        if (dy == 0.0) {
            return Double.MAX_VALUE;
        }
        double dx = this.end.x - this.start.x;
        return dx / dy;
    }

    public double length() {
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public double lengthSquared() {
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        return dx * dx + dy * dy;
    }

    public LineLocation locate(PointD q) {
        double qx0 = q.x - this.start.x;
        double qy0 = q.y - this.start.y;
        if (qx0 == 0.0 && qy0 == 0.0) {
            return LineLocation.START;
        }
        double qx1 = q.x - this.end.x;
        double qy1 = q.y - this.end.y;
        if (qx1 == 0.0 && qy1 == 0.0) {
            return LineLocation.END;
        }
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        double area = dx * qy0 - qx0 * dy;
        if (area > 0.0) {
            return LineLocation.LEFT;
        }
        if (area < 0.0) {
            return LineLocation.RIGHT;
        }
        if (qx0 * qx1 <= 0.0 && qy0 * qy1 <= 0.0) {
            return LineLocation.BETWEEN;
        }
        if (dx * qx0 < 0.0 || dy * qy0 < 0.0) {
            return LineLocation.BEFORE;
        }
        return LineLocation.AFTER;
    }

    public LineLocation locate(PointD q, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        double qx0 = q.x - this.start.x;
        double qy0 = q.y - this.start.y;
        if (Math.abs(qx0) <= epsilon && Math.abs(qy0) <= epsilon) {
            return LineLocation.START;
        }
        double qx1 = q.x - this.end.x;
        double qy1 = q.y - this.end.y;
        if (Math.abs(qx1) <= epsilon && Math.abs(qy1) <= epsilon) {
            return LineLocation.END;
        }
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        double area = dx * qy0 - qx0 * dy;
        double epsilon2 = epsilon * (Math.abs(dx) + Math.abs(dy));
        if (area > epsilon2) {
            return LineLocation.LEFT;
        }
        if (area < -epsilon2) {
            return LineLocation.RIGHT;
        }
        if ((qx0 * qx1 <= 0.0 || Math.abs(qx0) <= epsilon || Math.abs(qx1) <= epsilon) && (qy0 * qy1 <= 0.0 || Math.abs(qy0) <= epsilon || Math.abs(qy1) <= epsilon)) {
            return LineLocation.BETWEEN;
        }
        if (dx * qx0 < 0.0 || dy * qy0 < 0.0) {
            return LineLocation.BEFORE;
        }
        return LineLocation.AFTER;
    }

    public LineLocation locateCollinear(PointD q) {
        return LineIntersection.locateCollinear(this.start, this.end, q);
    }

    public LineLocation locateCollinear(PointD q, double epsilon) {
        return LineIntersection.locateCollinear(this.start, this.end, q, epsilon);
    }

    public LineD reverse() {
        return new LineD(this.end, this.start);
    }

    public LineI round() {
        return new LineI(this.start.round(), this.end.round());
    }

    public double slope() {
        double dx = this.end.x - this.start.x;
        if (dx == 0.0) {
            return Double.MAX_VALUE;
        }
        double dy = this.end.y - this.start.y;
        return dy / dx;
    }

    public static double[] toDoubles(LineD ... lines) {
        double[] output = new double[4 * lines.length];
        for (int i = 0; i < lines.length; ++i) {
            output[4 * i] = lines[i].start.x;
            output[4 * i + 1] = lines[i].start.y;
            output[4 * i + 2] = lines[i].end.x;
            output[4 * i + 3] = lines[i].end.y;
        }
        return output;
    }

    public LineI toLineI() {
        return new LineI(this.start.toPointI(), this.end.toPointI());
    }

    public PointD vector() {
        return new PointD(this.end.x - this.start.x, this.end.y - this.start.y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LineD)) {
            return false;
        }
        LineD line = (LineD)obj;
        return this.start.equals(line.start) && this.end.equals(line.end);
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    public String toString() {
        return String.format("LineD[start.x=%g, start.y=%g, end.x=%g, end.y=%g]", this.start.x, this.start.y, this.end.x, this.end.y);
    }
}

