/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineIntersection;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;

public final class LineI {
    public final PointI start;
    public final PointI end;
    public static final LineI EMPTY = new LineI();

    public LineI() {
        this.start = PointI.EMPTY;
        this.end = PointI.EMPTY;
    }

    public LineI(int startX, int startY, int endX, int endY) {
        this.start = new PointI(startX, startY);
        this.end = new PointI(endX, endY);
    }

    public LineI(PointI start, PointI end) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.start = start;
        this.end = end;
    }

    public double angle() {
        double x = (double)this.end.x - (double)this.start.x;
        double y = (double)this.end.y - (double)this.start.y;
        return Math.atan2(y, x);
    }

    public double distanceSquared(PointI q) {
        if (q.equals(this.start) || q.equals(this.end)) {
            return 0.0;
        }
        double x = this.start.x;
        double y = this.start.y;
        double ax = (double)this.end.x - x;
        double ay = (double)this.end.y - y;
        if (ax != 0.0 || ay != 0.0) {
            double u = (((double)q.x - x) * ax + ((double)q.y - y) * ay) / (ax * ax + ay * ay);
            if (u > 1.0) {
                x = this.end.x;
                y = this.end.y;
            } else if (u > 0.0) {
                x += u * ax;
                y += u * ay;
            }
        }
        x = (double)q.x - x;
        y = (double)q.y - y;
        return x * x + y * y;
    }

    public double findX(double y) {
        double dy = (double)this.end.y - (double)this.start.y;
        if (dy == 0.0) {
            return Double.MAX_VALUE;
        }
        if (y == (double)this.start.y) {
            return this.start.x;
        }
        if (y == (double)this.end.y) {
            return this.end.x;
        }
        double dx = (double)this.end.x - (double)this.start.x;
        return (double)this.start.x + (y - (double)this.start.y) * dx / dy;
    }

    public double findY(double x) {
        double dx = (double)this.end.x - (double)this.start.x;
        if (dx == 0.0) {
            return Double.MAX_VALUE;
        }
        if (x == (double)this.start.x) {
            return this.start.y;
        }
        if (x == (double)this.end.x) {
            return this.end.y;
        }
        double dy = (double)this.end.y - (double)this.start.y;
        return (double)this.start.y + (x - (double)this.start.x) * dy / dx;
    }

    public static LineI[] fromInts(int ... lines) {
        if (lines.length % 4 != 0) {
            throw new IllegalArgumentException("lines.length % 4 != 0");
        }
        LineI[] output = new LineI[lines.length / 4];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new LineI(lines[4 * i], lines[4 * i + 1], lines[4 * i + 2], lines[4 * i + 3]);
        }
        return output;
    }

    public LineIntersection intersect(LineI line) {
        return LineIntersection.find(this.start.toPointD(), this.end.toPointD(), line.start.toPointD(), line.end.toPointD());
    }

    public PointD intersect(PointI q) {
        if (q.equals(this.start)) {
            return this.start.toPointD();
        }
        if (q.equals(this.end)) {
            return this.end.toPointD();
        }
        double x = this.start.x;
        double y = this.start.y;
        double dx = (double)this.end.x - x;
        double dy = (double)this.end.y - y;
        if (dx == 0.0 && dy == 0.0) {
            return this.start.toPointD();
        }
        double u = (((double)q.x - x) * dx + ((double)q.y - y) * dy) / (dx * dx + dy * dy);
        return new PointD(x + u * dx, y + u * dy);
    }

    public double inverseSlope() {
        double dy = (double)this.end.y - (double)this.start.y;
        if (dy == 0.0) {
            return Double.MAX_VALUE;
        }
        double dx = (double)this.end.x - (double)this.start.x;
        return dx / dy;
    }

    public double length() {
        double dx = (double)this.end.x - (double)this.start.x;
        double dy = (double)this.end.y - (double)this.start.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public long lengthSquared() {
        long dx = (long)this.end.x - (long)this.start.x;
        long dy = (long)this.end.y - (long)this.start.y;
        return dx * dx + dy * dy;
    }

    public LineLocation locate(PointI q) {
        double qx0 = (double)q.x - (double)this.start.x;
        double qy0 = (double)q.y - (double)this.start.y;
        if (qx0 == 0.0 && qy0 == 0.0) {
            return LineLocation.START;
        }
        double qx1 = (double)q.x - (double)this.end.x;
        double qy1 = (double)q.y - (double)this.end.y;
        if (qx1 == 0.0 && qy1 == 0.0) {
            return LineLocation.END;
        }
        double dx = (double)this.end.x - (double)this.start.x;
        double dy = (double)this.end.y - (double)this.start.y;
        double area = dx * qy0 - qx0 * dy;
        if (area > 0.0) {
            return LineLocation.LEFT;
        }
        if (area < 0.0) {
            return LineLocation.RIGHT;
        }
        if (qx0 * qx1 <= 0.0 && qy0 * qy1 <= 0.0) {
            return LineLocation.BETWEEN;
        }
        if (dx * qx0 < 0.0 || dy * qy0 < 0.0) {
            return LineLocation.BEFORE;
        }
        return LineLocation.AFTER;
    }

    public LineLocation locateCollinear(PointI q) {
        return LineIntersection.locateCollinear(this.start.toPointD(), this.end.toPointD(), q.toPointD());
    }

    public LineI reverse() {
        return new LineI(this.end, this.start);
    }

    public double slope() {
        double dx = (double)this.end.x - (double)this.start.x;
        if (dx == 0.0) {
            return Double.MAX_VALUE;
        }
        double dy = (double)this.end.y - (double)this.start.y;
        return dy / dx;
    }

    public static int[] toInts(LineI ... lines) {
        int[] output = new int[4 * lines.length];
        for (int i = 0; i < lines.length; ++i) {
            output[4 * i] = lines[i].start.x;
            output[4 * i + 1] = lines[i].start.y;
            output[4 * i + 2] = lines[i].end.x;
            output[4 * i + 3] = lines[i].end.y;
        }
        return output;
    }

    public LineD toLineD() {
        return new LineD(this.start.toPointD(), this.end.toPointD());
    }

    public PointI vector() {
        return new PointI(Math.subtractExact(this.end.x, this.start.x), Math.subtractExact(this.end.y, this.start.y));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LineI)) {
            return false;
        }
        LineI line = (LineI)obj;
        return this.start.equals(line.start) && this.end.equals(line.end);
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    public String toString() {
        return String.format("LineI[start.x=%d, start.y=%d, end.x=%d, end.y=%d]", this.start.x, this.start.y, this.end.x, this.end.y);
    }
}

