/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.LineRelation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparatorY;

public final class LineIntersection {
    public final LineLocation first;
    public final LineLocation second;
    public final LineRelation relation;
    public final PointD shared;

    private LineIntersection(LineRelation relation) {
        this(null, null, null, relation);
    }

    private LineIntersection(PointD shared, LineLocation first, LineLocation second, LineRelation relation) {
        if (relation == null) {
            throw new NullPointerException("relation");
        }
        this.shared = shared;
        this.first = first;
        this.second = second;
        this.relation = relation;
    }

    public boolean exists() {
        return LineLocation.contains(this.first) && LineLocation.contains(this.second);
    }

    public boolean existsBetween() {
        return LineLocation.contains(this.first) && this.second == LineLocation.BETWEEN || this.first == LineLocation.BETWEEN && LineLocation.contains(this.second);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LineIntersection find(PointD startA, PointD endA, PointD startB, PointD endB) {
        LineLocation second;
        LineLocation first;
        double epsilon = 1.0E-10;
        double dxA = endA.x - startA.x;
        double dyA = endA.y - startA.y;
        double dxB = endB.x - startB.x;
        double dyB = endB.y - startB.y;
        double d1 = (startA.x - startB.x) * dyB - (startA.y - startB.y) * dxB;
        double d2 = (endA.x - startB.x) * dyB - (endA.y - startB.y) * dxB;
        double d3 = (startB.x - startA.x) * dyA - (startB.y - startA.y) * dxA;
        double d4 = (endB.x - startA.x) * dyA - (endB.y - startA.y) * dxA;
        assert (d1 == startB.crossProductLength(startA, endB));
        assert (d2 == startB.crossProductLength(endA, endB));
        assert (d3 == startA.crossProductLength(startB, endA));
        assert (d4 == startA.crossProductLength(endB, endA));
        if (Math.abs(d1) <= 1.0E-10 && Math.abs(d2) <= 1.0E-10 && Math.abs(d3) <= 1.0E-10 && Math.abs(d4) <= 1.0E-10) {
            if (PointDComparatorY.compareExact(startB, endB) < 0) {
                LineLocation first2 = LineIntersection.locateCollinear(startA, endA, startB);
                if (LineLocation.contains(first2)) {
                    return new LineIntersection(startB, first2, LineLocation.START, LineRelation.COLLINEAR);
                }
                first2 = LineIntersection.locateCollinear(startA, endA, endB);
                if (!LineLocation.contains(first2)) return new LineIntersection(LineRelation.COLLINEAR);
                return new LineIntersection(endB, first2, LineLocation.END, LineRelation.COLLINEAR);
            }
            LineLocation first3 = LineIntersection.locateCollinear(startA, endA, endB);
            if (LineLocation.contains(first3)) {
                return new LineIntersection(endB, first3, LineLocation.END, LineRelation.COLLINEAR);
            }
            first3 = LineIntersection.locateCollinear(startA, endA, startB);
            if (!LineLocation.contains(first3)) return new LineIntersection(LineRelation.COLLINEAR);
            return new LineIntersection(startB, first3, LineLocation.START, LineRelation.COLLINEAR);
        }
        if (Math.abs(d1) <= 1.0E-10) {
            LineLocation second2 = LineIntersection.locateCollinear(startB, endB, startA);
            return new LineIntersection(startA, LineLocation.START, second2, LineRelation.DIVERGENT);
        }
        if (Math.abs(d2) <= 1.0E-10) {
            LineLocation second3 = LineIntersection.locateCollinear(startB, endB, endA);
            return new LineIntersection(endA, LineLocation.END, second3, LineRelation.DIVERGENT);
        }
        if (Math.abs(d3) <= 1.0E-10) {
            LineLocation first4 = LineIntersection.locateCollinear(startA, endA, startB);
            return new LineIntersection(startB, first4, LineLocation.START, LineRelation.DIVERGENT);
        }
        if (Math.abs(d4) <= 1.0E-10) {
            LineLocation first5 = LineIntersection.locateCollinear(startA, endA, endB);
            return new LineIntersection(endB, first5, LineLocation.END, LineRelation.DIVERGENT);
        }
        double denom = dxB * dyA - dxA * dyB;
        if (Math.abs(denom) <= 1.0E-10) {
            return new LineIntersection(LineRelation.PARALLEL);
        }
        double snum = startA.x * dyB - startA.y * dxB - startB.x * endB.y + startB.y * endB.x;
        double s = snum / denom;
        if (d1 < 0.0 && d2 < 0.0 || d1 > 0.0 && d2 > 0.0) {
            if (s < 0.0) {
                first = LineLocation.BEFORE;
            } else {
                if (!(s > 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0E-10);
                first = LineLocation.AFTER;
            }
        } else {
            if (!(s > 0.0) || !(s < 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0E-10);
            first = LineLocation.BETWEEN;
        }
        double tnum = startB.y * dxA - startB.x * dyA + startA.x * endA.y - startA.y * endA.x;
        double t = tnum / denom;
        if (d3 < 0.0 && d4 < 0.0 || d3 > 0.0 && d4 > 0.0) {
            if (t < 0.0) {
                second = LineLocation.BEFORE;
            } else {
                if (!(t > 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0E-10);
                second = LineLocation.AFTER;
            }
        } else {
            if (!(t > 0.0) || !(t < 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0E-10);
            second = LineLocation.BETWEEN;
        }
        PointD shared = new PointD(startA.x + s * dxA, startA.y + s * dyA);
        return new LineIntersection(shared, first, second, LineRelation.DIVERGENT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LineIntersection find(PointD startA, PointD endA, PointD startB, PointD endB, double epsilon) {
        LineLocation second;
        LineLocation first;
        if (epsilon < 1.0E-10) {
            epsilon = 1.0E-10;
        }
        double dxA = endA.x - startA.x;
        double dyA = endA.y - startA.y;
        double dxB = endB.x - startB.x;
        double dyB = endB.y - startB.y;
        double d1 = (startA.x - startB.x) * dyB - (startA.y - startB.y) * dxB;
        double d2 = (endA.x - startB.x) * dyB - (endA.y - startB.y) * dxB;
        double d3 = (startB.x - startA.x) * dyA - (startB.y - startA.y) * dxA;
        double d4 = (endB.x - startA.x) * dyA - (endB.y - startA.y) * dxA;
        assert (d1 == startB.crossProductLength(startA, endB));
        assert (d2 == startB.crossProductLength(endA, endB));
        assert (d3 == startA.crossProductLength(startB, endA));
        assert (d4 == startA.crossProductLength(endB, endA));
        if (Math.abs(d1) <= epsilon && Math.abs(d2) <= epsilon && Math.abs(d3) <= epsilon && Math.abs(d4) <= epsilon) {
            if (PointDComparatorY.compareExact(startB, endB) < 0) {
                LineLocation first2 = LineIntersection.locateCollinear(startA, endA, startB, epsilon);
                if (LineLocation.contains(first2)) {
                    return new LineIntersection(startB, first2, LineLocation.START, LineRelation.COLLINEAR);
                }
                first2 = LineIntersection.locateCollinear(startA, endA, endB, epsilon);
                if (!LineLocation.contains(first2)) return new LineIntersection(LineRelation.COLLINEAR);
                return new LineIntersection(endB, first2, LineLocation.END, LineRelation.COLLINEAR);
            }
            LineLocation first3 = LineIntersection.locateCollinear(startA, endA, endB, epsilon);
            if (LineLocation.contains(first3)) {
                return new LineIntersection(endB, first3, LineLocation.END, LineRelation.COLLINEAR);
            }
            first3 = LineIntersection.locateCollinear(startA, endA, startB, epsilon);
            if (!LineLocation.contains(first3)) return new LineIntersection(LineRelation.COLLINEAR);
            return new LineIntersection(startB, first3, LineLocation.START, LineRelation.COLLINEAR);
        }
        if (Math.abs(d1) <= epsilon) {
            LineLocation second2 = LineIntersection.locateCollinear(startB, endB, startA, epsilon);
            return new LineIntersection(startA, LineLocation.START, second2, LineRelation.DIVERGENT);
        }
        if (Math.abs(d2) <= epsilon) {
            LineLocation second3 = LineIntersection.locateCollinear(startB, endB, endA, epsilon);
            return new LineIntersection(endA, LineLocation.END, second3, LineRelation.DIVERGENT);
        }
        if (Math.abs(d3) <= epsilon) {
            LineLocation first4 = LineIntersection.locateCollinear(startA, endA, startB, epsilon);
            return new LineIntersection(startB, first4, LineLocation.START, LineRelation.DIVERGENT);
        }
        if (Math.abs(d4) <= epsilon) {
            LineLocation first5 = LineIntersection.locateCollinear(startA, endA, endB, epsilon);
            return new LineIntersection(endB, first5, LineLocation.END, LineRelation.DIVERGENT);
        }
        double denom = dxB * dyA - dxA * dyB;
        if (Math.abs(denom) <= epsilon) {
            return new LineIntersection(LineRelation.PARALLEL);
        }
        double snum = startA.x * dyB - startA.y * dxB - startB.x * endB.y + startB.y * endB.x;
        double s = snum / denom;
        if (d1 < 0.0 && d2 < 0.0 || d1 > 0.0 && d2 > 0.0) {
            if (s < 0.0) {
                first = LineLocation.BEFORE;
            } else {
                if (!(s > 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0 * epsilon);
                first = LineLocation.AFTER;
            }
        } else {
            if (!(s > 0.0) || !(s < 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0 * epsilon);
            first = LineLocation.BETWEEN;
        }
        double tnum = startB.y * dxA - startB.x * dyA + startA.x * endA.y - startA.y * endA.x;
        double t = tnum / denom;
        if (d3 < 0.0 && d4 < 0.0 || d3 > 0.0 && d4 > 0.0) {
            if (t < 0.0) {
                second = LineLocation.BEFORE;
            } else {
                if (!(t > 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0 * epsilon);
                second = LineLocation.AFTER;
            }
        } else {
            if (!(t > 0.0) || !(t < 1.0)) return LineIntersection.find(startA, endA, startB, endB, 2.0 * epsilon);
            second = LineLocation.BETWEEN;
        }
        PointD shared = new PointD(startA.x + s * dxA, startA.y + s * dyA);
        if (PointD.equals(startA, shared, epsilon)) {
            first = LineLocation.START;
        } else if (PointD.equals(endA, shared, epsilon)) {
            first = LineLocation.END;
        }
        if (PointD.equals(startB, shared, epsilon)) {
            second = LineLocation.START;
            return new LineIntersection(shared, first, second, LineRelation.DIVERGENT);
        } else {
            if (!PointD.equals(endB, shared, epsilon)) return new LineIntersection(shared, first, second, LineRelation.DIVERGENT);
            second = LineLocation.END;
        }
        return new LineIntersection(shared, first, second, LineRelation.DIVERGENT);
    }

    public static LineLocation locateCollinear(PointD start, PointD end, PointD q) {
        double qx0 = q.x - start.x;
        double qy0 = q.y - start.y;
        if (qx0 == 0.0 && qy0 == 0.0) {
            return LineLocation.START;
        }
        double qx1 = q.x - end.x;
        double qy1 = q.y - end.y;
        if (qx1 == 0.0 && qy1 == 0.0) {
            return LineLocation.END;
        }
        if (qx0 * qx1 <= 0.0 && qy0 * qy1 <= 0.0) {
            return LineLocation.BETWEEN;
        }
        double dx = end.x - start.x;
        double dy = end.y - start.y;
        if (dx * qx0 < 0.0 || dy * qy0 < 0.0) {
            return LineLocation.BEFORE;
        }
        return LineLocation.AFTER;
    }

    public static LineLocation locateCollinear(PointD start, PointD end, PointD q, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        double qx0 = q.x - start.x;
        double qy0 = q.y - start.y;
        if (Math.abs(qx0) <= epsilon && Math.abs(qy0) <= epsilon) {
            return LineLocation.START;
        }
        double qx1 = q.x - end.x;
        double qy1 = q.y - end.y;
        if (Math.abs(qx1) <= epsilon && Math.abs(qy1) <= epsilon) {
            return LineLocation.END;
        }
        if ((qx0 * qx1 <= 0.0 || Math.abs(qx0) <= epsilon || Math.abs(qx1) <= epsilon) && (qy0 * qy1 <= 0.0 || Math.abs(qy0) <= epsilon || Math.abs(qy1) <= epsilon)) {
            return LineLocation.BETWEEN;
        }
        double dx = end.x - start.x;
        double dy = end.y - start.y;
        if (dx * qx0 < 0.0 || dy * qy0 < 0.0) {
            return LineLocation.BEFORE;
        }
        return LineLocation.AFTER;
    }

    public PointD startOrEnd(LineD a, LineD b) {
        if (this.first == LineLocation.START) {
            return a.start;
        }
        if (this.first == LineLocation.END) {
            return a.end;
        }
        if (this.second == LineLocation.START) {
            return b.start;
        }
        if (this.second == LineLocation.END) {
            return b.end;
        }
        return this.shared;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LineIntersection)) {
            return false;
        }
        LineIntersection other = (LineIntersection)obj;
        return this.first == other.first && this.second == other.second && this.relation == other.relation && this.shared.equals(other.shared);
    }

    public int hashCode() {
        return this.shared == null ? 0 : this.shared.hashCode();
    }

    public String toString() {
        return String.format("LineIntersection[first=%s, second=%s, relation=%s, shared=%s]", this.first == null ? "null" : this.first.toString(), this.second == null ? "null" : this.second.toString(), this.relation == null ? "null" : this.relation.toString(), this.shared == null ? "null" : this.shared.toString());
    }
}

