/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineIntersection;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.MultiLinePoint;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparatorY;

public final class MultiLineIntersection {
    private MultiLineIntersection() {
    }

    public static MultiLinePoint[] find(LineD[] lines) {
        Status status = new Status();
        List<EventPoint> crossings = status.findCore(lines);
        return EventPoint.output(crossings);
    }

    public static MultiLinePoint[] findSimple(LineD[] lines) {
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        TreeMap<PointD, EventPoint> crossings = new TreeMap<PointD, EventPoint>(PointDComparatorY::compareExact);
        for (int i = 0; i < lines.length - 1; ++i) {
            for (int j = i + 1; j < lines.length; ++j) {
                LineIntersection crossing = lines[i].intersect(lines[j]);
                if (!crossing.exists()) continue;
                PointD p = crossing.shared;
                EventPoint e = EventPoint.tryAdd(crossings, p);
                e.tryAddLines(i, crossing.first, j, crossing.second);
            }
        }
        return EventPoint.output(crossings.values());
    }

    public static MultiLinePoint[] findSimple(LineD[] lines, double epsilon) {
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        TreeMap<PointD, EventPoint> crossings = new TreeMap<PointD, EventPoint>((a, b) -> PointDComparatorY.compareEpsilon(a, b, epsilon));
        for (int i = 0; i < lines.length - 1; ++i) {
            for (int j = i + 1; j < lines.length; ++j) {
                LineIntersection crossing = lines[i].intersect(lines[j], epsilon);
                if (!crossing.exists()) continue;
                PointD p = crossing.shared;
                EventPoint e = EventPoint.tryAdd(crossings, p);
                e.tryAddLines(i, crossing.first, j, crossing.second);
            }
        }
        return EventPoint.output(crossings.values());
    }

    public static LineD[] split(LineD[] lines, MultiLinePoint[] crossings) {
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        if (crossings == null) {
            throw new NullPointerException("crossings");
        }
        int count = lines.length;
        ArrayList[] segmentPoints = new ArrayList[count];
        for (MultiLinePoint crossing : crossings) {
            block6: for (MultiLinePoint.Line line : crossing.lines) {
                int index = line.index;
                ArrayList<PointD> points = segmentPoints[index];
                if (points == null) {
                    points = new ArrayList<PointD>(4);
                    points.add(lines[index].start);
                    points.add(lines[index].end);
                    segmentPoints[index] = points;
                }
                switch (line.location) {
                    case START: {
                        points.set(0, crossing.shared);
                        continue block6;
                    }
                    case END: {
                        points.set(1, crossing.shared);
                        continue block6;
                    }
                    case BETWEEN: {
                        points.add(crossing.shared);
                        ++count;
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("crossings contains invalid LineLocation");
                    }
                }
            }
        }
        SplitComparator comparer = new SplitComparator();
        LineD[] segments = new LineD[count];
        int index = 0;
        for (int i = 0; i < lines.length; ++i) {
            ArrayList points = segmentPoints[i];
            if (points == null) {
                segments[index++] = lines[i];
                continue;
            }
            assert (points.size() > 2);
            comparer.setStart((PointD)points.get(0));
            points.sort(comparer);
            for (int j = 0; j < points.size() - 1; ++j) {
                segments[index++] = new LineD((PointD)points.get(j), (PointD)points.get(j + 1));
            }
        }
        assert (index == count);
        return segments;
    }

    private static final class Status {
        private PointD cursor;
        private final List<EventPoint> crossings = new ArrayList<EventPoint>();
        private LineD[] lines;
        private double[] positions;
        private final TreeMap<PointD, EventPoint> schedule = new TreeMap(PointDComparatorY::compareExact);
        private final TreeSet<Integer> sweepLine = new TreeSet(this::compareLines);
        private double[] slopes;

        Status() {
        }

        List<EventPoint> findCore(LineD[] lines) {
            this.buildSchedule(lines);
            while (!this.schedule.isEmpty()) {
                this.handle(this.schedule.pollFirstEntry().getValue());
            }
            if (!this.sweepLine.isEmpty()) {
                throw new IllegalStateException("search structure corrupt");
            }
            return this.crossings;
        }

        private void addCrossing(int a, int b, EventPoint e) {
            if (e == null) {
                throw new NullPointerException("e");
            }
            LineIntersection c = this.lines[a].intersect(this.lines[b]);
            if (c.first == LineLocation.BETWEEN && LineLocation.contains(c.second) || LineLocation.contains(c.first) && c.second == LineLocation.BETWEEN) {
                PointD p = c.shared;
                int result = PointDComparatorY.compareExact(this.cursor, p);
                if (result > 0) {
                    return;
                }
                if (result < 0) {
                    e = EventPoint.tryAdd(this.schedule, p);
                }
                e.tryAddLines(a, c.first, b, c.second);
            }
        }

        private void buildSchedule(LineD[] lines) {
            this.lines = lines;
            this.positions = new double[lines.length];
            this.slopes = new double[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                LineD line = lines[i];
                int direction = PointDComparatorY.compareExact(line.start, line.end);
                if (direction == 0) {
                    throw new IllegalArgumentException("lines contains empty LineD");
                }
                if (direction > 0) {
                    line = line.reverse();
                }
                this.slopes[i] = line.inverseSlope();
                EventPoint e = EventPoint.tryAdd(this.schedule, line.start);
                e.addLine(i, LineLocation.START);
                e = EventPoint.tryAdd(this.schedule, line.end);
                e.addLine(i, LineLocation.END);
            }
        }

        private int compareLines(int a, int b) {
            if (a == b) {
                return 0;
            }
            double ax = this.positions[a];
            double bx = this.positions[b];
            if (ax < bx) {
                return -1;
            }
            if (ax > bx) {
                return 1;
            }
            double aSlope = this.slopes[a];
            double bSlope = this.slopes[b];
            if (aSlope < bSlope) {
                return -1;
            }
            if (aSlope > bSlope) {
                return 1;
            }
            return a - b;
        }

        private void handle(EventPoint e) {
            this.cursor = e.shared;
            boolean adding = false;
            assert (e.indices.size() == e.locations.size());
            Integer prevLine = null;
            Integer nextLine = null;
            block5: for (int i = 0; i < e.locations.size(); ++i) {
                int index = e.indices.get(i);
                switch (e.locations.get(i)) {
                    case START: {
                        adding = true;
                        continue block5;
                    }
                    case END: {
                        if (!this.sweepLine.remove(index)) {
                            throw new IllegalStateException("search structure corrupt");
                        }
                        prevLine = this.sweepLine.lower(index);
                        nextLine = this.sweepLine.higher(index);
                        continue block5;
                    }
                    case BETWEEN: {
                        if (!this.sweepLine.remove(index)) {
                            throw new IllegalStateException("search structure corrupt");
                        }
                        adding = true;
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("e contains invalid LineLocation");
                    }
                }
            }
            if (!adding) {
                List<Integer> indices;
                if (prevLine != null && nextLine != null) {
                    this.addCrossing(prevLine, nextLine, e);
                }
                if ((indices = e.indices).size() < 2) {
                    return;
                }
                double slope = this.slopes[indices.get(0)];
                for (int i = 1; i < indices.size(); ++i) {
                    if (slope == this.slopes[indices.get(i)]) continue;
                    e.normalize(this.lines);
                    this.crossings.add(e);
                    break;
                }
                return;
            }
            for (int index : this.sweepLine) {
                double slope = this.slopes[index];
                if (slope == Double.MAX_VALUE) continue;
                PointD start = this.lines[index].start;
                this.positions[index] = slope * (this.cursor.y - start.y) + start.x;
            }
            nextLine = null;
            prevLine = null;
            boolean storeNeighbors = true;
            for (int i = 0; i < e.locations.size(); ++i) {
                if (e.locations.get(i) == LineLocation.END) continue;
                int index = e.indices.get(i);
                this.positions[index] = this.cursor.x;
                this.sweepLine.add(index);
                if (!storeNeighbors) continue;
                prevLine = this.sweepLine.lower(index);
                nextLine = this.sweepLine.higher(index);
                storeNeighbors = false;
            }
            if (prevLine != null) {
                this.addCrossing(prevLine, this.sweepLine.higher(prevLine), e);
            }
            if (nextLine != null) {
                this.addCrossing(this.sweepLine.lower(nextLine), nextLine, e);
            }
            if (e.indices.size() > 1) {
                e.normalize(this.lines);
                this.crossings.add(e);
            }
        }
    }

    private static final class SplitComparator
    implements Comparator<PointD> {
        private PointD start = PointD.EMPTY;

        private SplitComparator() {
        }

        void setStart(PointD start) {
            if (start == null) {
                throw new NullPointerException("start");
            }
            this.start = start;
        }

        @Override
        public int compare(PointD a, PointD b) {
            double ax = a.x - this.start.x;
            double ay = a.y - this.start.y;
            double bx = b.x - this.start.x;
            double by = b.y - this.start.y;
            double d = ax * ax + ay * ay - (bx * bx + by * by);
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    private static final class EventPoint {
        final List<Integer> indices = new ArrayList<Integer>(2);
        final List<LineLocation> locations = new ArrayList<LineLocation>(2);
        final PointD shared;

        EventPoint(PointD shared) {
            if (shared == null) {
                throw new NullPointerException("shared");
            }
            this.shared = shared;
        }

        void addLine(int index, LineLocation location) {
            this.indices.add(index);
            this.locations.add(location);
        }

        void normalize(LineD[] lines) {
            for (int i = 0; i < this.locations.size(); ++i) {
                LineLocation location = this.locations.get(i);
                if (location != LineLocation.START && location != LineLocation.END) continue;
                LineD line = lines[this.indices.get(i)];
                if (PointDComparatorY.compareExact(line.start, line.end) <= 0) continue;
                location = location == LineLocation.START ? LineLocation.END : LineLocation.START;
                this.locations.set(i, location);
            }
        }

        static MultiLinePoint[] output(Collection<EventPoint> crossings) {
            MultiLinePoint[] output = new MultiLinePoint[crossings.size()];
            int i = 0;
            for (EventPoint e : crossings) {
                int count = e.indices.size();
                assert (count == e.locations.size());
                MultiLinePoint.Line[] lines = new MultiLinePoint.Line[count];
                for (int j = 0; j < count; ++j) {
                    lines[j] = new MultiLinePoint.Line(e.indices.get(j), e.locations.get(j));
                }
                output[i++] = new MultiLinePoint(e.shared, lines);
            }
            return output;
        }

        static EventPoint tryAdd(Map<PointD, EventPoint> map, PointD p) {
            EventPoint e = new EventPoint(p);
            EventPoint oldE = map.putIfAbsent(p, e);
            return oldE != null ? oldE : e;
        }

        void tryAddLines(int index1, LineLocation location1, int index2, LineLocation location2) {
            if (!this.indices.contains(index1)) {
                this.indices.add(index1);
                this.locations.add(location1);
            }
            if (!this.indices.contains(index2)) {
                this.indices.add(index2);
                this.locations.add(location2);
            }
        }
    }
}

