/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.Arrays;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;

public final class MultiLinePoint {
    public final Line[] lines;
    public final PointD shared;

    MultiLinePoint(PointD shared, Line[] lines) {
        if (shared == null) {
            throw new NullPointerException("shared");
        }
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        if (lines.length < 2) {
            throw new IllegalArgumentException("lines.length < 2");
        }
        this.shared = shared;
        this.lines = lines;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MultiLinePoint)) {
            return false;
        }
        MultiLinePoint other = (MultiLinePoint)obj;
        return this.shared.equals(other.shared) && Arrays.equals(this.lines, other.lines);
    }

    public int hashCode() {
        return this.shared.hashCode();
    }

    public String toString() {
        return String.format("MultiLinePoint[shared=%s, lines.length=%d]", this.shared, this.lines == null ? 0 : this.lines.length);
    }

    public static final class Line {
        public final int index;
        public final LineLocation location;

        Line(int index, LineLocation location) {
            if (index < 0) {
                throw new IllegalArgumentException("index < 0");
            }
            if (!LineLocation.contains(location)) {
                throw new IllegalArgumentException("location != START, BETWEEN, END");
            }
            this.index = index;
            this.location = location;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Line)) {
                return false;
            }
            Line other = (Line)obj;
            return this.index == other.index && this.location == other.location;
        }

        public int hashCode() {
            return this.index;
        }

        public String toString() {
            return String.format("Line[index=%d, location=%s]", new Object[]{this.index, this.location});
        }
    }
}

