/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.PointI;

public final class PointD {
    public final double x;
    public final double y;
    public static final PointD EMPTY = new PointD();

    public PointD() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public PointD(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public PointD add(PointD point) {
        return new PointD(this.x + point.x, this.y + point.y);
    }

    public double angle() {
        return Math.atan2(this.y, this.x);
    }

    public double angleBetween(PointD vector) {
        double y = this.x * vector.y - this.y * vector.x;
        double x = this.x * vector.x + this.y * vector.y;
        return Math.atan2(y, x);
    }

    public double angleBetween(PointD a, PointD b) {
        double ax = a.x - this.x;
        double ay = a.y - this.y;
        double bx = b.x - this.x;
        double by = b.y - this.y;
        double y = ax * by - ay * bx;
        double x = ax * bx + ay * by;
        return Math.atan2(y, x);
    }

    public double crossProductLength(PointD vector) {
        return this.x * vector.y - vector.x * this.y;
    }

    public double crossProductLength(PointD a, PointD b) {
        return (a.x - this.x) * (b.y - this.y) - (b.x - this.x) * (a.y - this.y);
    }

    public static boolean equals(PointD a, PointD b, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        return Math.abs(a.x - b.x) <= epsilon && Math.abs(a.y - b.y) <= epsilon;
    }

    public static PointD[] fromDoubles(double ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("points.length % 2 != 0");
        }
        PointD[] output = new PointD[points.length / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new PointD(points[2 * i], points[2 * i + 1]);
        }
        return output;
    }

    public static PointD fromPolar(double length, double angle) {
        return new PointD(length * Math.cos(angle), length * Math.sin(angle));
    }

    public boolean isCollinear(PointD a, PointD b) {
        return this.crossProductLength(a, b) == 0.0;
    }

    public boolean isCollinear(PointD a, PointD b, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        return Math.abs(this.crossProductLength(a, b)) <= epsilon;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public PointD move(PointD target, double distance) {
        if (distance == 0.0) {
            return this;
        }
        double dx = target.x - this.x;
        double dy = target.y - this.y;
        if (dx == 0.0) {
            if (dy > 0.0) {
                return new PointD(this.x, this.y + distance);
            }
            if (dy < 0.0) {
                return new PointD(this.x, this.y - distance);
            }
            return this;
        }
        if (dy == 0.0) {
            if (dx > 0.0) {
                return new PointD(this.x + distance, this.y);
            }
            return new PointD(this.x - distance, this.y);
        }
        double length = Math.sqrt(dx * dx + dy * dy);
        return new PointD(this.x + distance * dx / length, this.y + distance * dy / length);
    }

    public double multiply(PointD vector) {
        return this.x * vector.x + this.y * vector.y;
    }

    public PointD normalize() {
        double angle = Math.atan2(this.y, this.x);
        return new PointD(Math.cos(angle), Math.sin(angle));
    }

    public PointD restrict(double minX, double minY, double maxX, double maxY) {
        double x = this.x;
        double y = this.y;
        if (x < minX) {
            x = minX;
        } else if (x > maxX) {
            x = maxX;
        }
        if (y < minY) {
            y = minY;
        } else if (y > maxY) {
            y = maxY;
        }
        return new PointD(x, y);
    }

    public PointI round() {
        return new PointI(Fortran.nint(this.x), Fortran.nint(this.y));
    }

    public PointD subtract(PointD point) {
        return new PointD(this.x - point.x, this.y - point.y);
    }

    public static double[] toDoubles(PointD ... points) {
        double[] output = new double[2 * points.length];
        for (int i = 0; i < points.length; ++i) {
            output[2 * i] = points[i].x;
            output[2 * i + 1] = points[i].y;
        }
        return output;
    }

    public PointI toPointI() {
        return new PointI(MathUtils.toIntExact(this.x), MathUtils.toIntExact(this.y));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PointD)) {
            return false;
        }
        PointD point = (PointD)obj;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        long xHash = Double.doubleToLongBits(this.x);
        long yHash = Double.doubleToLongBits(this.y);
        return 31 * (int)(xHash ^ xHash >>> 32) + (int)(yHash ^ yHash >>> 32);
    }

    public String toString() {
        return String.format("PointD[x=%g, y=%g]", this.x, this.y);
    }
}

