/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.RectD;

public abstract class PointDComparator
implements Comparator<PointD>,
Serializable {
    private static final long serialVersionUID = 0L;
    public final double epsilon;

    public PointDComparator() {
        this.epsilon = 0.0;
    }

    public PointDComparator(double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        this.epsilon = epsilon;
    }

    public int findNearest(List<PointD> points, PointD q) {
        if (points == null || points.isEmpty()) {
            throw new NullPointerException("points");
        }
        int last = points.size() - 1;
        if (last == 0) {
            return 0;
        }
        int index = Collections.binarySearch(points, q, this);
        if (index < 0) {
            index = Math.min(~index, last);
        } else if (this.epsilon == 0.0) {
            return index;
        }
        PointD vector = points.get(index).subtract(q);
        double minDistance = vector.lengthSquared();
        if (minDistance == 0.0) {
            return index;
        }
        int minIndex = index;
        double epsilon2 = 2.0 * this.epsilon;
        boolean searchPlus = true;
        boolean searchMinus = true;
        int search = 1;
        while (searchPlus || searchMinus) {
            double distance;
            double delta;
            int i;
            if (searchPlus) {
                i = index + search;
                if (i > last) {
                    searchPlus = false;
                } else {
                    vector = points.get(i).subtract(q);
                    delta = Math.abs(this.getPrimary(vector)) - epsilon2;
                    if (delta * delta - epsilon2 > minDistance) {
                        searchPlus = false;
                    } else {
                        distance = vector.lengthSquared();
                        if (minDistance > distance) {
                            if (distance == 0.0) {
                                return i;
                            }
                            minDistance = distance;
                            minIndex = i;
                        }
                    }
                }
            }
            if (searchMinus) {
                i = index - search;
                if (i < 0) {
                    searchMinus = false;
                } else {
                    vector = points.get(i).subtract(q);
                    delta = Math.abs(this.getPrimary(vector)) - epsilon2;
                    if (delta * delta - epsilon2 > minDistance) {
                        searchMinus = false;
                    } else {
                        distance = vector.lengthSquared();
                        if (minDistance > distance) {
                            if (distance == 0.0) {
                                return i;
                            }
                            minDistance = distance;
                            minIndex = i;
                        }
                    }
                }
            }
            ++search;
        }
        return minIndex;
    }

    public PointD findNearest(NavigableSet<PointD> points, PointD q) {
        NavigableSet<PointD> greaterSet;
        if (points == null || points.isEmpty()) {
            throw new NullPointerException("points");
        }
        if (points.comparator() != this) {
            throw new IllegalArgumentException("points.comparator != this");
        }
        if (points.size() == 1) {
            return (PointD)points.first();
        }
        PointD minPoint = null;
        double minDistance = Double.MAX_VALUE;
        NavigableSet<PointD> smallerSet = points.headSet(q, true);
        if (!smallerSet.isEmpty()) {
            PointD smallerLast = (PointD)smallerSet.last();
            if (this.compare(smallerLast, q) == 0) {
                return smallerLast;
            }
            minPoint = smallerLast;
            minDistance = minPoint.subtract(q).lengthSquared();
        }
        if (!(greaterSet = points.tailSet(q, true)).isEmpty()) {
            PointD greaterFirst = (PointD)greaterSet.first();
            if (this.compare(greaterFirst, q) == 0) {
                return greaterFirst;
            }
            if (minPoint == null) {
                minPoint = greaterFirst;
                minDistance = minPoint.subtract(q).lengthSquared();
            } else {
                double greaterDistance = greaterFirst.subtract(q).lengthSquared();
                if (minDistance > greaterDistance) {
                    minPoint = greaterFirst;
                    minDistance = greaterDistance;
                }
            }
        }
        assert (minPoint != null);
        assert (minDistance > 0.0);
        Iterator<PointD> smallerSearch = smallerSet.isEmpty() ? null : smallerSet.descendingIterator();
        Iterator<PointD> greaterSearch = greaterSet.isEmpty() ? null : greaterSet.iterator();
        double epsilon2 = 2.0 * this.epsilon;
        while (smallerSearch != null || greaterSearch != null) {
            double distance;
            double delta;
            PointD vector;
            PointD next;
            if (greaterSearch != null) {
                if (!greaterSearch.hasNext()) {
                    greaterSearch = null;
                } else {
                    next = greaterSearch.next();
                    vector = next.subtract(q);
                    delta = Math.abs(this.getPrimary(vector)) - epsilon2;
                    if (delta * delta - epsilon2 > minDistance) {
                        greaterSearch = null;
                    } else {
                        distance = vector.lengthSquared();
                        if (minDistance > distance) {
                            if (distance == 0.0) {
                                return next;
                            }
                            minDistance = distance;
                            minPoint = next;
                        }
                    }
                }
            }
            if (smallerSearch == null) continue;
            if (!smallerSearch.hasNext()) {
                smallerSearch = null;
                continue;
            }
            next = smallerSearch.next();
            vector = next.subtract(q);
            delta = Math.abs(this.getPrimary(vector)) - epsilon2;
            if (delta * delta - epsilon2 > minDistance) {
                smallerSearch = null;
                continue;
            }
            distance = vector.lengthSquared();
            if (!(minDistance > distance)) continue;
            if (distance == 0.0) {
                return next;
            }
            minDistance = distance;
            minPoint = next;
        }
        return minPoint;
    }

    public <V> NavigableMap<PointD, V> findRange(NavigableMap<PointD, V> map, RectD range) {
        if (map.comparator() != this) {
            throw new IllegalArgumentException("map.comparator != this");
        }
        TreeMap found = new TreeMap(this);
        double minSec = this.getSecondary(range.min) - this.epsilon;
        double maxSec = this.getSecondary(range.max) + this.epsilon;
        for (Map.Entry entry : map.subMap(range.min, true, range.max, true).entrySet()) {
            double sec = this.getSecondary((PointD)entry.getKey());
            if (!(sec >= minSec) || !(sec <= maxSec)) continue;
            found.put((PointD)entry.getKey(), entry.getValue());
        }
        return found;
    }

    public NavigableSet<PointD> findRange(NavigableSet<PointD> points, RectD range) {
        if (points.comparator() != this) {
            throw new IllegalArgumentException("points.comparator != this");
        }
        TreeSet<PointD> found = new TreeSet<PointD>(this);
        double minSec = this.getSecondary(range.min) - this.epsilon;
        double maxSec = this.getSecondary(range.max) + this.epsilon;
        for (PointD point : points.subSet(range.min, true, range.max, true)) {
            double sec = this.getSecondary(point);
            if (!(sec >= minSec) || !(sec <= maxSec)) continue;
            found.add(point);
        }
        return found;
    }

    protected abstract double getPrimary(PointD var1);

    protected abstract double getSecondary(PointD var1);
}

