/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparator;

public final class PointDComparatorY
extends PointDComparator {
    private static final long serialVersionUID = 0L;

    public PointDComparatorY() {
    }

    public PointDComparatorY(double epsilon) {
        super(epsilon);
    }

    @Override
    public int compare(PointD a, PointD b) {
        return this.epsilon == 0.0 ? PointDComparatorY.compareExact(a, b) : PointDComparatorY.compareEpsilon(a, b, this.epsilon);
    }

    public int compareEpsilon(PointD a, PointD b) {
        return PointDComparatorY.compareEpsilon(a, b, this.epsilon);
    }

    public static int compareEpsilon(PointD a, PointD b, double epsilon) {
        if (a == b) {
            return 0;
        }
        int result = MathUtils.compare(a.y, b.y, epsilon);
        if (result != 0) {
            return result;
        }
        return MathUtils.compare(a.x, b.x, epsilon);
    }

    public static int compareExact(PointD a, PointD b) {
        if (a == b) {
            return 0;
        }
        if (a.y < b.y) {
            return -1;
        }
        if (a.y > b.y) {
            return 1;
        }
        if (a.x < b.x) {
            return -1;
        }
        if (a.x > b.x) {
            return 1;
        }
        return 0;
    }

    @Override
    protected double getPrimary(PointD point) {
        return point.y;
    }

    @Override
    protected double getSecondary(PointD point) {
        return point.x;
    }
}

