/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.geometry.PointD;

public final class PointI {
    public final int x;
    public final int y;
    public static final PointI EMPTY = new PointI();

    public PointI() {
        this.x = 0;
        this.y = 0;
    }

    public PointI(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public PointI add(PointI point) {
        return new PointI(Math.addExact(this.x, point.x), Math.addExact(this.y, point.y));
    }

    public double angle() {
        return Math.atan2(this.y, this.x);
    }

    public double angleBetween(PointI vector) {
        double y = (double)this.x * (double)vector.y - (double)this.y * (double)vector.x;
        double x = (double)this.x * (double)vector.x + (double)this.y * (double)vector.y;
        return Math.atan2(y, x);
    }

    public double angleBetween(PointI a, PointI b) {
        double ax = (double)a.x - (double)this.x;
        double ay = (double)a.y - (double)this.y;
        double bx = (double)b.x - (double)this.x;
        double by = (double)b.y - (double)this.y;
        double y = ax * by - ay * bx;
        double x = ax * bx + ay * by;
        return Math.atan2(y, x);
    }

    public long crossProductLength(PointI vector) {
        return (long)this.x * (long)vector.y - (long)vector.x * (long)this.y;
    }

    public long crossProductLength(PointI a, PointI b) {
        return ((long)a.x - (long)this.x) * ((long)b.y - (long)this.y) - ((long)b.x - (long)this.x) * ((long)a.y - (long)this.y);
    }

    public static PointI[] fromInts(int ... points) {
        if (points.length % 2 != 0) {
            throw new IllegalArgumentException("points.length % 2 != 0");
        }
        PointI[] output = new PointI[points.length / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new PointI(points[2 * i], points[2 * i + 1]);
        }
        return output;
    }

    public static PointI fromPolar(double length, double angle) {
        return new PointI(Fortran.nint(length * Math.cos(angle)), Fortran.nint(length * Math.sin(angle)));
    }

    public boolean isCollinear(PointI a, PointI b) {
        return this.crossProductLength(a, b) == 0L;
    }

    public double length() {
        return Math.sqrt((double)this.x * (double)this.x + (double)this.y * (double)this.y);
    }

    public long lengthSquared() {
        return (long)this.x * (long)this.x + (long)this.y * (long)this.y;
    }

    public long multiply(PointI vector) {
        return (long)this.x * (long)vector.x + (long)this.y * (long)vector.y;
    }

    public PointI restrict(int minX, int minY, int maxX, int maxY) {
        int x = this.x;
        int y = this.y;
        if (x < minX) {
            x = minX;
        } else if (x > maxX) {
            x = maxX;
        }
        if (y < minY) {
            y = minY;
        } else if (y > maxY) {
            y = maxY;
        }
        return new PointI(x, y);
    }

    public PointI subtract(PointI point) {
        return new PointI(Math.subtractExact(this.x, point.x), Math.subtractExact(this.y, point.y));
    }

    public static int[] toInts(PointI ... points) {
        int[] output = new int[2 * points.length];
        for (int i = 0; i < points.length; ++i) {
            output[2 * i] = points[i].x;
            output[2 * i + 1] = points[i].y;
        }
        return output;
    }

    public PointD toPointD() {
        return new PointD(this.x, this.y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PointI)) {
            return false;
        }
        PointI point = (PointI)obj;
        return this.x == point.x && this.y == point.y;
    }

    public int hashCode() {
        return 31 * this.x + this.y;
    }

    public String toString() {
        return String.format("PointI[x=%d, y=%d]", this.x, this.y);
    }
}

