/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.PolygonGridShift;
import org.kynosarges.tektosyne.geometry.PolygonOrientation;
import org.kynosarges.tektosyne.geometry.RectD;
import org.kynosarges.tektosyne.geometry.RectI;
import org.kynosarges.tektosyne.geometry.RegularPolygon;
import org.kynosarges.tektosyne.geometry.SizeD;
import org.kynosarges.tektosyne.geometry.SizeI;
import org.kynosarges.tektosyne.graph.Graph;

public class PolygonGrid
implements Graph<PointI> {
    private final InstanceData _data;
    public static final PointI INVALID_LOCATION = new PointI(-1, -1);
    public final boolean isReadOnly;

    public PolygonGrid(RegularPolygon element) {
        if (element == null) {
            throw new NullPointerException("element");
        }
        this.isReadOnly = false;
        this._data = new InstanceData();
        this.setElement(element);
        this.setSize(new SizeI(1, 1));
    }

    public PolygonGrid(RegularPolygon element, PolygonGridShift gridShift) {
        this(element);
        this.setGridShift(gridShift);
    }

    public PolygonGrid(PolygonGrid grid) {
        if (grid == null) {
            throw new NullPointerException("grid");
        }
        this.isReadOnly = false;
        this._data = new InstanceData(grid._data);
    }

    private PolygonGrid(InstanceData data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.isReadOnly = true;
        this._data = data;
    }

    public SizeD centerDistance() {
        return this._data.centerDistance;
    }

    public PointI[][] edgeNeighborOffsets() {
        return this._data.edgeNeighborOffsets;
    }

    public final RegularPolygon element() {
        return this._data.element;
    }

    public final PolygonGridShift gridShift() {
        return this._data.gridShift;
    }

    public PointI[][] neighborOffsets() {
        return this._data.neighborOffsets;
    }

    public final SizeI size() {
        return this._data.size;
    }

    public RectD worldBounds() {
        return this._data.worldBounds;
    }

    public static boolean areCompatible(RegularPolygon element, PolygonGridShift gridShift) {
        boolean onVertex;
        if (element == null) {
            throw new NullPointerException("element");
        }
        if (gridShift == null) {
            throw new NullPointerException("gridShift");
        }
        boolean isSquare = element.sides == 4;
        boolean isHexagon = element.sides == 6;
        boolean onEdge = element.orientation == PolygonOrientation.ON_EDGE;
        boolean bl = onVertex = element.orientation == PolygonOrientation.ON_VERTEX;
        if (!isSquare && !isHexagon) {
            throw new IllegalArgumentException("element.sides != 4 or 6");
        }
        switch (gridShift) {
            case NONE: {
                return isSquare && onEdge;
            }
            case COLUMN_UP: 
            case COLUMN_DOWN: {
                return isSquare && onVertex || isHexagon && onEdge;
            }
            case ROW_LEFT: 
            case ROW_RIGHT: {
                return onVertex;
            }
        }
        throw new IllegalArgumentException("gridShift");
    }

    public PolygonGrid asReadOnly() {
        return this.isReadOnly ? this : new PolygonGrid(this._data);
    }

    public boolean contains(int column, int row) {
        return column >= 0 && column < this.size().width && row >= 0 && row < this.size().height;
    }

    @Override
    public boolean contains(RectI rect) {
        return this.contains(rect.min) && this.contains(rect.max);
    }

    public <T> T[][] createArray(Class<T> clazz) {
        return (Object[][])Array.newInstance(clazz, this.size().width, this.size().height);
    }

    public PointI[] getEdgeNeighborOffsets(PointI location) {
        int index = this.gridShift().isRightRow(location.y) || this.gridShift().isDownColumn(location.x) ? 1 : 0;
        return this.edgeNeighborOffsets()[index];
    }

    public RectD getElementBounds(int column, int row) {
        PointD center = this.gridToWorld(column, row);
        return this.element().bounds.offset(center);
    }

    public RectD getElementBounds(PointI location) {
        return this.getElementBounds(location.x, location.y);
    }

    public RectD getElementBounds(RectI region) {
        if (region.width() == 0L) {
            throw new IllegalArgumentException("region.width == 0");
        }
        if (region.height() == 0L) {
            throw new IllegalArgumentException("region.height == 0");
        }
        if (region.width() == 1L && region.height() == 1L) {
            return this.getElementBounds(region.min);
        }
        double width = this.element().bounds.width();
        double width2 = width / 2.0;
        double height = this.element().bounds.height();
        double height2 = height / 2.0;
        PointD location = this.gridToWorld(region.min);
        double left = location.x - width2;
        double top = location.y - height2;
        width += (double)(region.width() - 1L) * this.centerDistance().width;
        height += (double)(region.height() - 1L) * this.centerDistance().height;
        if (this.gridShift().anyColumns() && region.width() > 1L) {
            height += height2;
            if (this.gridShift().isDownColumn(region.min.x)) {
                top -= height2;
            }
        } else if (this.gridShift().anyRows() && region.height() > 1L) {
            width += width2;
            if (this.gridShift().isRightRow(region.min.y)) {
                left -= width2;
            }
        }
        return new RectD(left, top, width, height);
    }

    public PointD[] getElementVertices(int column, int row) {
        PointD[] vertices = this.element().vertices;
        PointD[] shiftedVertices = new PointD[vertices.length];
        PointD center = this.gridToWorld(column, row);
        for (int i = 0; i < vertices.length; ++i) {
            shiftedVertices[i] = vertices[i].add(center);
        }
        return shiftedVertices;
    }

    public PointI getNeighbor(PointI location, int index) {
        PointI[] offsets = this.getNeighborOffsets(location);
        index = Fortran.modulo(index, offsets.length);
        return location.add(offsets[index]);
    }

    public int getNeighborIndex(PointI location, PointI neighbor) {
        PointI offset = neighbor.subtract(location);
        PointI[] offsets = this.getNeighborOffsets(location);
        for (int i = 0; i < offsets.length; ++i) {
            if (!offsets[i].equals(offset)) continue;
            return i;
        }
        throw new IllegalArgumentException("no neighbor of location");
    }

    public PointI[] getNeighborOffsets(PointI location) {
        int index = this.gridShift().isRightRow(location.y) || this.gridShift().isDownColumn(location.x) ? 1 : 0;
        return this.neighborOffsets()[index];
    }

    public int getStepDistance(PointI source, PointI target) {
        return this._data.getStepDistanceCore(source.x, source.y, target.x, target.y);
    }

    public PointD gridToWorld(int column, int row) {
        return this._data.gridToWorldCore(column, row);
    }

    public PointD gridToWorld(PointI location) {
        return this.gridToWorld(location.x, location.y);
    }

    public boolean isValid(int column, int row) {
        return column >= 0 && row >= 0 && column < this._data.size.width && row < this._data.size.height;
    }

    public boolean isValid(PointI location) {
        return location != null && this.isValid(location.x, location.y);
    }

    public final void setElement(RegularPolygon element) {
        if (this.isReadOnly) {
            throw new IllegalStateException("isReadOnly");
        }
        if (!PolygonGrid.areCompatible(element, this.gridShift())) {
            boolean onEdge;
            boolean bl = onEdge = element.orientation == PolygonOrientation.ON_EDGE;
            if (element.sides == 4) {
                this._data.gridShift = onEdge ? PolygonGridShift.NONE : PolygonGridShift.ROW_RIGHT;
            } else {
                assert (element.sides == 6);
                this._data.gridShift = onEdge ? PolygonGridShift.COLUMN_DOWN : PolygonGridShift.ROW_RIGHT;
            }
        }
        this._data.element = element;
        this._data.onGeometryChanged();
    }

    public final void setGridShift(PolygonGridShift gridShift) {
        if (this.isReadOnly) {
            throw new IllegalStateException("isReadOnly");
        }
        if (!PolygonGrid.areCompatible(this.element(), gridShift)) {
            throw new IllegalArgumentException("gridShift incompatible with element");
        }
        this._data.gridShift = gridShift;
        this._data.onGeometryChanged();
    }

    public final void setSize(SizeI size) {
        if (this.isReadOnly) {
            throw new IllegalStateException("isReadOnly");
        }
        if (size.width < 1) {
            throw new IllegalArgumentException("size.width < 1");
        }
        if (size.height < 1) {
            throw new IllegalArgumentException("size.height < 1");
        }
        this._data.size = size;
        this._data.onSizeChanged();
    }

    public PointI worldToGrid(double x, double y) {
        if (!this.worldBounds().contains(x, y)) {
            return INVALID_LOCATION;
        }
        PointI element = this._data.worldToGridCore(x, y);
        return this.contains(element) ? element : INVALID_LOCATION;
    }

    public PointI worldToGrid(PointD location) {
        return this.worldToGrid(location.x, location.y);
    }

    public PointI worldToGridClipped(double x, double y) {
        double marginX = this.element().bounds.width() / 2.0;
        double marginY = this.element().bounds.height() / 2.0;
        if (x <= marginX) {
            x = marginX + 1.0;
        } else if (x >= this.worldBounds().width() - marginX) {
            x = this.worldBounds().width() - marginX - 1.0;
        }
        if (y <= marginY) {
            y = marginY + 1.0;
        } else if (y >= this.worldBounds().height() - marginY) {
            y = this.worldBounds().height() - marginY - 1.0;
        }
        PointI element = this._data.worldToGridCore(x, y);
        return element.restrict(0, 0, this.size().width - 1, this.size().height - 1);
    }

    public PointI worldToGridClipped(PointD location) {
        return this.worldToGridClipped(location.x, location.y);
    }

    @Override
    public int connectivity() {
        return this.element().connectivity;
    }

    @Override
    public int nodeCount() {
        return this.size().width * this.size().height;
    }

    @Override
    public List<PointI> nodes() {
        int width = this.size().width;
        int height = this.size().height;
        ArrayList<PointI> nodes = new ArrayList<PointI>(width * height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                nodes.add(new PointI(x, y));
            }
        }
        return nodes;
    }

    @Override
    public boolean contains(PointI node) {
        return this.contains(node.x, node.y);
    }

    @Override
    public PointI findNearestNode(PointD location) {
        return this.worldToGridClipped(location.x, location.y);
    }

    @Override
    public double getDistance(PointI source, PointI target) {
        return this.getStepDistance(source, target);
    }

    @Override
    public List<PointI> getNeighbors(PointI node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (!this.contains(node)) {
            return Collections.emptyList();
        }
        PointI[] offsets = this.getNeighborOffsets(node);
        ArrayList<PointI> neighbors = new ArrayList<PointI>(offsets.length);
        for (PointI offset : offsets) {
            PointI neighbor = node.add(offset);
            if (!this.contains(neighbor)) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    @Override
    public List<PointI> getNeighbors(PointI node, int steps) {
        if (steps <= 0) {
            throw new IllegalArgumentException("distance <= 0");
        }
        if (!this.contains(node)) {
            return Collections.emptyList();
        }
        if (steps == 1) {
            return this.getNeighbors(node);
        }
        ArrayList<PointI> neighbors = new ArrayList<PointI>();
        int distanceX = steps;
        int distanceY = steps;
        if (this.element().sides == 4 && this.element().orientation == PolygonOrientation.ON_VERTEX) {
            if (this.gridShift().anyColumns()) {
                if (this.element().vertexNeighbors) {
                    distanceX *= 2;
                } else {
                    distanceY = (distanceY + 1) / 2;
                }
            } else {
                assert (this.gridShift().anyRows());
                if (this.element().vertexNeighbors) {
                    distanceY *= 2;
                } else {
                    distanceX = (distanceX + 1) / 2;
                }
            }
        }
        int minX = Math.max(node.x - distanceX, 0);
        int maxX = Math.min(node.x + distanceX, this.size().width - 1);
        int minY = Math.max(node.y - distanceY, 0);
        int maxY = Math.min(node.y + distanceY, this.size().height - 1);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                PointI neighbor = new PointI(x, y);
                int delta = this.getStepDistance(node, neighbor);
                if (delta <= 0 || delta > steps) continue;
                neighbors.add(neighbor);
            }
        }
        return neighbors;
    }

    Collection<PointI> getNeighborsGraph(PointI node, int steps) {
        return Graph.super.getNeighbors(node, steps);
    }

    @Override
    public PointD getWorldLocation(PointI node) {
        return this.gridToWorld(node.x, node.y);
    }

    @Override
    public PointD[] getWorldRegion(PointI node) {
        return this.getElementVertices(node.x, node.y);
    }

    private static class GeometryOffsets {
        static final PointI[][][] SQUARE_EDGE_OFFSETS = new PointI[][][]{{{new PointI(0, -1), new PointI(1, 0), new PointI(0, 1), new PointI(-1, 0)}}, {{new PointI(0, -1), new PointI(1, -1), new PointI(1, 0), new PointI(1, 1), new PointI(0, 1), new PointI(-1, 1), new PointI(-1, 0), new PointI(-1, -1)}}};
        static final PointI[][][] SQUARE_VERTEX_COLUMN_OFFSETS = new PointI[][][]{{{new PointI(1, -1), new PointI(1, 0), new PointI(-1, 0), new PointI(-1, -1)}, {new PointI(1, 0), new PointI(1, 1), new PointI(-1, 1), new PointI(-1, 0)}}, {{new PointI(0, -1), new PointI(1, -1), new PointI(2, 0), new PointI(1, 0), new PointI(0, 1), new PointI(-1, 0), new PointI(-2, 0), new PointI(-1, -1)}, {new PointI(0, -1), new PointI(1, 0), new PointI(2, 0), new PointI(1, 1), new PointI(0, 1), new PointI(-1, 1), new PointI(-2, 0), new PointI(-1, 0)}}};
        static final PointI[][][] SQUARE_VERTEX_ROW_OFFSETS = new PointI[][][]{{{new PointI(0, -1), new PointI(0, 1), new PointI(-1, 1), new PointI(-1, -1)}, {new PointI(1, -1), new PointI(1, 1), new PointI(0, 1), new PointI(0, -1)}}, {{new PointI(0, -2), new PointI(0, -1), new PointI(1, 0), new PointI(0, 1), new PointI(0, 2), new PointI(-1, 1), new PointI(-1, 0), new PointI(-1, -1)}, {new PointI(0, -2), new PointI(1, -1), new PointI(1, 0), new PointI(1, 1), new PointI(0, 2), new PointI(0, 1), new PointI(-1, 0), new PointI(0, -1)}}};
        static final PointI[][] HEXAGON_EDGE_OFFSETS = new PointI[][]{{new PointI(0, -1), new PointI(1, -1), new PointI(1, 0), new PointI(0, 1), new PointI(-1, 0), new PointI(-1, -1)}, {new PointI(0, -1), new PointI(1, 0), new PointI(1, 1), new PointI(0, 1), new PointI(-1, 1), new PointI(-1, 0)}};
        static final PointI[][] HEXAGON_VERTEX_OFFSETS = new PointI[][]{{new PointI(0, -1), new PointI(1, 0), new PointI(0, 1), new PointI(-1, 1), new PointI(-1, 0), new PointI(-1, -1)}, {new PointI(1, -1), new PointI(1, 0), new PointI(1, 1), new PointI(0, 1), new PointI(-1, 0), new PointI(0, -1)}};

        private GeometryOffsets() {
        }
    }

    private static class InstanceData {
        private static final double SQRT_3 = Math.sqrt(3.0);
        RegularPolygon element;
        PolygonGridShift gridShift = PolygonGridShift.NONE;
        SizeI size;
        SizeD centerDistance;
        RectD worldBounds;
        PointI[][] edgeNeighborOffsets;
        PointI[][] neighborOffsets;

        InstanceData() {
        }

        InstanceData(InstanceData data) {
            if (data == null) {
                throw new NullPointerException("data");
            }
            this.element = data.element;
            this.gridShift = data.gridShift;
            this.size = data.size;
            this.centerDistance = data.centerDistance;
            this.worldBounds = data.worldBounds;
            this.edgeNeighborOffsets = (PointI[][])data.edgeNeighborOffsets.clone();
            this.neighborOffsets = (PointI[][])data.neighborOffsets.clone();
        }

        int getStepDistanceCore(int sourceX, int sourceY, int targetX, int targetY) {
            int signDeltaX = targetX - sourceX;
            int signDeltaY = targetY - sourceY;
            if (signDeltaX == 0 && signDeltaY == 0) {
                return 0;
            }
            if (this.element.sides == 4) {
                int deltaX = Math.abs(signDeltaX);
                int deltaY = Math.abs(signDeltaY);
                if (this.element.orientation == PolygonOrientation.ON_EDGE) {
                    return this.element.vertexNeighbors ? Math.max(deltaX, deltaY) : deltaX + deltaY;
                }
                if (this.gridShift.anyColumns()) {
                    if (this.element.vertexNeighbors) {
                        int adjustX = this.gridShift.isDownColumn(sourceX) ? (signDeltaY <= 0 ? 1 : 0) : (signDeltaY >= 0 ? 1 : 0);
                        return deltaX / 2 + deltaY + adjustX * (deltaX % 2);
                    }
                    if (2 * deltaY <= deltaX) {
                        return deltaX;
                    }
                    assert (signDeltaY != 0);
                    int adjustX = this.gridShift.isDownColumn(sourceX) ? (signDeltaY < 0 ? 1 : -1) : (signDeltaY > 0 ? 1 : -1);
                    return 2 * deltaY + adjustX * (deltaX % 2);
                }
                if (this.element.vertexNeighbors) {
                    int adjustY = this.gridShift.isRightRow(sourceY) ? (signDeltaX <= 0 ? 1 : 0) : (signDeltaX >= 0 ? 1 : 0);
                    return deltaY / 2 + deltaX + adjustY * (deltaY % 2);
                }
                if (2 * deltaX <= deltaY) {
                    return deltaY;
                }
                assert (signDeltaX != 0);
                int adjustY = this.gridShift.isRightRow(sourceY) ? (signDeltaX < 0 ? 1 : -1) : (signDeltaX > 0 ? 1 : -1);
                return 2 * deltaX + adjustY * (deltaY % 2);
            }
            assert (this.element.sides == 6);
            if (this.gridShift.anyColumns()) {
                int deltaX = Math.abs(signDeltaX);
                int deltaY = Math.abs(signDeltaY -= (this.gridShift.isUpColumn(sourceX) ? deltaX : deltaX + 1) / 2);
                return signDeltaY < 0 ? Math.max(deltaX, deltaY) : deltaX + deltaY;
            }
            int deltaY = Math.abs(signDeltaY);
            int deltaX = Math.abs(signDeltaX -= (this.gridShift.isLeftRow(sourceY) ? deltaY : deltaY + 1) / 2);
            return signDeltaX < 0 ? Math.max(deltaX, deltaY) : deltaX + deltaY;
        }

        PointD gridToWorldCore(int column, int row) {
            PointI factor;
            boolean isDownColumn = this.gridShift.isDownColumn(column);
            boolean isRightRow = this.gridShift.isRightRow(row);
            if (this.element.sides == 4) {
                factor = this.element.orientation == PolygonOrientation.ON_EDGE ? new PointI(4 * column + 2, 4 * row + 2) : (this.gridShift.anyColumns() ? new PointI(2 * column + 2, 4 * row + (isDownColumn ? 4 : 2)) : new PointI(4 * column + (isRightRow ? 4 : 2), 2 * row + 2));
            } else {
                assert (this.element.sides == 6);
                factor = this.gridShift.anyColumns() ? new PointI(3 * column + 2, 4 * row + (isDownColumn ? 4 : 2)) : new PointI(4 * column + (isRightRow ? 4 : 2), 3 * row + 2);
            }
            return new PointD((double)factor.x * this.element.bounds.width() / 4.0, (double)factor.y * this.element.bounds.height() / 4.0);
        }

        void onGeometryChanged() {
            PointI[][] edgeNeighbors;
            PointI[][] neighbors;
            if (this.element.sides == 4) {
                int index;
                int n = index = this.element.vertexNeighbors ? 1 : 0;
                if (this.element.orientation == PolygonOrientation.ON_EDGE) {
                    double side = this.element.length;
                    this.centerDistance = new SizeD(side, side);
                    neighbors = GeometryOffsets.SQUARE_EDGE_OFFSETS[index];
                    edgeNeighbors = GeometryOffsets.SQUARE_EDGE_OFFSETS[0];
                } else {
                    double width = this.element.bounds.width();
                    double height = this.element.bounds.height();
                    if (this.gridShift.anyColumns()) {
                        this.centerDistance = new SizeD(width / 2.0, height);
                        neighbors = GeometryOffsets.SQUARE_VERTEX_COLUMN_OFFSETS[index];
                        edgeNeighbors = GeometryOffsets.SQUARE_VERTEX_COLUMN_OFFSETS[0];
                    } else {
                        this.centerDistance = new SizeD(width, height / 2.0);
                        neighbors = GeometryOffsets.SQUARE_VERTEX_ROW_OFFSETS[index];
                        edgeNeighbors = GeometryOffsets.SQUARE_VERTEX_ROW_OFFSETS[0];
                    }
                }
            } else {
                assert (this.element.sides == 6);
                double edgeDistance = 2.0 * this.element.innerRadius;
                double vertexDistance = 3.0 * this.element.outerRadius / 2.0;
                if (this.gridShift.anyColumns()) {
                    this.centerDistance = new SizeD(vertexDistance, edgeDistance);
                    edgeNeighbors = GeometryOffsets.HEXAGON_EDGE_OFFSETS;
                    neighbors = GeometryOffsets.HEXAGON_EDGE_OFFSETS;
                } else {
                    this.centerDistance = new SizeD(edgeDistance, vertexDistance);
                    edgeNeighbors = GeometryOffsets.HEXAGON_VERTEX_OFFSETS;
                    neighbors = GeometryOffsets.HEXAGON_VERTEX_OFFSETS;
                }
            }
            this.neighborOffsets = (PointI[][])neighbors.clone();
            this.edgeNeighborOffsets = (PointI[][])edgeNeighbors.clone();
            this.onSizeChanged();
        }

        void onSizeChanged() {
            if (this.size == null || this.size.isEmpty()) {
                this.worldBounds = RectD.EMPTY;
                return;
            }
            double elementWidth = this.element.bounds.width();
            double elementHeight = this.element.bounds.height();
            double width = elementWidth + (double)(this.size.width - 1) * this.centerDistance.width;
            double height = elementHeight + (double)(this.size.height - 1) * this.centerDistance.height;
            if (this.gridShift.anyColumns()) {
                height += elementHeight / 2.0;
            } else if (this.gridShift.anyRows()) {
                width += elementWidth / 2.0;
            }
            this.worldBounds = new RectD(0.0, 0.0, width, height);
        }

        PointI worldToGridCore(double x, double y) {
            int column;
            int index;
            double width = this.element.bounds.width();
            double height = this.element.bounds.height();
            if (this.element.sides == 4 && this.element.orientation == PolygonOrientation.ON_EDGE) {
                return new PointI((int)(x / width), (int)(y / height));
            }
            double assertEpsilon = Math.min(width / 100.0, height / 100.0);
            double width2 = width / 2.0;
            double height2 = height / 2.0;
            if (this.element.sides == 4) {
                int column2;
                int index2;
                assert (this.element.orientation != PolygonOrientation.ON_EDGE);
                if (this.gridShift.anyColumns()) {
                    int row;
                    int index3;
                    int column3 = (int)(x / width2);
                    if (this.gridShift.isDownColumn(column3)) {
                        index3 = 1;
                        row = (int)((y - height2) / height);
                    } else {
                        index3 = 0;
                        row = (int)(y / height);
                    }
                    y -= (double)(2 * row + index3 + 1) * height2;
                    assert (MathUtils.compare(x -= (double)(column3 + 1) * width2, -width2, assertEpsilon) >= 0);
                    assert (MathUtils.compare(x, 0.0, assertEpsilon) <= 0);
                    if (Math.abs(y) <= x + width2) {
                        return new PointI(column3, row);
                    }
                    PointI offset = this.edgeNeighborOffsets[index3][y < 0.0 ? 3 : 2];
                    return new PointI(column3 + offset.x, row + offset.y);
                }
                int row = (int)(y / height2);
                if (this.gridShift.isRightRow(row)) {
                    index2 = 1;
                    column2 = (int)((x - width2) / width);
                } else {
                    index2 = 0;
                    column2 = (int)(x / width);
                }
                x -= (double)(2 * column2 + index2 + 1) * width2;
                assert (MathUtils.compare(y -= (double)(row + 1) * height2, -height2, assertEpsilon) >= 0);
                assert (MathUtils.compare(y, 0.0, assertEpsilon) <= 0);
                if (Math.abs(x) <= y + height2) {
                    return new PointI(column2, row);
                }
                PointI offset = this.edgeNeighborOffsets[index2][x < 0.0 ? 3 : 0];
                return new PointI(column2 + offset.x, row + offset.y);
            }
            assert (this.element.sides == 6);
            double width4 = width / 4.0;
            double height4 = height / 4.0;
            if (this.gridShift.anyColumns()) {
                int row;
                int index4;
                int column4 = (int)(x / (3.0 * width4));
                if (this.gridShift.isDownColumn(column4)) {
                    index4 = 1;
                    row = (int)((y - height2) / height);
                } else {
                    index4 = 0;
                    row = (int)(y / height);
                }
                y -= (double)(2 * row + index4 + 1) * height2;
                assert (MathUtils.compare(x -= (double)(3 * column4 + 2) * width4, -width2, assertEpsilon) >= 0);
                assert (MathUtils.compare(x, width4, assertEpsilon) <= 0);
                if (Math.abs(y) <= (x + width2) * SQRT_3) {
                    return new PointI(column4, row);
                }
                PointI offset = this.edgeNeighborOffsets[index4][y < 0.0 ? 5 : 4];
                return new PointI(column4 + offset.x, row + offset.y);
            }
            int row = (int)(y / (3.0 * height4));
            if (this.gridShift.isRightRow(row)) {
                index = 1;
                column = (int)((x - width2) / width);
            } else {
                index = 0;
                column = (int)(x / width);
            }
            x -= (double)(2 * column + index + 1) * width2;
            assert (MathUtils.compare(y -= (double)(3 * row + 2) * height4, -height2, assertEpsilon) >= 0);
            assert (MathUtils.compare(y, height4, assertEpsilon) <= 0);
            if (Math.abs(x) <= (y + height2) * SQRT_3) {
                return new PointI(column, row);
            }
            PointI offset = this.edgeNeighborOffsets[index][x < 0.0 ? 5 : 0];
            return new PointI(column + offset.x, row + offset.y);
        }
    }
}

