/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

public enum PolygonGridShift {
    NONE,
    COLUMN_UP,
    COLUMN_DOWN,
    ROW_RIGHT,
    ROW_LEFT;


    public boolean anyColumns() {
        return this == COLUMN_UP || this == COLUMN_DOWN;
    }

    public boolean anyRows() {
        return this == ROW_LEFT || this == ROW_RIGHT;
    }

    public boolean isDownColumn(int column) {
        switch (this) {
            case COLUMN_UP: {
                return column % 2 == 0;
            }
            case COLUMN_DOWN: {
                return column % 2 != 0;
            }
        }
        return false;
    }

    public boolean isLeftRow(int row) {
        switch (this) {
            case ROW_LEFT: {
                return row % 2 != 0;
            }
            case ROW_RIGHT: {
                return row % 2 == 0;
            }
        }
        return false;
    }

    public boolean isRightRow(int row) {
        switch (this) {
            case ROW_LEFT: {
                return row % 2 == 0;
            }
            case ROW_RIGHT: {
                return row % 2 != 0;
            }
        }
        return false;
    }

    public boolean isUpColumn(int column) {
        switch (this) {
            case COLUMN_UP: {
                return column % 2 != 0;
            }
            case COLUMN_DOWN: {
                return column % 2 == 0;
            }
        }
        return false;
    }
}

