/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.Arrays;
import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.RectI;
import org.kynosarges.tektosyne.geometry.RectLocation;

public final class RectD {
    public final PointD min;
    public final PointD max;
    public static final RectD EMPTY = new RectD();

    public RectD() {
        this.min = PointD.EMPTY;
        this.max = PointD.EMPTY;
    }

    public RectD(double minX, double minY, double maxX, double maxY) {
        if (maxX < minX) {
            throw new IllegalArgumentException("maxX < minX");
        }
        if (maxY < minY) {
            throw new IllegalArgumentException("maxY < minY");
        }
        this.min = new PointD(minX, minY);
        this.max = new PointD(maxX, maxY);
    }

    public RectD(PointD min, PointD max) {
        if (max.x < min.x) {
            throw new IllegalArgumentException("max.x < min.x");
        }
        if (max.y < min.y) {
            throw new IllegalArgumentException("max.y < min.y");
        }
        this.min = min;
        this.max = max;
    }

    public PointD center() {
        return new PointD(this.min.x + (this.max.x - this.min.x) / 2.0, this.min.y + (this.max.y - this.min.y) / 2.0);
    }

    public RectI circumscribe() {
        return new RectI(Fortran.floor(this.min.x), Fortran.floor(this.min.y), Fortran.ceiling(this.max.x), Fortran.ceiling(this.max.y));
    }

    public static RectD circumscribe(PointD ... points) {
        if (points == null || points.length == 0) {
            throw new NullPointerException("points");
        }
        double x0 = Double.POSITIVE_INFINITY;
        double y0 = Double.POSITIVE_INFINITY;
        double x1 = Double.NEGATIVE_INFINITY;
        double y1 = Double.NEGATIVE_INFINITY;
        for (PointD point : points) {
            if (x0 > point.x) {
                x0 = point.x;
            }
            if (y0 > point.y) {
                y0 = point.y;
            }
            if (x1 < point.x) {
                x1 = point.x;
            }
            if (!(y1 < point.y)) continue;
            y1 = point.y;
        }
        return new RectD(x0, y0, x1, y1);
    }

    public boolean contains(double x, double y) {
        return x >= this.min.x && y >= this.min.y && x <= this.max.x && y <= this.max.y;
    }

    public boolean contains(PointD point) {
        return this.contains(point.x, point.y);
    }

    public boolean containsOpen(double x, double y) {
        return x >= this.min.x && y >= this.min.y && x < this.max.x && y < this.max.y;
    }

    public boolean containsOpen(PointD point) {
        return this.containsOpen(point.x, point.y);
    }

    public boolean contains(RectD rect) {
        return rect.min.x >= this.min.x && rect.min.y >= this.min.y && rect.max.x <= this.max.x && rect.max.y <= this.max.y;
    }

    public PointD distanceVector(PointD q) {
        double x;
        double d = q.x < this.min.x ? q.x - this.min.x : (x = q.x > this.max.x ? q.x - this.max.x : 0.0);
        double y = q.y < this.min.y ? q.y - this.min.y : (q.y > this.max.y ? q.y - this.max.y : 0.0);
        return new PointD(x, y);
    }

    public static boolean equals(RectD a, RectD b, double epsilon) {
        return PointD.equals(a.min, b.min, epsilon) && PointD.equals(a.max, b.max, epsilon);
    }

    public static RectD[] fromDoubles(double ... rects) {
        if (rects.length % 4 != 0) {
            throw new IllegalArgumentException("rects.length % 4 != 0");
        }
        RectD[] output = new RectD[rects.length / 4];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new RectD(rects[4 * i], rects[4 * i + 1], rects[4 * i + 2], rects[4 * i + 3]);
        }
        return output;
    }

    public double height() {
        return this.max.y - this.min.y;
    }

    public LineD intersect(LineD line) {
        double x0 = line.start.x;
        double y0 = line.start.y;
        double dx = line.end.x - x0;
        double dy = line.end.y - y0;
        double t0 = 0.0;
        double t1 = 1.0;
        double p = 0.0;
        double q = 0.0;
        for (int border = 0; border < 4; ++border) {
            switch (border) {
                case 0: {
                    p = -dx;
                    q = x0 - this.min.x;
                    break;
                }
                case 1: {
                    p = dx;
                    q = this.max.x - x0;
                    break;
                }
                case 2: {
                    p = -dy;
                    q = y0 - this.min.y;
                    break;
                }
                case 3: {
                    p = dy;
                    q = this.max.y - y0;
                }
            }
            if (p == 0.0) {
                if (!(q < 0.0)) continue;
                return null;
            }
            double r = q / p;
            if (p < 0.0) {
                if (r > t1) {
                    return null;
                }
                if (!(r > t0)) continue;
                t0 = r;
                continue;
            }
            if (r < t0) {
                return null;
            }
            if (!(r < t1)) continue;
            t1 = r;
        }
        return new LineD(x0 + t0 * dx, y0 + t0 * dy, x0 + t1 * dx, y0 + t1 * dy);
    }

    public PointD[] intersect(PointD[] polygon) {
        if (polygon == null || polygon.length == 0) {
            throw new NullPointerException("polygon");
        }
        int outputLength = polygon.length;
        PointD[] inputVertices = new PointD[3 * outputLength];
        PointD[] outputVertices = new PointD[3 * outputLength];
        System.arraycopy(polygon, 0, outputVertices, 0, outputLength);
        double q = 0.0;
        boolean startInside = false;
        boolean endInside = false;
        for (int border = 0; border < 4; ++border) {
            switch (border) {
                case 0: {
                    q = this.min.x;
                    break;
                }
                case 1: {
                    q = this.max.x;
                    break;
                }
                case 2: {
                    q = this.min.y;
                    break;
                }
                case 3: {
                    q = this.max.y;
                }
            }
            PointD[] swap = inputVertices;
            inputVertices = outputVertices;
            outputVertices = swap;
            int inputLength = outputLength;
            outputLength = 0;
            PointD start = inputVertices[inputLength - 1];
            for (int i = 0; i < inputLength; ++i) {
                PointD end = inputVertices[i];
                switch (border) {
                    case 0: {
                        startInside = start.x >= q;
                        endInside = end.x >= q;
                        break;
                    }
                    case 1: {
                        startInside = start.x <= q;
                        endInside = end.x <= q;
                        break;
                    }
                    case 2: {
                        startInside = start.y >= q;
                        endInside = end.y >= q;
                        break;
                    }
                    case 3: {
                        startInside = start.y <= q;
                        boolean bl = endInside = end.y <= q;
                    }
                }
                if (startInside != endInside) {
                    double y;
                    double x;
                    double dx = end.x - start.x;
                    double dy = end.y - start.y;
                    if (border < 2) {
                        x = q;
                        y = x == end.x ? end.y : start.y + (x - start.x) * dy / dx;
                    } else {
                        y = q;
                        x = y == end.y ? end.x : start.x + (y - start.y) * dx / dy;
                    }
                    outputVertices[outputLength++] = new PointD(x, y);
                }
                if (endInside) {
                    outputVertices[outputLength++] = end;
                }
                start = end;
            }
            if (outputLength != 0) continue;
            return null;
        }
        return Arrays.copyOfRange(outputVertices, 0, outputLength);
    }

    public RectD intersect(RectD rect) {
        double minX = Math.max(this.min.x, rect.min.x);
        double minY = Math.max(this.min.y, rect.min.y);
        double maxX = Math.min(this.max.x, rect.max.x);
        double maxY = Math.min(this.max.y, rect.max.y);
        if (minX > maxX || minY > maxY) {
            return null;
        }
        return new RectD(minX, minY, maxX, maxY);
    }

    public boolean intersectsWith(LineD line) {
        double x0 = line.start.x;
        double y0 = line.start.y;
        double dx = line.end.x - x0;
        double dy = line.end.y - y0;
        double t0 = 0.0;
        double t1 = 1.0;
        double p = 0.0;
        double q = 0.0;
        for (int border = 0; border < 4; ++border) {
            switch (border) {
                case 0: {
                    p = -dx;
                    q = x0 - this.min.x;
                    break;
                }
                case 1: {
                    p = dx;
                    q = this.max.x - x0;
                    break;
                }
                case 2: {
                    p = -dy;
                    q = y0 - this.min.y;
                    break;
                }
                case 3: {
                    p = dy;
                    q = this.max.y - y0;
                }
            }
            if (p == 0.0) {
                if (!(q < 0.0)) continue;
                return false;
            }
            double r = q / p;
            if (p < 0.0) {
                if (r > t1) {
                    return false;
                }
                if (!(r > t0)) continue;
                t0 = r;
                continue;
            }
            if (r < t0) {
                return false;
            }
            if (!(r < t1)) continue;
            t1 = r;
        }
        return true;
    }

    public boolean intersectsWith(RectD rect) {
        return rect.max.x >= this.min.x && rect.min.x <= this.max.x && rect.max.y >= this.min.y && rect.min.y <= this.max.y;
    }

    public RectLocation locate(PointD q) {
        LineLocation x;
        LineLocation lineLocation = q.x < this.min.x ? LineLocation.BEFORE : (q.x == this.min.x ? LineLocation.START : (q.x < this.max.x ? LineLocation.BETWEEN : (x = q.x == this.max.x ? LineLocation.END : LineLocation.AFTER)));
        LineLocation y = q.y < this.min.y ? LineLocation.BEFORE : (q.y == this.min.y ? LineLocation.START : (q.y < this.max.y ? LineLocation.BETWEEN : (q.y == this.max.y ? LineLocation.END : LineLocation.AFTER)));
        return new RectLocation(x, y);
    }

    public RectLocation locate(PointD q, double epsilon) {
        LineLocation x;
        LineLocation lineLocation = MathUtils.equals(q.x, this.min.x, epsilon) ? LineLocation.START : (MathUtils.equals(q.x, this.max.x, epsilon) ? LineLocation.END : (q.x < this.min.x ? LineLocation.BEFORE : (x = q.x < this.max.x ? LineLocation.BETWEEN : LineLocation.AFTER)));
        LineLocation y = MathUtils.equals(q.y, this.min.y, epsilon) ? LineLocation.START : (MathUtils.equals(q.y, this.max.y, epsilon) ? LineLocation.END : (q.y < this.min.y ? LineLocation.BEFORE : (q.y < this.max.y ? LineLocation.BETWEEN : LineLocation.AFTER)));
        return new RectLocation(x, y);
    }

    public RectD offset(double x, double y) {
        return new RectD(this.min.x + x, this.min.y + y, this.max.x + x, this.max.y + y);
    }

    public RectD offset(PointD vector) {
        return new RectD(this.min.add(vector), this.max.add(vector));
    }

    public RectI round() {
        return new RectI(this.min.round(), this.max.round());
    }

    public static double[] toDoubles(RectD ... rects) {
        double[] output = new double[4 * rects.length];
        for (int i = 0; i < rects.length; ++i) {
            output[4 * i] = rects[i].min.x;
            output[4 * i + 1] = rects[i].min.y;
            output[4 * i + 2] = rects[i].max.x;
            output[4 * i + 3] = rects[i].max.y;
        }
        return output;
    }

    public RectI toRectI() {
        return new RectI(this.min.toPointI(), this.max.toPointI());
    }

    public RectD union(RectD rect) {
        double minX = Math.min(this.min.x, rect.min.x);
        double minY = Math.min(this.min.y, rect.min.y);
        double maxX = Math.max(this.max.x, rect.max.x);
        double maxY = Math.max(this.max.y, rect.max.y);
        return new RectD(minX, minY, maxX, maxY);
    }

    public double width() {
        return this.max.x - this.min.x;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RectD)) {
            return false;
        }
        RectD rect = (RectD)obj;
        return this.min.equals(rect.min) && this.max.equals(rect.max);
    }

    public int hashCode() {
        return 31 * this.min.hashCode() + this.max.hashCode();
    }

    public String toString() {
        return String.format("RectD[min.x=%g, min.y=%g, max.x=%g, max.y=%g]", this.min.x, this.min.y, this.max.x, this.max.y);
    }
}

