/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.RectD;
import org.kynosarges.tektosyne.geometry.RectLocation;

public final class RectI {
    public final PointI min;
    public final PointI max;
    public static final RectI EMPTY = new RectI();

    public RectI() {
        this.min = PointI.EMPTY;
        this.max = PointI.EMPTY;
    }

    public RectI(int minX, int minY, int maxX, int maxY) {
        if (maxX < minX) {
            throw new IllegalArgumentException("maxX < minX");
        }
        if (maxY < minY) {
            throw new IllegalArgumentException("maxY < minY");
        }
        this.min = new PointI(minX, minY);
        this.max = new PointI(maxX, maxY);
    }

    public RectI(PointI min, PointI max) {
        if (max.x < min.x) {
            throw new IllegalArgumentException("max.x < min.x");
        }
        if (max.y < min.y) {
            throw new IllegalArgumentException("max.y < min.y");
        }
        this.min = min;
        this.max = max;
    }

    public static RectI circumscribe(PointI ... points) {
        if (points == null || points.length == 0) {
            throw new NullPointerException("points");
        }
        int x0 = Integer.MAX_VALUE;
        int y0 = Integer.MAX_VALUE;
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        for (PointI point : points) {
            if (x0 > point.x) {
                x0 = point.x;
            }
            if (y0 > point.y) {
                y0 = point.y;
            }
            if (x1 < point.x) {
                x1 = point.x;
            }
            if (y1 >= point.y) continue;
            y1 = point.y;
        }
        return new RectI(x0, y0, x1, y1);
    }

    public boolean contains(int x, int y) {
        return x >= this.min.x && y >= this.min.y && x <= this.max.x && y <= this.max.y;
    }

    public boolean contains(PointI point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(RectI rect) {
        return rect.min.x >= this.min.x && rect.min.y >= this.min.y && rect.max.x <= this.max.x && rect.max.y <= this.max.y;
    }

    public boolean containsOpen(int x, int y) {
        return x >= this.min.x && y >= this.min.y && x < this.max.x && y < this.max.y;
    }

    public boolean containsOpen(PointI point) {
        return this.containsOpen(point.x, point.y);
    }

    public PointI distanceVector(PointI q) {
        int x;
        int n = q.x < this.min.x ? Math.subtractExact(q.x, this.min.x) : (x = q.x > this.max.x ? Math.subtractExact(q.x, this.max.x) : 0);
        int y = q.y < this.min.y ? Math.subtractExact(q.y, this.min.y) : (q.y > this.max.y ? Math.subtractExact(q.y, this.max.y) : 0);
        return new PointI(x, y);
    }

    public static RectI[] fromInts(int ... rects) {
        if (rects.length % 4 != 0) {
            throw new IllegalArgumentException("rects.length % 4 != 0");
        }
        RectI[] output = new RectI[rects.length / 4];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new RectI(rects[4 * i], rects[4 * i + 1], rects[4 * i + 2], rects[4 * i + 3]);
        }
        return output;
    }

    public long height() {
        return (long)this.max.y - (long)this.min.y;
    }

    public RectI intersect(RectI rect) {
        int minX = Math.max(this.min.x, rect.min.x);
        int minY = Math.max(this.min.y, rect.min.y);
        int maxX = Math.min(this.max.x, rect.max.x);
        int maxY = Math.min(this.max.y, rect.max.y);
        if (minX > maxX || minY > maxY) {
            return null;
        }
        return new RectI(minX, minY, maxX, maxY);
    }

    public boolean intersectsWith(RectI rect) {
        return rect.max.x >= this.min.x && rect.min.x <= this.max.x && rect.max.y >= this.min.y && rect.min.y <= this.max.y;
    }

    public RectLocation locate(PointI q) {
        LineLocation x;
        LineLocation lineLocation = q.x < this.min.x ? LineLocation.BEFORE : (q.x == this.min.x ? LineLocation.START : (q.x < this.max.x ? LineLocation.BETWEEN : (x = q.x == this.max.x ? LineLocation.END : LineLocation.AFTER)));
        LineLocation y = q.y < this.min.y ? LineLocation.BEFORE : (q.y == this.min.y ? LineLocation.START : (q.y < this.max.y ? LineLocation.BETWEEN : (q.y == this.max.y ? LineLocation.END : LineLocation.AFTER)));
        return new RectLocation(x, y);
    }

    public RectI offset(int x, int y) {
        return new RectI(Math.addExact(this.min.x, x), Math.addExact(this.min.y, y), Math.addExact(this.max.x, x), Math.addExact(this.max.y, y));
    }

    public RectI offset(PointI vector) {
        return new RectI(this.min.add(vector), this.max.add(vector));
    }

    public static int[] toInts(RectI ... rects) {
        int[] output = new int[4 * rects.length];
        for (int i = 0; i < rects.length; ++i) {
            output[4 * i] = rects[i].min.x;
            output[4 * i + 1] = rects[i].min.y;
            output[4 * i + 2] = rects[i].max.x;
            output[4 * i + 3] = rects[i].max.y;
        }
        return output;
    }

    public RectD toRectD() {
        return new RectD(this.min.toPointD(), this.max.toPointD());
    }

    public RectI union(RectI rect) {
        int minX = Math.min(this.min.x, rect.min.x);
        int minY = Math.min(this.min.y, rect.min.y);
        int maxX = Math.max(this.max.x, rect.max.x);
        int maxY = Math.max(this.max.y, rect.max.y);
        return new RectI(minX, minY, maxX, maxY);
    }

    public long width() {
        return (long)this.max.x - (long)this.min.x;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RectI)) {
            return false;
        }
        RectI rect = (RectI)obj;
        return this.min.equals(rect.min) && this.max.equals(rect.max);
    }

    public int hashCode() {
        return 31 * this.min.hashCode() + this.max.hashCode();
    }

    public String toString() {
        return String.format("RectI[min.x=%d, min.y=%d, max.x=%d, max.y=%d]", this.min.x, this.min.y, this.max.x, this.max.y);
    }
}

