/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.LineLocation;

public final class RectLocation {
    public final LineLocation edgeX;
    public final LineLocation edgeY;

    public RectLocation(LineLocation edgeX, LineLocation edgeY) {
        if (edgeX == null) {
            throw new NullPointerException("edgeX");
        }
        if (edgeY == null) {
            throw new NullPointerException("edgeY");
        }
        if (edgeX == LineLocation.LEFT || edgeX == LineLocation.RIGHT) {
            throw new IllegalArgumentException("edgeX == LEFT/RIGHT");
        }
        if (edgeY == LineLocation.LEFT || edgeY == LineLocation.RIGHT) {
            throw new IllegalArgumentException("edgeY == LEFT/RIGHT");
        }
        this.edgeX = edgeX;
        this.edgeY = edgeY;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RectLocation)) {
            return false;
        }
        RectLocation other = (RectLocation)obj;
        return this.edgeX == other.edgeX && this.edgeY == other.edgeY;
    }

    public int hashCode() {
        return 31 * this.edgeX.hashCode() + this.edgeY.hashCode();
    }

    public String toString() {
        return String.format("RectLocation[edgeX=%s, edgeY=%s]", new Object[]{this.edgeX, this.edgeY});
    }
}

