/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.geometry.Angle;
import org.kynosarges.tektosyne.geometry.Compass;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PolygonOrientation;
import org.kynosarges.tektosyne.geometry.RectD;

public class RegularPolygon {
    public final RectD bounds;
    public final int connectivity;
    public final boolean hasTopIndex;
    public final double innerRadius;
    public final double length;
    public final PolygonOrientation orientation;
    public final double outerRadius;
    public final int sides;
    public final boolean vertexNeighbors;
    public final PointD[] vertices;

    public RegularPolygon(double length, int sides, PolygonOrientation orientation) {
        this(length, sides, orientation, false);
    }

    public RegularPolygon(double length, int sides, PolygonOrientation orientation, boolean vertexNeighbors) {
        double angle;
        if (length <= 0.0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (sides < 3) {
            throw new IllegalArgumentException("sides < 3");
        }
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        if (vertexNeighbors && sides > 4) {
            throw new IllegalArgumentException("vertexNeighbors && sides > 4");
        }
        this.length = length;
        this.sides = sides;
        this.orientation = orientation;
        this.vertexNeighbors = vertexNeighbors;
        int n = this.connectivity = vertexNeighbors ? 2 * sides : sides;
        this.hasTopIndex = vertexNeighbors || (sides % 2 == 0 ? orientation == PolygonOrientation.ON_EDGE : orientation == PolygonOrientation.ON_VERTEX);
        double segment = Math.PI * 2 / (double)sides;
        this.outerRadius = length / (2.0 * Math.sin(segment / 2.0));
        this.innerRadius = this.outerRadius * Math.cos(segment / 2.0);
        switch (orientation) {
            case ON_EDGE: {
                angle = sides % 2 == 0 ? segment : 0.0;
                break;
            }
            case ON_VERTEX: {
                angle = sides % 2 == 0 ? 0.0 : segment;
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation");
            }
        }
        angle = (angle - Math.PI) / 2.0;
        this.vertices = new PointD[sides];
        int i = 0;
        while (i < sides) {
            this.vertices[i] = new PointD(this.outerRadius * Math.cos(angle), this.outerRadius * Math.sin(angle));
            ++i;
            angle += segment;
        }
        this.bounds = RectD.circumscribe(this.vertices);
    }

    public int angleToIndex(double angle) {
        double segment = 360.0 / (double)this.connectivity;
        if (this.hasTopIndex) {
            angle += segment / 2.0;
        }
        angle = Fortran.modulo(angle + 90.0, 360.0);
        return (int)(angle / segment);
    }

    public RegularPolygon circumscribe(double radius) {
        if (radius == this.innerRadius) {
            return this;
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius <= 0");
        }
        double newLength = 2.0 * radius * Math.tan(Math.PI / (double)this.sides);
        return new RegularPolygon(newLength, this.sides, this.orientation, this.vertexNeighbors);
    }

    public RegularPolygon circumscribe(double width, double height) {
        double newLength;
        if (width <= 0.0) {
            throw new IllegalArgumentException("width <= 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height <= 0");
        }
        if (this.sides == 3) {
            double angle = 1.0471975511965976;
            double triangleHeight = height + width * Math.tan(1.0471975511965976) / 2.0;
            double heightLength = triangleHeight / Math.sin(1.0471975511965976);
            newLength = Math.max(width, heightLength);
        } else if (this.sides == 4) {
            newLength = this.orientation == PolygonOrientation.ON_EDGE ? Math.max(width, height) : (width + height) / Math.sqrt(2.0);
        } else {
            double diameter = Math.sqrt(width * width + height * height);
            newLength = diameter * Math.tan(Math.PI / (double)this.sides);
        }
        return new RegularPolygon(newLength, this.sides, this.orientation, this.vertexNeighbors);
    }

    public int compassToIndex(Compass compass) {
        return this.angleToIndex(compass.degrees() - 90);
    }

    public double indexToAngle(int index) {
        double segment = 360.0 / (double)this.connectivity;
        double angle = (double)Fortran.modulo(index, this.connectivity) * segment;
        if (!this.hasTopIndex) {
            angle += segment / 2.0;
        }
        return Fortran.modulo(angle - 90.0, 360.0);
    }

    public Compass indexToCompass(int index) {
        double degrees = this.indexToAngle(index) + 90.0;
        return Angle.degreesToCompass(degrees);
    }

    public RegularPolygon inflate(double delta) {
        if (delta == 0.0) {
            return this;
        }
        if (delta <= -this.outerRadius) {
            throw new IllegalArgumentException("delta <= -outerRadius");
        }
        double newLength = this.length * (this.outerRadius + delta) / this.outerRadius;
        return new RegularPolygon(newLength, this.sides, this.orientation, this.vertexNeighbors);
    }

    public RegularPolygon inscribe(double radius) {
        if (radius == this.outerRadius) {
            return this;
        }
        if (radius <= 0.0) {
            throw new IllegalArgumentException("radius <= 0");
        }
        double newLength = 2.0 * radius * Math.sin(Math.PI / (double)this.sides);
        return new RegularPolygon(newLength, this.sides, this.orientation, this.vertexNeighbors);
    }

    public RegularPolygon inscribe(double width, double height) {
        double newLength;
        if (width == this.bounds.width() && height == this.bounds.height()) {
            return this;
        }
        if (width <= 0.0) {
            throw new IllegalArgumentException("width <= 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height <= 0");
        }
        double halfSegment = Math.PI / (double)this.sides;
        if (this.sides % 4 == 0) {
            double diameter = Math.min(width, height);
            newLength = this.orientation == PolygonOrientation.ON_EDGE ? diameter * Math.tan(halfSegment) : diameter * Math.sin(halfSegment);
        } else if (this.sides % 2 == 0) {
            double outerDiameter;
            double innerDiameter;
            if (this.orientation == PolygonOrientation.ON_EDGE) {
                innerDiameter = height;
                outerDiameter = width;
            } else {
                innerDiameter = width;
                outerDiameter = height;
            }
            double outerLength = outerDiameter * Math.sin(halfSegment);
            double innerLength = innerDiameter * Math.tan(halfSegment);
            newLength = Math.min(innerLength, outerLength);
        } else {
            double topAngle;
            double segment = 2.0 * halfSegment;
            int rightIndex = this.sides / 4;
            if (this.orientation == PolygonOrientation.ON_EDGE) {
                topAngle = 0.0;
                if ((this.sides - 1) % 4 != 0) {
                    ++rightIndex;
                }
            } else {
                topAngle = segment;
            }
            topAngle = (topAngle - Math.PI) / 2.0;
            double radiusFactor = Math.sin(halfSegment);
            double rightAngle = topAngle + (double)rightIndex * segment;
            double widthLength = width * radiusFactor / Math.cos(rightAngle);
            int halfSide = this.sides / 2;
            double bottomAngle = topAngle + (double)halfSide * segment;
            double heightLength = 2.0 * height * radiusFactor / (Math.sin(bottomAngle) - Math.sin(topAngle));
            newLength = Math.min(widthLength, heightLength);
        }
        return new RegularPolygon(newLength, this.sides, this.orientation, this.vertexNeighbors);
    }

    public int opposingIndex(int index) {
        if (this.connectivity % 2 != 0) {
            throw new IllegalStateException("connectivity % 2 != 0");
        }
        return Fortran.modulo(index + this.connectivity / 2, this.connectivity);
    }

    public RegularPolygon resize(double length) {
        if (length == length) {
            return this;
        }
        if (length <= 0.0) {
            throw new IllegalArgumentException("length <= 0");
        }
        return new RegularPolygon(length, this.sides, this.orientation, this.vertexNeighbors);
    }
}

