/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.Fortran;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.SizeI;

public final class SizeD {
    public final double width;
    public final double height;
    public static final SizeD EMPTY = new SizeD();

    public SizeD() {
        this.width = 0.0;
        this.height = 0.0;
    }

    public SizeD(double width, double height) {
        if (width < 0.0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (height < 0.0) {
            throw new IllegalArgumentException("height < 0");
        }
        this.width = width;
        this.height = height;
    }

    public SizeD add(SizeD size) {
        return new SizeD(this.width + size.width, this.height + size.height);
    }

    public static boolean equals(SizeD a, SizeD b, double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        return Math.abs(a.width - b.width) <= epsilon && Math.abs(a.height - b.height) <= epsilon;
    }

    public static SizeD[] fromDoubles(double ... sizes) {
        if (sizes.length % 2 != 0) {
            throw new IllegalArgumentException("sizes.length % 2 != 0");
        }
        SizeD[] output = new SizeD[sizes.length / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new SizeD(sizes[2 * i], sizes[2 * i + 1]);
        }
        return output;
    }

    public boolean isEmpty() {
        return this.width == 0.0 && this.height == 0.0;
    }

    public SizeD restrict(double minWidth, double minHeight, double maxWidth, double maxHeight) {
        double width = this.width;
        double height = this.height;
        if (width < minWidth) {
            width = minWidth;
        } else if (width > maxWidth) {
            width = maxWidth;
        }
        if (height < minHeight) {
            height = minHeight;
        } else if (height > maxHeight) {
            height = maxHeight;
        }
        return new SizeD(width, height);
    }

    public SizeI round() {
        return new SizeI(Fortran.nint(this.width), Fortran.nint(this.height));
    }

    public SizeD subtract(SizeD size) {
        return new SizeD(this.width - size.width, this.height - size.height);
    }

    public static double[] toDoubles(SizeD ... sizes) {
        double[] output = new double[2 * sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            output[2 * i] = sizes[i].width;
            output[2 * i + 1] = sizes[i].height;
        }
        return output;
    }

    public SizeI toSizeI() {
        return new SizeI(MathUtils.toIntExact(this.width), MathUtils.toIntExact(this.height));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SizeD)) {
            return false;
        }
        SizeD size = (SizeD)obj;
        return this.width == size.width && this.height == size.height;
    }

    public int hashCode() {
        long widthHash = Double.doubleToLongBits(this.width);
        long heightHash = Double.doubleToLongBits(this.height);
        return 31 * (int)(widthHash ^ widthHash >>> 32) + (int)(heightHash ^ heightHash >>> 32);
    }

    public String toString() {
        return String.format("SizeD[width=%g, height=%g]", this.width, this.height);
    }
}

