/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import org.kynosarges.tektosyne.geometry.SizeD;

public final class SizeI {
    public final int width;
    public final int height;
    public static final SizeI EMPTY = new SizeI();

    public SizeI() {
        this.width = 0;
        this.height = 0;
    }

    public SizeI(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width < 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height < 0");
        }
        this.width = width;
        this.height = height;
    }

    public SizeI add(SizeI size) {
        return new SizeI(Math.addExact(this.width, size.width), Math.addExact(this.height, size.height));
    }

    public static SizeI[] fromInts(int ... sizes) {
        if (sizes.length % 2 != 0) {
            throw new IllegalArgumentException("sizes.length % 2 != 0");
        }
        SizeI[] output = new SizeI[sizes.length / 2];
        for (int i = 0; i < output.length; ++i) {
            output[i] = new SizeI(sizes[2 * i], sizes[2 * i + 1]);
        }
        return output;
    }

    public boolean isEmpty() {
        return this.width == 0 && this.height == 0;
    }

    public SizeI restrict(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        int width = this.width;
        int height = this.height;
        if (width < minWidth) {
            width = minWidth;
        } else if (width > maxWidth) {
            width = maxWidth;
        }
        if (height < minHeight) {
            height = minHeight;
        } else if (height > maxHeight) {
            height = maxHeight;
        }
        return new SizeI(width, height);
    }

    public SizeI subtract(SizeI size) {
        return new SizeI(this.width - size.width, this.height - size.height);
    }

    public static int[] toInts(SizeI ... sizes) {
        int[] output = new int[2 * sizes.length];
        for (int i = 0; i < sizes.length; ++i) {
            output[2 * i] = sizes[i].width;
            output[2 * i + 1] = sizes[i].height;
        }
        return output;
    }

    public SizeD toSizeD() {
        return new SizeD(this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SizeI)) {
            return false;
        }
        SizeI size = (SizeI)obj;
        return this.width == size.width && this.height == size.height;
    }

    public int hashCode() {
        return 31 * this.width + this.height;
    }

    public String toString() {
        return String.format("SizeI[width=%d, height=%d]", this.width, this.height);
    }
}

