/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.RectD;
import org.kynosarges.tektosyne.geometry.VoronoiEdge;
import org.kynosarges.tektosyne.geometry.VoronoiResults;
import org.kynosarges.tektosyne.subdivision.Subdivision;

public final class Voronoi {
    private static final FullEdge DELETED_EDGE = new FullEdge();
    private double _minX;
    private double _maxX;
    private double _minY;
    private double _maxY;
    private double _minClipX;
    private double _maxClipX;
    private double _minClipY;
    private double _maxClipY;
    private SiteVertex[] _sites;
    private int _vertexCount;
    private int[] _vertexIndices;
    private List<PointI> _delaunayEdges;
    private List<VoronoiEdge> _voronoiEdges;
    private List<PointD> _voronoiVertices;
    private HalfEdge[] _edgeList;
    private HalfEdge _edgeListLeft;
    private HalfEdge _edgeListRight;
    private HalfEdge[] _priQueue;
    private int _priQueueCount;
    private int _priQueueMin;

    public static VoronoiResults findAll(PointD[] points) {
        return Voronoi.findAll(points, RectD.EMPTY);
    }

    public static VoronoiResults findAll(PointD[] points, RectD clip) {
        RectD[] clipRef = new RectD[]{clip};
        Voronoi voronoi = new Voronoi(points, clipRef, false);
        voronoi.sweepLine();
        List<PointD> vertices = voronoi._voronoiVertices;
        List<VoronoiEdge> edges = voronoi._voronoiEdges;
        return new VoronoiResults(clipRef[0], points, vertices.toArray(new PointD[vertices.size()]), edges.toArray(new VoronoiEdge[edges.size()]));
    }

    public static PointI[] findDelaunay(PointD[] points) {
        RectD[] clipRef = new RectD[]{RectD.EMPTY};
        Voronoi voronoi = new Voronoi(points, clipRef, true);
        voronoi.sweepLine();
        List<PointI> edges = voronoi._delaunayEdges;
        return edges.toArray(new PointI[edges.size()]);
    }

    public static Subdivision findDelaunaySubdivision(PointD[] points) {
        PointI[] indices = Voronoi.findDelaunay(points);
        LineD[] lines = LineD.fromIndexPoints(points, indices);
        return Subdivision.fromLines(lines, 0.0);
    }

    private Voronoi(PointD[] points, RectD[] clip, boolean findDelaunay) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        if (points.length < 2) {
            throw new IllegalArgumentException("points.length < 2");
        }
        if (clip == null) {
            throw new NullPointerException("clip");
        }
        if (clip.length != 1) {
            throw new IllegalArgumentException("clip.length != 1");
        }
        this._sites = new SiteVertex[points.length];
        for (int i = 0; i < this._sites.length; ++i) {
            this._sites[i] = new SiteVertex(points[i], i);
        }
        Comparator comparator = (s, t) -> {
            if (s == t) {
                return 0;
            }
            if (s.y < t.y) {
                return -1;
            }
            if (s.y > t.y) {
                return 1;
            }
            if (s.x < t.x) {
                return -1;
            }
            if (s.x > t.x) {
                return 1;
            }
            return 0;
        };
        Arrays.sort(this._sites, comparator);
        this._minX = this._maxX = this._sites[0].x;
        for (int i = 1; i < this._sites.length; ++i) {
            double x = this._sites[i].x;
            if (x < this._minX) {
                this._minX = x;
            }
            if (!(x > this._maxX)) continue;
            this._maxX = x;
        }
        this._minY = this._sites[0].y;
        this._maxY = this._sites[this._sites.length - 1].y;
        int maxVertexCount = Math.max(0, 2 * this._sites.length - 5);
        int maxEdgeCount = Math.max(1, 3 * this._sites.length - 6);
        if (findDelaunay) {
            this._delaunayEdges = new ArrayList<PointI>(maxEdgeCount);
            return;
        }
        double dx = this._maxX - this._minX;
        double dy = this._maxY - this._minY;
        double d = Math.max(dx, dy) * 1.1;
        this._minClipX = this._minX - (d - dx) / 2.0;
        this._maxClipX = this._maxX + (d - dx) / 2.0;
        this._minClipY = this._minY - (d - dy) / 2.0;
        this._maxClipY = this._maxY + (d - dy) / 2.0;
        if (clip[0].width() > 0.0 && clip[0].height() > 0.0) {
            this._minClipX = Math.min(this._minClipX, clip[0].min.x);
            this._maxClipX = Math.max(this._maxClipX, clip[0].max.x);
            this._minClipY = Math.min(this._minClipY, clip[0].min.y);
            this._maxClipY = Math.max(this._maxClipY, clip[0].max.y);
        }
        clip[0] = new RectD(new PointD(this._minClipX, this._minClipY), new PointD(this._maxClipX, this._maxClipY));
        this._voronoiVertices = new ArrayList<PointD>(maxVertexCount + 5);
        this._voronoiEdges = new ArrayList<VoronoiEdge>(maxEdgeCount);
        this._vertexIndices = new int[maxVertexCount];
    }

    private void sweepLine() {
        PointD minSite = PointD.EMPTY;
        this.priQueueInit();
        this.edgeListInit();
        int newSiteIndex = 1;
        SiteVertex newSite = this._sites[newSiteIndex];
        while (true) {
            SiteVertex p;
            HalfEdge bisectHE;
            FullEdge bisector;
            SiteVertex lowSite;
            HalfEdge rightHE;
            HalfEdge leftHE;
            if (this._priQueueCount != 0) {
                minSite = this.priQueuePeek();
            }
            if (newSite != null && (this._priQueueCount == 0 || newSite.y < minSite.y || newSite.y == minSite.y && newSite.x < minSite.x)) {
                leftHE = this.edgeListLeftBound(newSite);
                rightHE = leftHE.right;
                lowSite = this.getRightSite(leftHE);
                bisector = this.bisectSites(lowSite, newSite);
                bisectHE = new HalfEdge(bisector, false);
                Voronoi.edgeListInsert(leftHE, bisectHE);
                p = Voronoi.intersect(leftHE, bisectHE);
                if (p != null) {
                    this.priQueueDelete(leftHE);
                    this.priQueueInsert(leftHE, p, Voronoi.getDistance(p, newSite));
                }
                leftHE = bisectHE;
                bisectHE = new HalfEdge(bisector, true);
                Voronoi.edgeListInsert(leftHE, bisectHE);
                p = Voronoi.intersect(bisectHE, rightHE);
                if (p != null) {
                    this.priQueueInsert(bisectHE, p, Voronoi.getDistance(p, newSite));
                }
                newSite = null;
                if (++newSiteIndex >= this._sites.length) continue;
                newSite = this._sites[newSiteIndex];
                continue;
            }
            if (this._priQueueCount == 0) break;
            leftHE = this.priQueuePop();
            rightHE = leftHE.right;
            HalfEdge prevHE = leftHE.left;
            HalfEdge nextHE = rightHE.right;
            lowSite = this.getLeftSite(leftHE);
            SiteVertex highSite = this.getRightSite(rightHE);
            SiteVertex v = leftHE.vertex;
            ++this._vertexCount;
            v.index = v.index;
            if (this._voronoiEdges != null && v.x >= this._minClipX && v.x <= this._maxClipX && v.y >= this._minClipY && v.y <= this._maxClipY) {
                this._vertexIndices[v.index] = this._voronoiVertices.size();
                this._voronoiVertices.add(new PointD(v.x, v.y));
            }
            this.addVertex(leftHE.edge, leftHE.isRight, v);
            this.addVertex(rightHE.edge, rightHE.isRight, v);
            Voronoi.edgeListDelete(leftHE);
            this.priQueueDelete(rightHE);
            Voronoi.edgeListDelete(rightHE);
            boolean isRight = false;
            if (lowSite.y > highSite.y) {
                SiteVertex tmpSite = lowSite;
                lowSite = highSite;
                highSite = tmpSite;
                isRight = true;
            }
            bisector = this.bisectSites(lowSite, highSite);
            bisectHE = new HalfEdge(bisector, isRight);
            Voronoi.edgeListInsert(prevHE, bisectHE);
            this.addVertex(bisector, !isRight, v);
            p = Voronoi.intersect(prevHE, bisectHE);
            if (p != null) {
                this.priQueueDelete(prevHE);
                this.priQueueInsert(prevHE, p, Voronoi.getDistance(p, lowSite));
            }
            if ((p = Voronoi.intersect(bisectHE, nextHE)) == null) continue;
            this.priQueueInsert(bisectHE, p, Voronoi.getDistance(p, lowSite));
        }
        if (this._voronoiEdges != null) {
            HashSet<FullEdge> fullEdges = new HashSet<FullEdge>();
            HalfEdge he = this._edgeListLeft.right;
            while (he != this._edgeListRight) {
                if (!fullEdges.contains(he.edge)) {
                    this.storeVoronoiEdge(he.edge);
                    fullEdges.add(he.edge);
                }
                he = he.right;
            }
        }
    }

    private void addVertex(FullEdge e, boolean isRight, SiteVertex s) {
        e.setVertex(isRight, s);
        if (this._voronoiEdges != null && e.getVertex(!isRight) != null) {
            this.storeVoronoiEdge(e);
        }
    }

    private FullEdge bisectSites(SiteVertex s, SiteVertex t) {
        FullEdge e = new FullEdge();
        e.leftSite = s;
        e.rightSite = t;
        double dx = t.x - s.x;
        double dy = t.y - s.y;
        double adx = dx > 0.0 ? dx : -dx;
        double ady = dy > 0.0 ? dy : -dy;
        e.c = s.x * dx + s.y * dy + (dx * dx + dy * dy) / 2.0;
        if (adx > ady) {
            e.a = 1.0;
            e.b = dy / dx;
            e.c /= dx;
        } else {
            e.a = dx / dy;
            e.b = 1.0;
            e.c /= dy;
        }
        if (this._delaunayEdges != null) {
            this._delaunayEdges.add(new PointI(s.index, t.index));
        }
        return e;
    }

    private static double getDistance(SiteVertex s, SiteVertex t) {
        double dx = s.x - t.x;
        double dy = s.y - t.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    private SiteVertex getLeftSite(HalfEdge he) {
        if (he.edge == null) {
            return this._sites[0];
        }
        if (he.isRight) {
            return he.edge.rightSite;
        }
        return he.edge.leftSite;
    }

    private SiteVertex getRightSite(HalfEdge he) {
        if (he.edge == null) {
            return this._sites[0];
        }
        if (he.isRight) {
            return he.edge.leftSite;
        }
        return he.edge.rightSite;
    }

    private static SiteVertex intersect(HalfEdge he1, HalfEdge he2) {
        boolean isRightOfSite;
        FullEdge e;
        HalfEdge el;
        FullEdge e1 = he1.edge;
        FullEdge e2 = he2.edge;
        if (e1 == null || e2 == null) {
            return null;
        }
        if (e1.rightSite == e2.rightSite) {
            return null;
        }
        double d = e1.a * e2.b - e1.b * e2.a;
        if (Math.abs(d) < 1.0E-10) {
            return null;
        }
        double xint = (e1.c * e2.b - e2.c * e1.b) / d;
        double yint = (e2.c * e1.a - e1.c * e2.a) / d;
        if (e1.rightSite.y < e2.rightSite.y || e1.rightSite.y == e2.rightSite.y && e1.rightSite.x < e2.rightSite.x) {
            el = he1;
            e = e1;
        } else {
            el = he2;
            e = e2;
        }
        boolean bl = isRightOfSite = xint >= e.rightSite.x;
        if (isRightOfSite && !el.isRight || !isRightOfSite && el.isRight) {
            return null;
        }
        return new SiteVertex(xint, yint);
    }

    private static boolean isRightOf(HalfEdge he, SiteVertex p) {
        boolean isAbove;
        boolean isRightOfSite;
        FullEdge e = he.edge;
        boolean bl = isRightOfSite = p.x > e.rightSite.x;
        if (isRightOfSite && !he.isRight) {
            return true;
        }
        if (!isRightOfSite && he.isRight) {
            return false;
        }
        if (e.a == 1.0) {
            double dyp = p.y - e.rightSite.y;
            double dxp = p.x - e.rightSite.x;
            boolean isFast = false;
            if (!isRightOfSite && e.b < 0.0 || isRightOfSite && e.b >= 0.0) {
                isFast = isAbove = dyp >= e.b * dxp;
            } else {
                boolean bl2 = isAbove = p.x + p.y * e.b > e.c;
                if (e.b < 0.0) {
                    boolean bl3 = isAbove = !isAbove;
                }
                if (!isAbove) {
                    isFast = true;
                }
            }
            if (!isFast) {
                double dxs = e.rightSite.x - e.leftSite.x;
                boolean bl4 = isAbove = e.b * (dxp * dxp - dyp * dyp) < dxs * dyp * (1.0 + 2.0 * dxp / dxs + e.b * e.b);
                if (e.b < 0.0) {
                    isAbove = !isAbove;
                }
            }
        } else {
            double yl = e.c - e.a * p.x;
            double t1 = p.y - yl;
            double t2 = p.x - e.rightSite.x;
            double t3 = yl - e.rightSite.y;
            isAbove = t1 * t1 > t2 * t2 + t3 * t3;
        }
        return he.isRight != isAbove;
    }

    private void storeVoronoiEdge(FullEdge e) {
        int vertex2;
        int vertex1;
        double x2;
        double x1;
        double y2;
        double y1;
        SiteVertex s2;
        SiteVertex s1;
        assert (this._voronoiEdges != null);
        if (e.a == 1.0 && e.b >= 0.0) {
            s1 = e.rightVertex;
            s2 = e.leftVertex;
        } else {
            s1 = e.leftVertex;
            s2 = e.rightVertex;
        }
        assert (e.a == 1.0 || e.b == 1.0);
        if (e.a == 1.0) {
            if (s1 != null && s1.y > this._minClipY) {
                y1 = s1.y;
                if (y1 > this._maxClipY) {
                    return;
                }
            } else {
                y1 = this._minClipY;
            }
            if (s2 != null && s2.y < this._maxClipY) {
                y2 = s2.y;
                if (y2 < this._minClipY) {
                    return;
                }
            } else {
                y2 = this._maxClipY;
            }
            x1 = e.c - e.b * y1;
            x2 = e.c - e.b * y2;
            if (x1 > this._maxClipX) {
                if (x2 > this._maxClipX) {
                    return;
                }
                x1 = this._maxClipX;
                y1 = (e.c - x1) / e.b;
            } else if (x1 < this._minClipX) {
                if (x2 < this._minClipX) {
                    return;
                }
                x1 = this._minClipX;
                y1 = (e.c - x1) / e.b;
            }
            if (x2 > this._maxClipX) {
                x2 = this._maxClipX;
                y2 = (e.c - x2) / e.b;
            } else if (x2 < this._minClipX) {
                x2 = this._minClipX;
                y2 = (e.c - x2) / e.b;
            }
        } else {
            if (s1 != null && s1.x > this._minClipX) {
                x1 = s1.x;
                if (x1 > this._maxClipX) {
                    return;
                }
            } else {
                x1 = this._minClipX;
            }
            if (s2 != null && s2.x < this._maxClipX) {
                x2 = s2.x;
                if (x2 < this._minClipX) {
                    return;
                }
            } else {
                x2 = this._maxClipX;
            }
            y1 = e.c - e.a * x1;
            y2 = e.c - e.a * x2;
            if (y1 > this._maxClipY) {
                if (y2 > this._maxClipY) {
                    return;
                }
                y1 = this._maxClipY;
                x1 = (e.c - y1) / e.a;
            } else if (y1 < this._minClipY) {
                if (y2 < this._minClipY) {
                    return;
                }
                y1 = this._minClipY;
                x1 = (e.c - y1) / e.a;
            }
            if (y2 > this._maxClipY) {
                y2 = this._maxClipY;
                x2 = (e.c - y2) / e.a;
            } else if (y2 < this._minClipY) {
                y2 = this._minClipY;
                x2 = (e.c - y2) / e.a;
            }
        }
        if (s1 != null && s1.x >= this._minClipX && s1.x <= this._maxClipX && s1.y >= this._minClipY && s1.y <= this._maxClipY) {
            vertex1 = this._vertexIndices[s1.index];
        } else {
            vertex1 = this._voronoiVertices.size();
            this._voronoiVertices.add(new PointD(x1, y1));
        }
        if (s2 != null && s2.x >= this._minClipX && s2.x <= this._maxClipX && s2.y >= this._minClipY && s2.y <= this._maxClipY) {
            vertex2 = this._vertexIndices[s2.index];
        } else {
            vertex2 = this._voronoiVertices.size();
            this._voronoiVertices.add(new PointD(x2, y2));
        }
        VoronoiEdge ve = new VoronoiEdge(e.leftSite.index, e.rightSite.index, vertex1, vertex2);
        this._voronoiEdges.add(ve);
    }

    private void edgeListInit() {
        int n = (int)(2.0 * Math.sqrt(this._sites.length + 4));
        this._edgeList = new HalfEdge[n];
        this._edgeListLeft = new HalfEdge();
        this._edgeListLeft.right = this._edgeListRight = new HalfEdge();
        this._edgeListRight.left = this._edgeListLeft;
        this._edgeList[0] = this._edgeListLeft;
        this._edgeList[n - 1] = this._edgeListRight;
    }

    private static void edgeListDelete(HalfEdge he) {
        he.left.right = he.right;
        he.right.left = he.left;
        he.edge = DELETED_EDGE;
    }

    private HalfEdge edgeListHash(int bucket) {
        if (bucket < 0 || bucket >= this._edgeList.length) {
            return null;
        }
        HalfEdge he = this._edgeList[bucket];
        if (he == null || he.edge != DELETED_EDGE) {
            return he;
        }
        this._edgeList[bucket] = null;
        return null;
    }

    private static void edgeListInsert(HalfEdge hePos, HalfEdge heNew) {
        heNew.left = hePos;
        heNew.right = hePos.right;
        hePos.right.left = heNew;
        hePos.right = heNew;
    }

    private HalfEdge edgeListLeftBound(SiteVertex s) {
        HalfEdge he;
        int n = this._edgeList.length;
        int bucket = (int)((s.x - this._minX) / (this._maxX - this._minX) * (double)n);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= n) {
            bucket = n - 1;
        }
        if ((he = this.edgeListHash(bucket)) == null) {
            int i = 1;
            while ((he = this.edgeListHash(bucket - i)) == null && (he = this.edgeListHash(bucket + i)) == null) {
                ++i;
            }
        }
        assert (he != null);
        if (he == this._edgeListLeft || he != this._edgeListRight && Voronoi.isRightOf(he, s)) {
            while ((he = he.right) != this._edgeListRight && Voronoi.isRightOf(he, s)) {
            }
            he = he.left;
        } else {
            while ((he = he.left) != this._edgeListLeft && !Voronoi.isRightOf(he, s)) {
            }
        }
        if (bucket > 0 && bucket < n - 1) {
            this._edgeList[bucket] = he;
        }
        return he;
    }

    private int priQueueBucket(HalfEdge he) {
        int n = this._priQueue.length;
        int bucket = (int)((he.yStar - this._minY) / (this._maxY - this._minY) * (double)n);
        if (bucket < 0) {
            bucket = 0;
        }
        if (bucket >= n) {
            bucket = n - 1;
        }
        if (bucket < this._priQueueMin) {
            this._priQueueMin = bucket;
        }
        return bucket;
    }

    private void priQueueDelete(HalfEdge he) {
        if (he.vertex == null) {
            return;
        }
        HalfEdge hash = this._priQueue[this.priQueueBucket(he)];
        while (hash.next != he) {
            hash = hash.next;
        }
        hash.next = he.next;
        --this._priQueueCount;
        he.vertex = null;
    }

    private void priQueueInit() {
        this._priQueueMin = 0;
        this._priQueueCount = 0;
        int n = (int)(4.0 * Math.sqrt(this._sites.length + 4));
        this._priQueue = new HalfEdge[n];
        for (int i = 0; i < this._priQueue.length; ++i) {
            this._priQueue[i] = new HalfEdge();
        }
    }

    private void priQueueInsert(HalfEdge he, SiteVertex v, double offset) {
        he.vertex = v;
        he.yStar = v.y + offset;
        HalfEdge hash = this._priQueue[this.priQueueBucket(he)];
        HalfEdge next = hash.next;
        while (next != null && (he.yStar > next.yStar || he.yStar == next.yStar && v.x > next.vertex.x)) {
            hash = next;
            next = hash.next;
        }
        he.next = hash.next;
        hash.next = he;
        ++this._priQueueCount;
    }

    private PointD priQueuePeek() {
        while (this._priQueue[this._priQueueMin].next == null) {
            ++this._priQueueMin;
        }
        return new PointD(this._priQueue[this._priQueueMin].next.vertex.x, this._priQueue[this._priQueueMin].next.yStar);
    }

    private HalfEdge priQueuePop() {
        HalfEdge he = this._priQueue[this._priQueueMin].next;
        this._priQueue[this._priQueueMin].next = he.next;
        --this._priQueueCount;
        return he;
    }

    private static class SiteVertex {
        int index;
        final double x;
        final double y;

        SiteVertex(double x, double y) {
            this.x = x;
            this.y = y;
        }

        SiteVertex(PointD p, int index) {
            this.x = p.x;
            this.y = p.y;
            this.index = index;
        }
    }

    private static class HalfEdge {
        FullEdge edge;
        boolean isRight;
        HalfEdge left;
        HalfEdge next;
        HalfEdge right;
        SiteVertex vertex;
        double yStar;

        HalfEdge() {
        }

        HalfEdge(FullEdge edge, boolean isRight) {
            this.edge = edge;
            this.isRight = isRight;
        }
    }

    private static class FullEdge {
        double a;
        double b;
        double c;
        SiteVertex leftSite;
        SiteVertex leftVertex;
        SiteVertex rightSite;
        SiteVertex rightVertex;

        private FullEdge() {
        }

        SiteVertex getVertex(boolean isRight) {
            return isRight ? this.rightVertex : this.leftVertex;
        }

        void setVertex(boolean isRight, SiteVertex vertex) {
            if (isRight) {
                this.rightVertex = vertex;
            } else {
                this.leftVertex = vertex;
            }
        }
    }
}

