/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

public final class VoronoiEdge {
    public final int site1;
    public final int site2;
    public final int vertex1;
    public final int vertex2;

    VoronoiEdge(int site1, int site2, int vertex1, int vertex2) {
        if (site1 < 0) {
            throw new IllegalArgumentException("site1 < 0");
        }
        if (site2 < 0) {
            throw new IllegalArgumentException("site2 < 0");
        }
        if (vertex1 < 0) {
            throw new IllegalArgumentException("vertex1 < 0");
        }
        if (vertex2 < 0) {
            throw new IllegalArgumentException("vertex2 < 0");
        }
        this.site1 = site1;
        this.site2 = site2;
        this.vertex1 = vertex1;
        this.vertex2 = vertex2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VoronoiEdge)) {
            return false;
        }
        VoronoiEdge edge = (VoronoiEdge)obj;
        return this.site1 == edge.site1 && this.site2 == edge.site2 && this.vertex1 == edge.vertex1 && this.vertex2 == edge.vertex2;
    }

    public int hashCode() {
        return 31 * (31 * (31 * this.site1 + this.site2) + this.vertex1) + this.vertex2;
    }

    public String toString() {
        return String.format("VoronoiEdge[site1=%d, site2=%d, vertex1=%d, vertex2=%d]", this.site1, this.site2, this.vertex1, this.vertex2);
    }
}

