/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.geometry;

import java.util.ArrayList;
import org.kynosarges.tektosyne.NodeList;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.RectD;
import org.kynosarges.tektosyne.geometry.VoronoiEdge;
import org.kynosarges.tektosyne.subdivision.Subdivision;

public final class VoronoiResults {
    private static final int MINX_MINY = -1;
    private static final int MINX_MAXY = -2;
    private static final int MAXX_MAXY = -3;
    private static final int MAXX_MINY = -4;
    private static final int[] CORNERS = new int[]{-1, -2, -3, -4};
    public final RectD clippingBounds;
    public final PointD[] generatorSites;
    public final VoronoiEdge[] voronoiEdges;
    public final PointD[] voronoiVertices;
    private final double _clipMinX;
    private final double _clipMaxX;
    private final double _clipMinY;
    private final double _clipMaxY;
    private final PointD _clipMinXMaxY;
    private final PointD _clipMaxXMinY;
    private PointD[][] _voronoiRegions;

    VoronoiResults(RectD clippingBounds, PointD[] generatorSites, PointD[] voronoiVertices, VoronoiEdge[] voronoiEdges) {
        if (clippingBounds == null) {
            throw new NullPointerException("clippingBounds");
        }
        if (generatorSites == null) {
            throw new NullPointerException("generatorSites");
        }
        if (voronoiVertices == null) {
            throw new NullPointerException("voronoiVertices");
        }
        if (voronoiEdges == null) {
            throw new NullPointerException("voronoiEdges");
        }
        this.clippingBounds = clippingBounds;
        this.generatorSites = generatorSites;
        this.voronoiVertices = voronoiVertices;
        this.voronoiEdges = voronoiEdges;
        this._clipMinX = clippingBounds.min.x;
        this._clipMinY = clippingBounds.min.y;
        this._clipMaxX = clippingBounds.max.x;
        this._clipMaxY = clippingBounds.max.y;
        this._clipMinXMaxY = new PointD(this._clipMinX, this._clipMaxY);
        this._clipMaxXMinY = new PointD(this._clipMaxX, this._clipMinY);
    }

    public LineD[] delaunayEdges() {
        LineD[] edges = new LineD[this.voronoiEdges.length];
        for (int i = 0; i < this.voronoiEdges.length; ++i) {
            edges[i] = new LineD(this.generatorSites[this.voronoiEdges[i].site1], this.generatorSites[this.voronoiEdges[i].site2]);
        }
        return edges;
    }

    public PointD[][] voronoiRegions() {
        if (this._voronoiRegions == null) {
            this.createRegions();
        }
        return this._voronoiRegions;
    }

    public void clearVoronoiRegions() {
        this._voronoiRegions = null;
    }

    public LineD[] clipDelaunayEdges(RectD bounds) {
        ArrayList<LineD> delaunayEdges = new ArrayList<LineD>(this.voronoiEdges.length);
        for (VoronoiEdge edge : this.voronoiEdges) {
            PointD v2;
            PointD v1;
            PointD s1 = this.generatorSites[edge.site1];
            PointD s2 = this.generatorSites[edge.site2];
            if (!bounds.contains(s1) || !bounds.contains(s2) || !bounds.intersectsWith(new LineD(v1 = this.voronoiVertices[edge.vertex1], v2 = this.voronoiVertices[edge.vertex2]))) continue;
            delaunayEdges.add(new LineD(s1, s2));
        }
        return delaunayEdges.toArray(new LineD[delaunayEdges.size()]);
    }

    public Subdivision toDelaunaySubdivision(boolean addRegions) {
        Subdivision division = Subdivision.fromLines(this.delaunayEdges(), 0.0);
        if (addRegions) {
            for (int i = 0; i < this.generatorSites.length; ++i) {
                division.vertexRegions().put(this.generatorSites[i], this.voronoiRegions()[i]);
            }
        }
        return division;
    }

    public Subdivision toDelaunaySubdivision(RectD bounds, boolean addRegions) {
        LineD[] edges = this.clipDelaunayEdges(bounds);
        Subdivision division = Subdivision.fromLines(edges, 0.0);
        if (addRegions) {
            for (int i = 0; i < this.generatorSites.length; ++i) {
                PointD[] region;
                PointD site = this.generatorSites[i];
                if (!bounds.contains(site) || (region = bounds.intersect(this.voronoiRegions()[i])) == null) continue;
                division.vertexRegions().put(site, region);
            }
        }
        return division;
    }

    private void closeCornerRegion(NodeList<PointI> region, PointD site, PointD v1, PointD v2) {
        int[] corners;
        assert (!v1.equals(v2));
        assert (this.isAnyMinMax(v1));
        assert (this.isAnyMinMax(v2));
        if (this.areSameMinMax(v1, v2)) {
            return;
        }
        if (this.areOtherMinMaxX(v1.x, v2.x) && this.areBetweenY(v1.y, v2.y)) {
            double border = this.findHorizontalBorder(site, v1, v2);
            PointD corner = new PointD(v2.x, border);
            PointD secondCorner = new PointD(v1.x, corner.y);
            region.addLast(this.createCornerEdge(corner));
            region.addLast(this.createCornerEdge(secondCorner));
            return;
        }
        if (this.areOtherMinMaxY(v1.y, v2.y) && this.areBetweenX(v1.x, v2.x)) {
            double border = this.findVerticalBorder(site, v1, v2);
            PointD corner = new PointD(border, v2.y);
            PointD secondCorner = new PointD(corner.x, v1.y);
            region.addLast(this.createCornerEdge(corner));
            region.addLast(this.createCornerEdge(secondCorner));
            return;
        }
        assert (this.isMinMaxX(v1.x) && this.isMinMaxY(v2.y) || this.isMinMaxY(v1.y) && this.isMinMaxX(v2.x));
        for (int corner : corners = this.findCorners(site, v2, v1)) {
            if (corner == 0) break;
            region.addLast(new PointI(corner, Integer.MIN_VALUE));
        }
    }

    private void connectCandidates(NodeList<PointI> candidates, NodeList<PointI> region) {
        int firstIndex = region.first().value().x;
        int lastIndex = region.last().value().y;
        PointD firstVertex = this.getVertex(firstIndex);
        PointD lastVertex = this.getVertex(lastIndex);
        assert (this.isAnyMinMax(firstVertex));
        assert (this.isAnyMinMax(lastVertex));
        int connect1 = -1;
        int connect2 = -1;
        for (PointI candidate : candidates) {
            connect1 = candidate.x;
            PointD connectVertex = this.getVertex(connect1);
            if (this.areSameMinMax(connectVertex, firstVertex)) {
                connect2 = firstIndex;
                break;
            }
            if (this.areSameMinMax(connectVertex, lastVertex)) {
                connect2 = lastIndex;
                break;
            }
            connect1 = candidate.y;
            connectVertex = this.getVertex(connect1);
            if (this.areSameMinMax(connectVertex, firstVertex)) {
                connect2 = firstIndex;
                break;
            }
            if (!this.areSameMinMax(connectVertex, lastVertex)) continue;
            connect2 = lastIndex;
            break;
        }
        if (connect2 >= 0) {
            candidates.addFirst(new PointI(connect1, connect2));
            return;
        }
        connect1 = -1;
        connect2 = -1;
        int corner = 0;
        for (PointI candidate : candidates) {
            connect1 = candidate.x;
            PointD connectVertex = this.getVertex(connect1);
            corner = this.getCornerPseudo(connectVertex, firstVertex);
            if (corner != 0) {
                connect2 = firstIndex;
                break;
            }
            corner = this.getCornerPseudo(connectVertex, lastVertex);
            if (corner != 0) {
                connect2 = lastIndex;
                break;
            }
            connect1 = candidate.y;
            connectVertex = this.getVertex(connect1);
            corner = this.getCornerPseudo(connectVertex, firstVertex);
            if (corner != 0) {
                connect2 = firstIndex;
                break;
            }
            corner = this.getCornerPseudo(connectVertex, lastVertex);
            if (corner == 0) continue;
            connect2 = lastIndex;
            break;
        }
        assert (connect2 >= 0);
        candidates.addFirst(new PointI(corner, connect2));
        candidates.addFirst(new PointI(connect1, corner));
    }

    private PointI createCornerEdge(PointD p) {
        int index = this.getCornerPseudo(p);
        assert (index != 0);
        return new PointI(index, Integer.MIN_VALUE);
    }

    private void createRegions() {
        int i;
        NodeList[] listRegions = new NodeList[this.generatorSites.length];
        for (int i2 = 0; i2 < listRegions.length; ++i2) {
            listRegions[i2] = new NodeList();
        }
        for (VoronoiEdge edge : this.voronoiEdges) {
            PointI vertex = new PointI(edge.vertex1, edge.vertex2);
            listRegions[edge.site1].addLast(vertex);
            listRegions[edge.site2].addLast(vertex);
        }
        for (i = 0; i < listRegions.length; ++i) {
            NodeList candidates = listRegions[i];
            NodeList<PointI> listRegion = new NodeList<PointI>();
            listRegion.addFirst((PointI)candidates.first().value());
            candidates.removeFirst();
            NodeList.Node candidate = candidates.first();
            boolean wasEdgeAdded = false;
            while (candidate != null) {
                NodeList.Node nextCandidate = candidate.next();
                PointI vertex = (PointI)candidate.value();
                for (NodeList.Node node = listRegion.first(); node != null; node = node.next()) {
                    assert (!vertex.equals(node.value()));
                    if (vertex.x == ((PointI)node.value()).x || vertex.y == ((PointI)node.value()).y) {
                        vertex = new PointI(vertex.y, vertex.x);
                    }
                    if (vertex.y == ((PointI)node.value()).x) {
                        candidates.remove(candidate);
                        listRegion.addBefore(node, vertex);
                        wasEdgeAdded = true;
                        break;
                    }
                    if (((PointI)node.value()).y != vertex.x) continue;
                    candidates.remove(candidate);
                    listRegion.addAfter(node, vertex);
                    wasEdgeAdded = true;
                    break;
                }
                if ((candidate = nextCandidate) != null || candidates.isEmpty()) continue;
                if (!wasEdgeAdded) {
                    this.connectCandidates(candidates, listRegion);
                }
                candidate = candidates.first();
                wasEdgeAdded = false;
            }
            listRegions[i] = listRegion;
        }
        this._voronoiRegions = new PointD[this.generatorSites.length][];
        for (i = 0; i < listRegions.length; ++i) {
            NodeList listRegion = listRegions[i];
            int firstIndex = ((PointI)listRegion.first().value()).x;
            int lastIndex = ((PointI)listRegion.last().value()).y;
            if (firstIndex != lastIndex) {
                listRegion.addLast(new PointI(lastIndex, Integer.MIN_VALUE));
                PointD firstVertex = this.getVertex(firstIndex);
                PointD lastVertex = this.getVertex(lastIndex);
                if (firstVertex.x != lastVertex.x || firstVertex.y != lastVertex.y) {
                    this.closeCornerRegion(listRegion, this.generatorSites[i], firstVertex, lastVertex);
                }
            }
            PointD[] region = new PointD[listRegion.size()];
            this._voronoiRegions[i] = region;
            int j = 0;
            for (PointI edge : listRegion) {
                region[j++] = this.getVertex(edge.x);
            }
        }
    }

    private int[] findCorners(PointD site, PointD p, PointD q) {
        PointD oneCorner;
        LineD line = new LineD(p, q);
        int pc = this.getCornerPseudo(p);
        int qc = this.getCornerPseudo(q);
        if (pc != 0 && qc != 0) {
            LineLocation siteLocation = line.locate(site);
            if (siteLocation != LineLocation.LEFT && siteLocation != LineLocation.RIGHT) {
                throw new RuntimeException("locate(site): invalid " + (Object)((Object)siteLocation));
            }
            boolean isLeft = siteLocation == LineLocation.LEFT;
            int[] result = new int[1];
            switch (pc) {
                case -1: {
                    assert (qc == -3);
                    result[0] = isLeft ? -2 : -4;
                    break;
                }
                case -2: {
                    assert (qc == -4);
                    result[0] = isLeft ? -3 : -1;
                    break;
                }
                case -3: {
                    assert (qc == -1);
                    result[0] = isLeft ? -4 : -2;
                    break;
                }
                case -4: {
                    assert (qc == -2);
                    result[0] = isLeft ? -1 : -3;
                    break;
                }
                default: {
                    throw new RuntimeException("getCornerPseudo(p): invalid " + pc);
                }
            }
            return result;
        }
        if (this.isMinMaxX(p.x) && this.isMinMaxY(q.y)) {
            oneCorner = new PointD(p.x, q.y);
        } else {
            assert (this.isMinMaxX(q.x));
            assert (this.isMinMaxY(p.y));
            oneCorner = new PointD(q.x, p.y);
        }
        if (line.locate(oneCorner) == LineLocation.RIGHT) {
            line = line.reverse();
            assert (line.locate(oneCorner) == LineLocation.LEFT);
        }
        if (this.generatorSites.length == 2) {
            switch (line.locate(site)) {
                case LEFT: {
                    return new int[]{this.getCornerPseudo(oneCorner)};
                }
                case RIGHT: {
                    return this.getThreeCorners(oneCorner, p, q);
                }
            }
        } else {
            for (PointD vertex : this.voronoiVertices) {
                switch (line.locate(vertex)) {
                    case LEFT: {
                        return this.getThreeCorners(oneCorner, p, q);
                    }
                    case RIGHT: {
                        return new int[]{this.getCornerPseudo(oneCorner)};
                    }
                }
            }
        }
        throw new RuntimeException("Cannot identify open side of Voronoi region.");
    }

    private double findHorizontalBorder(PointD site, PointD p, PointD q) {
        LineD line;
        LineD lineD = line = p.x < q.x ? new LineD(p, q) : new LineD(q, p);
        assert (line.start.x == this._clipMinX);
        assert (line.end.x == this._clipMaxX);
        if (this.generatorSites.length == 2) {
            switch (line.locate(site)) {
                case LEFT: {
                    return this._clipMaxY;
                }
                case RIGHT: {
                    return this._clipMinY;
                }
            }
        } else {
            for (PointD vertex : this.voronoiVertices) {
                switch (line.locate(vertex)) {
                    case LEFT: {
                        return this._clipMinY;
                    }
                    case RIGHT: {
                        return this._clipMaxY;
                    }
                }
            }
        }
        throw new RuntimeException("Cannot identify open side of Voronoi region.");
    }

    private double findVerticalBorder(PointD site, PointD p, PointD q) {
        LineD line;
        LineD lineD = line = p.y < q.y ? new LineD(p, q) : new LineD(q, p);
        assert (line.start.y == this._clipMinY);
        assert (line.end.y == this._clipMaxY);
        if (this.generatorSites.length == 2) {
            switch (line.locate(site)) {
                case LEFT: {
                    return this._clipMinX;
                }
                case RIGHT: {
                    return this._clipMaxX;
                }
            }
        } else {
            for (PointD vertex : this.voronoiVertices) {
                switch (line.locate(vertex)) {
                    case LEFT: {
                        return this._clipMaxX;
                    }
                    case RIGHT: {
                        return this._clipMinX;
                    }
                }
            }
        }
        throw new RuntimeException("Cannot identify open side of Voronoi region.");
    }

    private int getCornerPseudo(PointD p) {
        if (p.x == this._clipMinX) {
            if (p.y == this._clipMinY) {
                return -1;
            }
            if (p.y == this._clipMaxY) {
                return -2;
            }
        } else if (p.x == this._clipMaxX) {
            if (p.y == this._clipMinY) {
                return -4;
            }
            if (p.y == this._clipMaxY) {
                return -3;
            }
        }
        return 0;
    }

    private int getCornerPseudo(PointD p, PointD q) {
        if (p.x == this._clipMinX) {
            if (q.y == this._clipMinY) {
                return -1;
            }
            if (q.y == this._clipMaxY) {
                return -2;
            }
        } else if (p.x == this._clipMaxX) {
            if (q.y == this._clipMinY) {
                return -4;
            }
            if (q.y == this._clipMaxY) {
                return -3;
            }
        } else if (p.y == this._clipMinY) {
            if (q.x == this._clipMinX) {
                return -1;
            }
            if (q.x == this._clipMaxX) {
                return -4;
            }
        } else if (p.y == this._clipMaxY) {
            if (q.x == this._clipMinX) {
                return -2;
            }
            if (q.x == this._clipMaxX) {
                return -3;
            }
        }
        return 0;
    }

    private int getNextCornerIndex(PointD p) {
        if (p.y == this._clipMinY) {
            return p.x == this._clipMaxX ? 3 : 0;
        }
        if (p.x == this._clipMinX) {
            return 1;
        }
        if (p.y == this._clipMaxY) {
            return 2;
        }
        if (p.x == this._clipMaxX) {
            return 3;
        }
        throw new IllegalArgumentException("p not on clippingBounds");
    }

    private int[] getThreeCorners(PointD corner, PointD p, PointD q) {
        assert (!corner.equals(p));
        assert (!corner.equals(q));
        int pNext = this.getNextCornerIndex(p);
        int qNext = this.getNextCornerIndex(q);
        int ci = this.getNextCornerIndex(corner);
        assert (CORNERS[ci] == this.getCornerPseudo(corner));
        boolean clockwise = ci < pNext || qNext > pNext && ci >= qNext;
        int pCorner = this.getCornerPseudo(p);
        int qCorner = this.getCornerPseudo(q);
        int[] result = new int[3];
        int ri = 0;
        int cursor = pNext;
        while (cursor != qNext) {
            int cursorCorner;
            if (!clockwise && --cursor < 0) {
                cursor = 3;
            }
            if ((cursorCorner = CORNERS[cursor]) != pCorner && cursorCorner != qCorner) {
                result[ri++] = cursorCorner;
            }
            if (!clockwise || ++cursor <= 3) continue;
            cursor = 0;
        }
        return result;
    }

    private PointD getVertex(int index) {
        switch (index) {
            case -1: {
                return this.clippingBounds.min;
            }
            case -2: {
                return this._clipMinXMaxY;
            }
            case -4: {
                return this._clipMaxXMinY;
            }
            case -3: {
                return this.clippingBounds.max;
            }
        }
        return this.voronoiVertices[index];
    }

    private boolean isMinMaxX(double x) {
        return x == this._clipMinX || x == this._clipMaxX;
    }

    private boolean isMinMaxY(double y) {
        return y == this._clipMinY || y == this._clipMaxY;
    }

    private boolean areBetweenX(double x1, double x2) {
        return x1 > this._clipMinX && x1 < this._clipMaxX && x2 > this._clipMinX && x2 < this._clipMaxX;
    }

    private boolean areBetweenY(double y1, double y2) {
        return y1 > this._clipMinY && y1 < this._clipMaxY && y2 > this._clipMinY && y2 < this._clipMaxY;
    }

    private boolean areOtherMinMaxX(double x1, double x2) {
        return x1 == this._clipMinX && x2 == this._clipMaxX || x1 == this._clipMaxX && x2 == this._clipMinX;
    }

    private boolean areOtherMinMaxY(double y1, double y2) {
        return y1 == this._clipMinY && y2 == this._clipMaxY || y1 == this._clipMaxY && y2 == this._clipMinY;
    }

    private boolean isAnyMinMax(PointD p) {
        return p.x == this._clipMinX || p.x == this._clipMaxX || p.y == this._clipMinY || p.y == this._clipMaxY;
    }

    private boolean areSameMinMax(PointD p, PointD q) {
        return p.x == q.x && (p.x == this._clipMinX || p.x == this._clipMaxX) || p.y == q.y && (p.y == this._clipMinY || p.y == this._clipMaxY);
    }
}

