/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.graph.Graph;
import org.kynosarges.tektosyne.graph.GraphAgent;
import org.kynosarges.tektosyne.graph.GraphPath;
import org.kynosarges.tektosyne.graph.PathNode;

public class AStar<T>
implements GraphPath<T> {
    private GraphAgent<T> _agent;
    private T _source;
    private T _target;
    private double _relativeLimit;
    private PointD _targetWorld;
    private double _absoluteLimit;
    private PathNode<T> _bestNode;
    private final List<T> _nodes = new ArrayList<T>(0);
    private PathNode<T> _openList;
    private final Stack<PathNode<T>> _parents = new Stack();
    private final Map<T, PathNode<T>> _openTable = new HashMap<T, PathNode<T>>(0);
    private final Map<T, PathNode<T>> _closedTable = new HashMap<T, PathNode<T>>(0);
    public final Graph<T> graph;
    public boolean useWorldDistance;

    public AStar(Graph<T> graph) {
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        this.graph = graph;
    }

    public boolean findBestPath(GraphAgent<T> agent, T source, T target) {
        if (agent == null) {
            throw new NullPointerException("agent");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        this._agent = agent;
        this._source = source;
        this._target = target;
        this._absoluteLimit = 0.0;
        this._bestNode = null;
        this._nodes.clear();
        this._targetWorld = PointD.EMPTY;
        if (!this.graph.contains(source) || !this.graph.contains(target)) {
            return false;
        }
        double distance = this.graph.getDistance(source, target);
        if (this._relativeLimit > 0.0) {
            this._absoluteLimit = distance * this._relativeLimit;
        }
        if (this.useWorldDistance) {
            this._targetWorld = this.graph.getWorldLocation(target);
        }
        this._openList = new PathNode<T>(source, this.graph.connectivity());
        this._openList._h = distance;
        boolean success = false;
        while (this.setBestNode()) {
            Object node = this._bestNode.node;
            if (this._agent.isNearTarget(node, target, this._bestNode._h) && (Objects.equals(source, node) || this._agent.canOccupy(node))) {
                success = true;
                break;
            }
            this.createChildren(this._bestNode);
        }
        this._target = null;
        this._source = null;
        assert (this._parents.isEmpty());
        this._openList = null;
        this._openTable.clear();
        this._closedTable.clear();
        return success;
    }

    public double absoluteLimit() {
        return this._absoluteLimit;
    }

    public GraphAgent<T> agent() {
        return this._agent;
    }

    public PathNode<T> bestNode() {
        return this._bestNode;
    }

    @Override
    public T getLastNode(double maxCost) {
        return this.getLastPathNode((double)maxCost).node;
    }

    public PathNode<T> getLastPathNode(double maxCost) {
        if (maxCost <= 0.0) {
            throw new IllegalArgumentException("maxCost <= 0");
        }
        if (this._bestNode == null) {
            throw new IllegalStateException("bestNode == null");
        }
        PathNode<T> cursor = this._bestNode;
        boolean relaxed = this._agent.relaxedRange();
        PathNode parent;
        while ((parent = cursor._parent) != null) {
            if ((cursor._g <= maxCost || relaxed && parent._g < maxCost) && this._agent.canOccupy(cursor.node)) {
                return cursor;
            }
            cursor = parent;
        }
        return cursor;
    }

    @Override
    public List<T> nodes() {
        if (this._nodes.isEmpty() && this._bestNode != null) {
            PathNode<T> cursor = this._bestNode;
            while (cursor != null) {
                this._nodes.add(cursor.node);
                cursor = cursor._parent;
            }
            Collections.reverse(this._nodes);
        }
        return Collections.unmodifiableList(this._nodes);
    }

    public double relativeLimit() {
        return this._relativeLimit;
    }

    public void setRelativeLimit(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("value < 0");
        }
        if (value > 0.0 && value < 1.0) {
            throw new IllegalArgumentException("value > 0 && value < 1");
        }
        this._relativeLimit = value;
    }

    @Override
    public double totalCost() {
        return this._bestNode == null ? -1.0 : this._bestNode._g;
    }

    private void createChildren(PathNode<T> parent) {
        Object source = parent.node;
        Collection<T> neighbors = this.graph.getNeighbors(source);
        for (T neighbor : neighbors) {
            if (!this._agent.canMakeStep(source, neighbor)) continue;
            this.linkChild(parent, neighbor);
        }
    }

    private double getWorldDistance(PathNode<T> node) {
        PointD nodeWorld = this.graph.getWorldLocation(node.node);
        double x = nodeWorld.x - this._targetWorld.x;
        double y = nodeWorld.y - this._targetWorld.y;
        return x * x + y * y;
    }

    private void linkChild(PathNode<T> parent, T graphChild) {
        double fromSource;
        double g = parent._g + this._agent.getStepCost(parent.node, graphChild);
        assert (g > parent._g);
        PathNode<T> child = this._openTable.get(graphChild);
        if (child != null) {
            parent._children.add(child);
            if (child._g > g) {
                child._g = g;
                child._parent = parent;
            }
            return;
        }
        child = this._closedTable.get(graphChild);
        if (child != null) {
            parent._children.add(child);
            if (child._g > g) {
                child._g = g;
                child._parent = parent;
                this.updateParents(child);
            }
            return;
        }
        double fromTarget = this.graph.getDistance(graphChild, this._target);
        if (this._absoluteLimit > 0.0 && (fromSource = this.graph.getDistance(this._source, graphChild)) + fromTarget > this._absoluteLimit) {
            return;
        }
        child = new PathNode<T>(graphChild, this.graph.connectivity());
        parent._children.add(child);
        child._g = g;
        child._h = fromTarget;
        child._parent = parent;
        child._next = this._openList;
        this._openList = child;
        this._openTable.put(graphChild, child);
    }

    private boolean setBestNode() {
        if (this._openList == null) {
            this._bestNode = null;
            return false;
        }
        this._bestNode = this._openList;
        double bestF = this._bestNode.f();
        PathNode<T> previous = null;
        if (this.useWorldDistance) {
            double bestDistance = this.getWorldDistance(this._bestNode);
            PathNode<T> preCursor = this._openList;
            PathNode cursor = preCursor._next;
            while (cursor != null) {
                double cursorDistance = this.getWorldDistance(cursor);
                if (cursor.f() < bestF || cursor.f() == bestF && cursorDistance < bestDistance) {
                    previous = preCursor;
                    this._bestNode = cursor;
                    bestF = cursor.f();
                    bestDistance = cursorDistance;
                }
                preCursor = cursor;
                cursor = cursor._next;
            }
        } else {
            PathNode<T> preCursor = this._openList;
            PathNode cursor = preCursor._next;
            while (cursor != null) {
                if (cursor.f() < bestF) {
                    previous = preCursor;
                    this._bestNode = cursor;
                    bestF = cursor.f();
                }
                preCursor = cursor;
                cursor = cursor._next;
            }
        }
        if (previous == null) {
            this._openList = this._openList._next;
        } else {
            previous._next = this._bestNode._next;
        }
        Object graphNode = this._bestNode.node;
        this._openTable.remove(graphNode);
        this._closedTable.put(graphNode, this._bestNode);
        return true;
    }

    private void updateParents(PathNode<T> node) {
        assert (this._parents.isEmpty());
        this._parents.push(node);
        while (this._parents.size() > 0) {
            PathNode<T> parent = this._parents.pop();
            List children = parent._children;
            for (PathNode child : children) {
                if (child._g <= parent._g) continue;
                double g = parent._g + this._agent.getStepCost(parent.node, child.node);
                assert (g > parent._g);
                if (!(child._g > g)) continue;
                child._g = g;
                child._parent = parent;
                this._parents.push(child);
            }
        }
    }
}

