/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kynosarges.tektosyne.graph.Graph;
import org.kynosarges.tektosyne.graph.GraphAgent;

public class Coverage<T> {
    private GraphAgent<T> _agent;
    private double _maxCost;
    private final List<T> _nodes = new ArrayList<T>(0);
    private final Map<T, Double> _pathCosts = new HashMap<T, Double>(0);
    public final Graph<T> graph;

    public Coverage(Graph<T> graph) {
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        this.graph = graph;
    }

    public boolean findReachable(GraphAgent<T> agent, T source, double maxCost) {
        if (agent == null) {
            throw new NullPointerException("agent");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (maxCost <= 0.0) {
            throw new IllegalArgumentException("maxCost <= 0");
        }
        this._agent = agent;
        this._maxCost = maxCost;
        this._nodes.clear();
        if (!this.graph.contains(source)) {
            return false;
        }
        this._pathCosts.put(source, -1.0);
        this.expandArea(source, 0.0);
        this._pathCosts.clear();
        return !this._nodes.isEmpty();
    }

    public GraphAgent<T> agent() {
        return this._agent;
    }

    public List<T> nodes() {
        return Collections.unmodifiableList(this._nodes);
    }

    private void expandArea(T node, double cost) {
        Collection<T> neighbors = this.graph.getNeighbors(node);
        for (T neighbor : neighbors) {
            Double minCost = this._pathCosts.get(neighbor);
            if (minCost != null && minCost <= cost || !this._agent.canMakeStep(node, neighbor)) continue;
            double stepCost = this._agent.getStepCost(node, neighbor);
            assert (stepCost > 0.0);
            if (!this._agent.relaxedRange() && cost + stepCost > this._maxCost || minCost != null && minCost <= cost + stepCost) continue;
            if (minCost == null && this._agent.canOccupy(neighbor)) {
                this._nodes.add(neighbor);
            }
            this._pathCosts.put(neighbor, cost + stepCost);
            if (!(cost + stepCost < this._maxCost)) continue;
            this.expandArea(neighbor, cost + stepCost);
        }
    }
}

