/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.kynosarges.tektosyne.graph.Graph;

public class FloodFill<T> {
    private Predicate<T> _match;
    private final List<T> _nodes = new ArrayList<T>(0);
    private final HashSet<T> _visited = new HashSet();
    public final Graph<T> graph;

    public FloodFill(Graph<T> graph) {
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        this.graph = graph;
    }

    public boolean findMatching(Predicate<T> match, T source) {
        if (match == null) {
            throw new NullPointerException("match");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        this._match = match;
        this._nodes.clear();
        if (!this.graph.contains(source)) {
            return false;
        }
        this._visited.add(source);
        this.expandArea(source);
        this._match = null;
        this._visited.clear();
        return !this._nodes.isEmpty();
    }

    public List<T> nodes() {
        return Collections.unmodifiableList(this._nodes);
    }

    private void expandArea(T node) {
        Collection<T> neighbors = this.graph.getNeighbors(node);
        for (T neighbor : neighbors) {
            if (this._visited.contains(neighbor)) continue;
            this._visited.add(neighbor);
            if (!this._match.test(neighbor)) continue;
            this._nodes.add(neighbor);
            this.expandArea(neighbor);
        }
    }
}

