/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.kynosarges.tektosyne.geometry.PointD;

public interface Graph<T> {
    public int connectivity();

    public int nodeCount();

    public Collection<T> nodes();

    public boolean contains(T var1);

    public T findNearestNode(PointD var1);

    public double getDistance(T var1, T var2);

    public Collection<T> getNeighbors(T var1);

    default public Collection<T> getNeighbors(T node, int steps) {
        if (steps <= 0) {
            throw new IllegalArgumentException("steps <= 0");
        }
        if (!this.contains(node)) {
            return Collections.emptySet();
        }
        if (steps == 1) {
            return this.getNeighbors(node);
        }
        HashSet neighbors = new HashSet();
        ArrayList<T> queue = new ArrayList<T>();
        ArrayList nextQueue = new ArrayList();
        queue.add(node);
        for (int step = 0; step < steps; ++step) {
            for (Object queueNode : queue) {
                neighbors.add(queueNode);
                for (Object neighbor : this.getNeighbors(queueNode)) {
                    if (neighbors.contains(neighbor)) continue;
                    nextQueue.add(neighbor);
                }
            }
            queue.clear();
            ArrayList<T> swap = queue;
            queue = nextQueue;
            nextQueue = swap;
        }
        neighbors.addAll(queue);
        neighbors.remove(node);
        return neighbors;
    }

    public PointD getWorldLocation(T var1);

    public PointD[] getWorldRegion(T var1);
}

