/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

public final class NodeArc {
    private double _start;
    private double _sweep;
    double _visibleFraction = 1.0;
    public final double distance;

    NodeArc(double start, double sweep, double distance) {
        if (sweep < 0.0) {
            throw new IllegalArgumentException("sweep < 0");
        }
        if (sweep > Math.PI * 2) {
            throw new IllegalArgumentException("sweep > 2 * Math.PI");
        }
        if (distance <= 0.0) {
            throw new IllegalArgumentException("distance <= 0");
        }
        this._start = start;
        this._sweep = sweep;
        this.distance = distance;
    }

    NodeArc(NodeArc arc) {
        this._start = arc._start;
        this._sweep = arc._sweep;
        this.distance = arc.distance;
    }

    public double start() {
        return this._start;
    }

    public double sweep() {
        return this._sweep;
    }

    public double visibleFraction() {
        return this._visibleFraction;
    }

    public int isObscured(NodeArc arc) {
        double relativeStart = arc._start - this._start;
        if (relativeStart <= -Math.PI) {
            relativeStart += Math.PI * 2;
        } else if (relativeStart > Math.PI) {
            relativeStart -= Math.PI * 2;
        }
        assert (relativeStart > -Math.PI && relativeStart <= Math.PI);
        double relativeSweep = relativeStart + arc._sweep;
        if (relativeStart <= 0.0 && relativeSweep >= this._sweep && arc.distance <= this.distance) {
            return -1;
        }
        if (relativeStart >= 0.0 && relativeSweep <= this._sweep && arc.distance > this.distance) {
            return 1;
        }
        return 0;
    }

    void obscure(NodeArc arc) {
        if (this.distance >= arc.distance) {
            throw new IllegalArgumentException("distance >= arc.distance");
        }
        double relativeStart = this._start - arc._start;
        if (relativeStart <= -Math.PI) {
            relativeStart += Math.PI * 2;
        } else if (relativeStart > Math.PI) {
            relativeStart -= Math.PI * 2;
        }
        double relativeSweep = relativeStart + this._sweep;
        if (relativeSweep <= 0.0 || arc._sweep <= relativeStart) {
            return;
        }
        if (relativeStart <= 0.0 && relativeSweep >= arc._sweep) {
            arc._sweep = 0.0;
            return;
        }
        if (relativeStart <= 0.0) {
            assert (relativeSweep < this._sweep);
            arc._start += relativeSweep;
            arc._sweep -= relativeSweep;
            return;
        }
        if (relativeSweep >= this._sweep) {
            assert (relativeStart > 0.0);
            arc._sweep = relativeStart;
            return;
        }
        assert (relativeStart > 0.0 && relativeSweep < arc._sweep);
        if (relativeStart >= arc._sweep - relativeSweep) {
            arc._sweep = relativeStart;
        } else {
            arc._start += relativeSweep;
            arc._sweep -= relativeSweep;
        }
    }
}

