/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.graph.Graph;
import org.kynosarges.tektosyne.graph.NodeArc;

public class Visibility<T> {
    private T _source;
    private PointD _sourceWorld;
    private Predicate<T> _isOpaque;
    private double _distance;
    private double _threshold = 0.3333333333333333;
    private final List<T> _nodes = new ArrayList<T>();
    private final Map<T, NodeArc> _nodeArcs = new HashMap<T, NodeArc>();
    private final Map<T, NodeArc> _obscuringNodes = new HashMap<T, NodeArc>();
    private final List<T> _removeNodes = new ArrayList<T>();
    public final Graph<T> graph;

    public Visibility(Graph<T> graph) {
        if (graph == null) {
            throw new NullPointerException("graph");
        }
        this.graph = graph;
    }

    public boolean findVisible(Predicate<T> isOpaque, T source, double distance) {
        if (isOpaque == null) {
            throw new NullPointerException("isOpaque");
        }
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (distance < 0.0) {
            throw new IllegalArgumentException("distance < 0");
        }
        this._nodes.clear();
        this._nodeArcs.clear();
        if (!this.graph.contains(source)) {
            return false;
        }
        this._isOpaque = isOpaque;
        this._source = source;
        this._distance = distance;
        this._sourceWorld = this.graph.getWorldLocation(source);
        this.findObscuringNodes(source);
        this.findVisibleNodes();
        this._isOpaque = null;
        this._source = null;
        this._obscuringNodes.clear();
        return !this._nodes.isEmpty();
    }

    public List<T> nodes() {
        return Collections.unmodifiableList(this._nodes);
    }

    public Map<T, NodeArc> nodeArcs() {
        return Collections.unmodifiableMap(this._nodeArcs);
    }

    public double threshold() {
        return this._threshold;
    }

    public void setThreshold(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("value < 0 || value > 1");
        }
        if (value == 0.0) {
            value = Double.MIN_NORMAL;
        }
        this._threshold = value;
    }

    private NodeArc createNodeArc(T target) {
        PointD targetWorld = this.graph.getWorldLocation(target);
        PointD[] region = this.graph.getWorldRegion(target);
        LineD line = new LineD(this._sourceWorld, targetWorld);
        double alpha = line.angle();
        if (region == null) {
            if ((alpha -= Math.PI / 360) <= -Math.PI) {
                alpha += Math.PI * 2;
            }
            return new NodeArc(alpha, Math.PI / 180, line.length());
        }
        double distance = Double.MAX_VALUE;
        double minBeta = 0.0;
        double maxBeta = 0.0;
        for (PointD vertex : region) {
            double beta = this._sourceWorld.angleBetween(targetWorld, vertex);
            if (beta <= minBeta) {
                minBeta = beta;
            } else if (beta >= maxBeta) {
                maxBeta = beta;
            }
            double vertexDistance = vertex.subtract(this._sourceWorld).length();
            if (!(distance > vertexDistance)) continue;
            distance = vertexDistance;
        }
        return new NodeArc(alpha + minBeta, maxBeta - minBeta, distance);
    }

    private void findObscuringNodes(T node) {
        Collection<T> neighbors = this.graph.getNeighbors(node);
        for (T neighbor : neighbors) {
            block5: {
                if (Objects.equals(this._source, neighbor) || this._nodeArcs.containsKey(neighbor)) continue;
                NodeArc arc = this.createNodeArc(neighbor);
                if (this._distance > 0.0 && arc.distance > this._distance) continue;
                this._nodeArcs.put(neighbor, arc);
                if (this._isOpaque.test(neighbor)) {
                    for (Map.Entry<T, NodeArc> pair : this._obscuringNodes.entrySet()) {
                        int result = arc.isObscured(pair.getValue());
                        if (result < 0) {
                            arc._visibleFraction = 0.0;
                            break block5;
                        }
                        if (result <= 0) continue;
                        pair.getValue()._visibleFraction = 0.0;
                        this._removeNodes.add(pair.getKey());
                    }
                    for (Map.Entry<Object, NodeArc> removeNode : this._removeNodes) {
                        this._obscuringNodes.remove(removeNode);
                    }
                    this._removeNodes.clear();
                    this._obscuringNodes.put(neighbor, arc);
                }
            }
            this.findObscuringNodes(neighbor);
        }
    }

    private void findVisibleNodes() {
        block0: for (Map.Entry<T, NodeArc> pair : this._nodeArcs.entrySet()) {
            NodeArc arc = pair.getValue();
            if (arc._visibleFraction == 0.0) continue;
            NodeArc obscuredArc = new NodeArc(arc);
            for (Map.Entry<T, NodeArc> obscuringPair : this._obscuringNodes.entrySet()) {
                if (Objects.equals(pair.getKey(), obscuringPair.getKey())) continue;
                NodeArc obscuringAngle = obscuringPair.getValue();
                if (obscuringAngle.distance >= arc.distance) continue;
                obscuringAngle.obscure(obscuredArc);
                arc._visibleFraction = obscuredArc.sweep() / arc.sweep();
                if (!(arc._visibleFraction < this._threshold)) continue;
                continue block0;
            }
            this._nodes.add(pair.getKey());
        }
    }
}

