/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointI;
import org.kynosarges.tektosyne.geometry.PolygonGrid;
import org.kynosarges.tektosyne.subdivision.Subdivision;
import org.kynosarges.tektosyne.subdivision.SubdivisionFace;
import org.kynosarges.tektosyne.subdivision.SubdivisionMap;

public final class PolygonGridMap
implements SubdivisionMap<PointI> {
    private final Subdivision _source;
    private final PolygonGrid _target;
    private final PointI[] _faceToGrid;
    private final SubdivisionFace[][] _gridToFace;

    public PolygonGridMap(PolygonGrid grid, PointD offset, double epsilon) {
        PointD[] polygon;
        int y;
        int x;
        if (offset == null) {
            offset = PointD.EMPTY;
        }
        if (epsilon <= 0.0) {
            epsilon = grid.element().length * 1.0E-6;
        }
        int width = grid.size().width;
        int height = grid.size().height;
        PointD[][] polygons = new PointD[width * height][];
        PointD[] vertices = grid.element().vertices;
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                polygon = new PointD[vertices.length];
                PointD element = grid.gridToWorld(x, y);
                for (int i = 0; i < polygon.length; ++i) {
                    polygon[i] = vertices[i].add(element).add(offset);
                }
                polygons[x * height + y] = polygon;
            }
        }
        this._target = grid;
        this._source = Subdivision.fromPolygons(polygons, epsilon);
        this._faceToGrid = new PointI[width * height];
        this._gridToFace = new SubdivisionFace[width][height];
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                polygon = polygons[x * height + y];
                SubdivisionFace face = this._source.findFace(polygon, false);
                this._faceToGrid[face.key() - 1] = new PointI(x, y);
                this._gridToFace[x][y] = face;
            }
        }
    }

    @Override
    public Subdivision source() {
        return this._source;
    }

    @Override
    public PolygonGrid target() {
        return this._target;
    }

    @Override
    public PointI fromFace(SubdivisionFace face) {
        try {
            return this._faceToGrid[face.key() - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("face", e);
        }
    }

    @Override
    public SubdivisionFace toFace(PointI value) {
        try {
            return this._gridToFace[value.x][value.y];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("value", e);
        }
    }
}

