/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.Map;
import org.kynosarges.tektosyne.subdivision.SubdivisionEdge;

final class SplitEdgeResult {
    final SubdivisionEdge originEdge;
    final SubdivisionEdge destinationEdge;
    final SubdivisionEdge createdEdge;
    final boolean isEdgeDeleted;

    SplitEdgeResult(SubdivisionEdge originEdge, SubdivisionEdge destinationEdge, SubdivisionEdge createdEdge, boolean isEdgeDeleted) {
        if (originEdge == null) {
            throw new NullPointerException("originEdge");
        }
        if (destinationEdge == null) {
            throw new NullPointerException("destinationEdge");
        }
        this.originEdge = originEdge;
        this.destinationEdge = destinationEdge;
        this.createdEdge = createdEdge;
        this.isEdgeDeleted = isEdgeDeleted;
    }

    void updateFaces(SubdivisionEdge edge, Map<Integer, Integer> edgeToFace1, Map<Integer, Integer> edgeToFace2) {
        if (this.createdEdge == null) {
            return;
        }
        Integer face = edgeToFace1.get(edge._key);
        if (face != null) {
            edgeToFace1.put(this.createdEdge._key, face);
        }
        if ((face = edgeToFace2.get(edge._key)) != null) {
            edgeToFace2.put(this.createdEdge._key, face);
        }
        if ((face = edgeToFace1.get(this.createdEdge._twin._key)) != null) {
            edgeToFace1.put(edge._twin._key, face);
        }
        if ((face = edgeToFace2.get(this.createdEdge._twin._key)) != null) {
            edgeToFace2.put(edge._twin._key, face);
        }
    }
}

