/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineIntersection;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.LineRelation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparatorY;
import org.kynosarges.tektosyne.geometry.PolygonLocation;
import org.kynosarges.tektosyne.graph.Graph;
import org.kynosarges.tektosyne.subdivision.AddEdgeResult;
import org.kynosarges.tektosyne.subdivision.CreateEdgeResult;
import org.kynosarges.tektosyne.subdivision.EdgeCycle;
import org.kynosarges.tektosyne.subdivision.FindEdgeResult;
import org.kynosarges.tektosyne.subdivision.RemoveEdgeResult;
import org.kynosarges.tektosyne.subdivision.SplitEdgeResult;
import org.kynosarges.tektosyne.subdivision.SubdivisionEdge;
import org.kynosarges.tektosyne.subdivision.SubdivisionElement;
import org.kynosarges.tektosyne.subdivision.SubdivisionFace;
import org.kynosarges.tektosyne.subdivision.SubdivisionIntersection;

public class Subdivision
implements Graph<PointD> {
    public final double epsilon;
    private final NavigableMap<Integer, SubdivisionEdge> _edges;
    private final NavigableMap<Integer, SubdivisionFace> _faces;
    private final NavigableMap<PointD, SubdivisionEdge> _vertices;
    private final Map<PointD, PointD[]> _vertexRegions;
    private int _connectivity;
    private int _nextEdgeKey;
    private int _nextFaceKey;
    private double _cursorY;

    public Subdivision(double epsilon) {
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        this.epsilon = epsilon;
        this._edges = new TreeMap<Integer, SubdivisionEdge>();
        this._faces = new TreeMap<Integer, SubdivisionFace>();
        this._vertices = new TreeMap<PointD, SubdivisionEdge>(new PointDComparatorY(epsilon));
        this._vertexRegions = new HashMap<PointD, PointD[]>();
        SubdivisionFace face = new SubdivisionFace(this, this._nextFaceKey++);
        this._faces.put(face._key, face);
    }

    public NavigableMap<Integer, SubdivisionEdge> edges() {
        return Collections.unmodifiableNavigableMap(this._edges);
    }

    public NavigableMap<Integer, SubdivisionFace> faces() {
        return Collections.unmodifiableNavigableMap(this._faces);
    }

    public boolean isEmpty() {
        return this._edges.isEmpty();
    }

    public Map<PointD, PointD[]> vertexRegions() {
        return this._vertexRegions;
    }

    public NavigableMap<PointD, SubdivisionEdge> vertices() {
        return Collections.unmodifiableNavigableMap(this._vertices);
    }

    public AddEdgeResult addEdge(PointD start, PointD end) {
        int changedFace = -1;
        int addedFace = -1;
        if (start.equals(end)) {
            return new AddEdgeResult(null, changedFace, addedFace);
        }
        SubdivisionEdge startEdge = (SubdivisionEdge)this._vertices.get(start);
        SubdivisionEdge endEdge = (SubdivisionEdge)this._vertices.get(end);
        SubdivisionFace face = null;
        SubdivisionEdge nextStartEdge = null;
        SubdivisionEdge nextEndEdge = null;
        if (startEdge == null && endEdge == null) {
            face = this.findFace(start);
        } else {
            SubdivisionEdge previousStartEdge = null;
            SubdivisionEdge previousEndEdge = null;
            if (startEdge != null && endEdge != null) {
                for (SubdivisionEdge edge : startEdge.originEdges()) {
                    if (!edge._twin._origin.equals(end)) continue;
                    return null;
                }
            }
            if (startEdge != null) {
                SubdivisionEdge[] startNeighbors = startEdge.findEdgePosition(end);
                nextStartEdge = startNeighbors[0];
                previousStartEdge = startNeighbors[1];
                assert (nextStartEdge._previous == previousStartEdge._twin);
                face = nextStartEdge._face;
            }
            if (endEdge != null) {
                SubdivisionEdge[] endNeighbors = endEdge.findEdgePosition(start);
                nextEndEdge = endNeighbors[0];
                previousEndEdge = endNeighbors[1];
                assert (nextEndEdge._previous == previousEndEdge._twin);
                if (face == null) {
                    face = nextEndEdge._face;
                } else if (face != nextEndEdge._face) {
                    return null;
                }
            }
            assert (nextStartEdge != nextEndEdge);
            assert (previousStartEdge != previousEndEdge);
        }
        LineD line = new LineD(start, end);
        int startInnerCycle = -1;
        int endInnerCycle = -1;
        if (face._outerEdge != null) {
            SubdivisionEdge edge;
            edge = face._outerEdge;
            do {
                LineIntersection result;
                if (!(result = line.intersect(edge.toLine(), this.epsilon)).existsBetween()) continue;
                return null;
            } while ((edge = edge._next) != face._outerEdge);
        }
        if (face._innerEdges != null) {
            for (int i = 0; i < face._innerEdges.size(); ++i) {
                SubdivisionEdge innerEdge;
                SubdivisionEdge edge = innerEdge = face._innerEdges.get(i);
                do {
                    LineIntersection result;
                    if ((result = line.intersect(edge.toLine(), this.epsilon)).existsBetween()) {
                        return null;
                    }
                    if (edge == nextStartEdge) {
                        startInnerCycle = i;
                        continue;
                    }
                    if (edge != nextEndEdge) continue;
                    endInnerCycle = i;
                } while ((edge = edge._next) != innerEdge);
            }
        }
        CreateEdgeResult result = this.createTwinEdges(start, end);
        SubdivisionEdge newEdge = result.startEdge;
        newEdge._face = face;
        newEdge._twin._face = face;
        changedFace = face._key;
        if (startEdge == null && endEdge == null) {
            face.addInnerEdge(newEdge);
        } else if (startEdge != null && endEdge != null) {
            if (startInnerCycle != endInnerCycle) {
                if (endInnerCycle >= 0) {
                    face._innerEdges.remove(endInnerCycle);
                } else {
                    assert (startInnerCycle >= 0);
                    face._innerEdges.remove(startInnerCycle);
                }
            } else {
                SubdivisionEdge newFaceEdge;
                assert (startInnerCycle == endInnerCycle);
                if (startInnerCycle < 0) {
                    double edgeArea = newEdge.cycleArea();
                    double twinArea = newEdge._twin.cycleArea();
                    assert (edgeArea > 0.0 && twinArea > 0.0);
                    if (edgeArea < twinArea) {
                        newFaceEdge = newEdge;
                        face._outerEdge = newEdge._twin;
                    } else {
                        newFaceEdge = newEdge._twin;
                        face._outerEdge = newEdge;
                    }
                } else {
                    SubdivisionEdge pivot = newEdge;
                    for (SubdivisionEdge edge : newEdge.cycleEdges()) {
                        if (this._vertices.comparator().compare(pivot._origin, edge._origin) <= 0) continue;
                        pivot = edge;
                    }
                    double length = pivot._previous._origin.crossProductLength(pivot._origin, pivot._next._origin);
                    if (length > 0.0) {
                        newFaceEdge = newEdge;
                        face._innerEdges.set(startInnerCycle, newEdge._twin);
                    } else {
                        newFaceEdge = newEdge._twin;
                        face._innerEdges.set(startInnerCycle, newEdge);
                    }
                }
                SubdivisionFace newFace = new SubdivisionFace(this, this._nextFaceKey++, newFaceEdge, null);
                this._faces.put(newFace._key, newFace);
                newFaceEdge.setAllFaces(newFace);
                addedFace = newFace._key;
                if (face._innerEdges != null) {
                    int count = face._innerEdges.size();
                    for (int i = count - 1; i >= 0; --i) {
                        if (startInnerCycle == i) continue;
                        SubdivisionEdge innerEdge = face._innerEdges.get(i);
                        PolygonLocation location = newFaceEdge.locate(innerEdge._origin);
                        if (location != PolygonLocation.INSIDE) continue;
                        face._innerEdges.remove(i);
                        newFace.addInnerEdge(innerEdge);
                    }
                    if (face._innerEdges.isEmpty()) {
                        face._innerEdges = null;
                    }
                }
            }
        }
        this._connectivity = 0;
        return new AddEdgeResult(newEdge, changedFace, addedFace);
    }

    public Subdivision copy() {
        Subdivision division = new Subdivision(this.epsilon);
        division._connectivity = this._connectivity;
        division._nextEdgeKey = this._nextEdgeKey;
        division._nextFaceKey = this._nextFaceKey;
        for (SubdivisionEdge oldEdge : this._edges.values()) {
            SubdivisionEdge newEdge = new SubdivisionEdge(oldEdge._key);
            division._edges.put(newEdge._key, newEdge);
            newEdge._origin = oldEdge._origin;
        }
        for (SubdivisionEdge oldEdge : this._vertices.values()) {
            division._vertices.put(oldEdge._origin, (SubdivisionEdge)division._edges.get(oldEdge._key));
        }
        SubdivisionFace oldFace = (SubdivisionFace)this._faces.get(0);
        if (oldFace._innerEdges != null) {
            SubdivisionFace newFace = (SubdivisionFace)division._faces.get(0);
            newFace._innerEdges = new ArrayList<SubdivisionEdge>(oldFace._innerEdges.size());
            for (SubdivisionEdge oldEdge : oldFace._innerEdges) {
                newFace._innerEdges.add((SubdivisionEdge)division._edges.get(oldEdge._key));
            }
        }
        Iterator<Object> iterator = this._faces.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            if (key == 0) continue;
            oldFace = (SubdivisionFace)this._faces.get(key);
            SubdivisionFace newFace = new SubdivisionFace(division, key);
            division._faces.put(key, newFace);
            newFace._outerEdge = (SubdivisionEdge)division._edges.get(oldFace._outerEdge._key);
            if (oldFace._innerEdges == null) continue;
            newFace._innerEdges = new ArrayList<SubdivisionEdge>(oldFace._innerEdges.size());
            for (SubdivisionEdge oldEdge : oldFace._innerEdges) {
                newFace._innerEdges.add((SubdivisionEdge)division._edges.get(oldEdge._key));
            }
        }
        for (SubdivisionEdge newEdge : division._edges.values()) {
            SubdivisionEdge oldEdge;
            oldEdge = (SubdivisionEdge)this._edges.get(newEdge._key);
            newEdge._face = (SubdivisionFace)division._faces.get(oldEdge._face._key);
            newEdge._twin = (SubdivisionEdge)division._edges.get(oldEdge._twin._key);
            newEdge._next = (SubdivisionEdge)division._edges.get(oldEdge._next._key);
            newEdge._previous = (SubdivisionEdge)division._edges.get(oldEdge._previous._key);
        }
        return division;
    }

    public SubdivisionElement find(PointD q, double epsilon) {
        if (q == null) {
            throw new NullPointerException("q");
        }
        if (epsilon < 0.0) {
            throw new IllegalArgumentException("epsilon < 0");
        }
        SubdivisionFace face = this.findFace(q);
        if (face._outerEdge != null) {
            SubdivisionEdge edge = face._outerEdge;
            do {
                LineD line = edge.toLine();
                LineLocation location = epsilon == 0.0 ? line.locate(q) : line.locate(q, epsilon);
                switch (location) {
                    case START: {
                        return new SubdivisionElement(line.start);
                    }
                    case END: {
                        return new SubdivisionElement(line.end);
                    }
                    case BETWEEN: {
                        return new SubdivisionElement(edge);
                    }
                }
            } while ((edge = edge._next) != face._outerEdge);
        }
        if (face._innerEdges != null) {
            Iterator<SubdivisionEdge> iterator = face._innerEdges.iterator();
            while (iterator.hasNext()) {
                SubdivisionEdge innerEdge;
                SubdivisionEdge edge = innerEdge = iterator.next();
                do {
                    LineD line = edge.toLine();
                    LineLocation location = epsilon == 0.0 ? line.locate(q) : line.locate(q, epsilon);
                    switch (location) {
                        case START: {
                            return new SubdivisionElement(line.start);
                        }
                        case END: {
                            return new SubdivisionElement(line.end);
                        }
                        case BETWEEN: {
                            return new SubdivisionElement(edge);
                        }
                    }
                } while ((edge = edge._next) != innerEdge);
            }
        }
        return new SubdivisionElement(face);
    }

    public SubdivisionEdge findEdge(PointD origin, PointD destination) {
        SubdivisionEdge edge = (SubdivisionEdge)this._vertices.get(origin);
        if (edge == null) {
            return null;
        }
        return this.epsilon == 0.0 ? edge.findEdgeTo(destination) : edge.findEdgeTo(destination, this.epsilon);
    }

    public SubdivisionFace findFace(PointD q) {
        if (q == null) {
            throw new NullPointerException("q");
        }
        SubdivisionFace resultFace = null;
        double resultArea = 0.0;
        for (SubdivisionFace face : this._faces.values()) {
            PolygonLocation location;
            if (face._outerEdge == null || (location = face._outerEdge.locate(q)) == PolygonLocation.OUTSIDE) continue;
            if (face._innerEdges == null) {
                return face;
            }
            if (resultFace == null) {
                resultFace = face;
                continue;
            }
            double area = face._outerEdge.cycleArea();
            if (resultArea == 0.0) {
                resultArea = resultFace._outerEdge.cycleArea();
            }
            if (!(resultArea > area)) continue;
            resultArea = area;
            resultFace = face;
        }
        return resultFace == null ? (SubdivisionFace)this._faces.get(0) : resultFace;
    }

    public SubdivisionFace findFace(PointD[] polygon, boolean verify) {
        if (polygon == null) {
            throw new NullPointerException("polygon");
        }
        if (polygon.length < 3) {
            throw new IllegalArgumentException("polygon.length < 3");
        }
        SubdivisionEdge edge = this.findEdge(polygon[polygon.length - 1], polygon[0]);
        if (edge == null) {
            return null;
        }
        SubdivisionFace face = edge._face;
        SubdivisionFace twinFace = edge._twin._face;
        boolean isOuter = edge == face._outerEdge;
        boolean isTwinOuter = edge._twin == twinFace._outerEdge;
        for (int i = 1; i < polygon.length; ++i) {
            SubdivisionEdge subdivisionEdge = edge = this.epsilon == 0.0 ? edge._twin.findEdgeTo(polygon[i]) : edge._twin.findEdgeTo(polygon[i], this.epsilon);
            if (edge == null) {
                return null;
            }
            if (face != null) {
                if (face != edge._face) {
                    if (!verify) {
                        return twinFace;
                    }
                    face = null;
                    if (twinFace == null) {
                        return null;
                    }
                } else {
                    isOuter |= edge == face._outerEdge;
                }
            }
            if (twinFace == null) continue;
            if (twinFace != edge._twin._face) {
                if (!verify) {
                    return face;
                }
                twinFace = null;
                if (face != null) continue;
                return null;
            }
            isTwinOuter |= edge._twin == twinFace._outerEdge;
        }
        if (face == null) {
            assert (twinFace != null);
            return isTwinOuter ? twinFace : null;
        }
        if (twinFace == null) {
            return isOuter ? face : null;
        }
        if (isOuter) {
            return face;
        }
        if (isTwinOuter) {
            return twinFace;
        }
        return null;
    }

    public FindEdgeResult findNearestEdge(PointD q) {
        SubdivisionFace face = this.findFace(q);
        return face.findNearestEdge(q);
    }

    public PointD findNearestVertex(PointD q) {
        return ((PointDComparatorY)this._vertices.comparator()).findNearest(this._vertices.navigableKeySet(), q);
    }

    public static Subdivision fromLines(LineD[] lines, double epsilon) {
        if (lines == null) {
            throw new NullPointerException("lines");
        }
        Subdivision division = new Subdivision(epsilon);
        if (lines.length > 0) {
            division.createAllFromLines(lines);
        }
        return division;
    }

    public static Subdivision fromPolygons(PointD[][] polygons, double epsilon) {
        if (polygons == null) {
            throw new NullPointerException("polygons");
        }
        Subdivision division = new Subdivision(epsilon);
        if (polygons.length != 0) {
            division.createAllFromPolygons(polygons);
        }
        return division;
    }

    public SubdivisionEdge[] getEdgesByOrigin() {
        SubdivisionEdge[] edges = new SubdivisionEdge[this._edges.size()];
        int edgeIndex = 0;
        Iterator iterator = this._vertices.values().iterator();
        while (iterator.hasNext()) {
            SubdivisionEdge firstEdge;
            SubdivisionEdge edge = firstEdge = (SubdivisionEdge)iterator.next();
            do {
                edges[edgeIndex++] = edge;
            } while ((edge = edge._twin._next) != firstEdge);
        }
        assert (edgeIndex == edges.length);
        return edges;
    }

    public List<SubdivisionEdge> getZeroAreaCycles() {
        ArrayList<SubdivisionEdge> cycles = new ArrayList<SubdivisionEdge>();
        for (SubdivisionFace face : this._faces.values()) {
            if (face._innerEdges == null) continue;
            for (SubdivisionEdge edge : face._innerEdges) {
                if (!edge.isCycleAreaZero()) continue;
                cycles.add(edge);
            }
        }
        return cycles;
    }

    public static SubdivisionIntersection intersection(Subdivision division1, Subdivision division2) {
        if (division1.epsilon > division2.epsilon) {
            throw new IllegalArgumentException("division1.epsilon > division2.epsilon");
        }
        int capacity = division1._edges.size() + division2._edges.size();
        HashMap<Integer, Integer> edgeToFace1 = new HashMap<Integer, Integer>(capacity);
        HashMap<Integer, Integer> edgeToFace2 = new HashMap<Integer, Integer>(capacity);
        for (SubdivisionEdge edge : division1._edges.values()) {
            edgeToFace1.put(edge._key, edge._face._key);
        }
        Subdivision division = division1.copyEdges();
        division.intersectEdges(division2, edgeToFace1, edgeToFace2);
        List<EdgeCycle>[] cycles = division.findCycles();
        division.createFacesFromCycles(cycles[0], cycles[1]);
        int[] faceKeys1 = new int[division._faces.size()];
        int[] faceKeys2 = new int[division._faces.size()];
        Arrays.fill(faceKeys1, 1, faceKeys1.length, -1);
        Arrays.fill(faceKeys2, 1, faceKeys2.length, -1);
        for (SubdivisionEdge edge : division._edges.values()) {
            int oldFace;
            int newFace = edge._face._key;
            if (newFace == 0) {
                assert (faceKeys1[newFace] == 0);
                assert (faceKeys2[newFace] == 0);
                continue;
            }
            if (faceKeys1[newFace] < 0) {
                faceKeys1[newFace] = oldFace = division1.findInputFace(edge, edgeToFace1);
                assert (oldFace >= 0 && oldFace < division1.faces().size());
                assert (Subdivision.checkCycleFaces(edge, oldFace, edgeToFace1));
            }
            if (faceKeys2[newFace] >= 0) continue;
            faceKeys2[newFace] = oldFace = division2.findInputFace(edge, edgeToFace2);
            assert (oldFace >= 0 && oldFace < division2.faces().size());
            assert (Subdivision.checkCycleFaces(edge, oldFace, edgeToFace2));
        }
        division._connectivity = 0;
        return new SubdivisionIntersection(division, faceKeys1, faceKeys2);
    }

    public boolean moveVertex(PointD oldVertex, PointD newVertex) {
        if (this._vertices.containsKey(newVertex)) {
            return false;
        }
        int capacity = this._connectivity > 0 ? this._connectivity : 8;
        ArrayList<SubdivisionEdge> oldEdges = new ArrayList<SubdivisionEdge>(capacity);
        ArrayList<SubdivisionFace> faces = new ArrayList<SubdivisionFace>(capacity);
        SubdivisionEdge oldEdge = (SubdivisionEdge)this._vertices.get(oldVertex);
        for (SubdivisionEdge edge : oldEdge.originEdges()) {
            oldEdges.add(edge);
            if (faces.contains(edge._face)) continue;
            faces.add(edge._face);
        }
        LineD[] newEdges = new LineD[oldEdges.size()];
        for (int i = 0; i < newEdges.length; ++i) {
            newEdges[i] = new LineD(newVertex, ((SubdivisionEdge)oldEdges.get((int)i))._twin._origin);
        }
        for (SubdivisionFace face : faces) {
            for (SubdivisionEdge edge : face.allCycleEdges()) {
                if (oldEdges.contains(edge) || oldEdges.contains(edge._twin)) continue;
                LineD edgeLine = edge.toLine();
                for (LineD line : newEdges) {
                    LineIntersection result = line.intersect(edgeLine, this.epsilon);
                    if (!result.existsBetween()) continue;
                    return false;
                }
            }
        }
        this._vertices.remove(oldVertex);
        this._vertices.put(newVertex, oldEdge);
        for (SubdivisionEdge edge : oldEdges) {
            edge._origin = newVertex;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public RemoveEdgeResult removeEdge(int edgeKey) {
        block27: {
            block29: {
                block28: {
                    block26: {
                        changedFace = -1;
                        removedFace = -1;
                        edge = (SubdivisionEdge)this._edges.get(edgeKey);
                        if (edge == null) {
                            return new RemoveEdgeResult(changedFace, removedFace);
                        }
                        twin = edge._twin;
                        if (edge._face != twin._face) break block26;
                        changedFace = edge._face._key;
                        edge._face.moveEdge(edge);
                        break block27;
                    }
                    if (edge._face._key < twin._face._key) {
                        e0 = edge;
                        e1 = twin;
                    } else {
                        e0 = twin;
                        e1 = edge;
                    }
                    e1Face = e1._face;
                    if (e1Face._innerEdges != null) break block28;
                    if (!Subdivision.$assertionsDisabled && e1Face._outerEdge == null) {
                        throw new AssertionError();
                    }
                    break block29;
                }
                if (e1Face._outerEdge == null) ** GOTO lbl30
                cursor = e1;
                while (cursor != e1Face._outerEdge) {
                    cursor = cursor._next;
                    if (cursor != e1) continue;
lbl30:
                    // 2 sources

                    e1Face = e0._face;
                    e0 = e1;
                    break;
                }
            }
            e0._face.moveEdge(e0);
            e0._face.addInnerEdges(e1Face._innerEdges);
            e1Face.setAllEdgeFaces(e0._face);
            changedFace = e0._face._key;
            removedFace = e1Face._key;
            this._faces.remove(removedFace);
        }
        this.removeAtOrigin(edge);
        this.removeAtOrigin(twin);
        if (removedFace < 0 && edge._next != twin && edge._previous != twin) {
            outerEdge = edge._face._outerEdge;
            innerEdges = edge._face._innerEdges;
            nextCursor = edge._next;
            prevCursor = edge._previous;
            nextPivot = nextCursor._origin;
            prevPivot = prevCursor._origin;
            nextIsOuter = false;
            prevIsOuter = false;
            vertexComparer = (PointDComparatorY)this._vertices.comparator();
            do {
                if (nextCursor != null) {
                    if (!nextIsOuter && !prevIsOuter) {
                        if (outerEdge == nextCursor) {
                            nextIsOuter = true;
                        } else if (innerEdges != null && innerEdges.contains(nextCursor)) {
                            edge._face.addInnerEdge(edge._previous);
                            break;
                        }
                    }
                    if (nextCursor == twin._previous) {
                        nextCursor = null;
                    } else {
                        nextCursor = nextCursor._next;
                        if (vertexComparer.compare(nextPivot, nextCursor._origin) > 0) {
                            nextPivot = nextCursor._origin;
                        }
                    }
                }
                if (prevCursor == null) continue;
                if (!nextIsOuter && !prevIsOuter) {
                    if (outerEdge == prevCursor) {
                        prevIsOuter = true;
                    } else if (innerEdges != null && innerEdges.contains(prevCursor)) {
                        edge._face.addInnerEdge(edge._next);
                        break;
                    }
                }
                if (prevCursor == twin._next) {
                    prevCursor = null;
                    continue;
                }
                prevCursor = prevCursor._previous;
                if (vertexComparer.compare(prevPivot, prevCursor._origin) <= 0) continue;
                prevPivot = prevCursor._origin;
            } while (nextCursor != null || prevCursor != null);
            if (nextIsOuter || prevIsOuter) {
                pivotCompare = vertexComparer.compare(nextPivot, prevPivot);
                if (pivotCompare < 0) {
                    if (prevIsOuter) {
                        edge._face._outerEdge = edge._next;
                    }
                    edge._face.addInnerEdge(edge._previous);
                } else {
                    if (!Subdivision.$assertionsDisabled && pivotCompare <= 0) {
                        throw new AssertionError();
                    }
                    if (nextIsOuter) {
                        edge._face._outerEdge = edge._previous;
                    }
                    edge._face.addInnerEdge(edge._next);
                }
            }
        }
        this._edges.remove(edgeKey);
        this._edges.remove(twin._key);
        this._connectivity = 0;
        return new RemoveEdgeResult(changedFace, removedFace);
    }

    public boolean removeVertex(PointD vertex) {
        SubdivisionEdge edge1 = (SubdivisionEdge)this._vertices.get(vertex);
        if (edge1 == null) {
            return false;
        }
        SubdivisionEdge twin1 = edge1._twin;
        SubdivisionEdge edge2 = twin1._next;
        SubdivisionEdge twin2 = edge2._twin;
        if (edge1 == edge2 || edge1._previous != twin2) {
            return false;
        }
        for (SubdivisionEdge edge : twin1.originEdges()) {
            if (edge._twin._origin != twin2._origin) continue;
            return false;
        }
        if (!twin1.isCompatibleDestination(twin2._origin) || !twin2.isCompatibleDestination(twin1._origin)) {
            return false;
        }
        double length = twin2._origin.crossProductLength(edge1._origin, twin1._origin);
        if (Math.abs(length) > this.epsilon) {
            SubdivisionFace face = length < 0.0 ? edge2._face : edge1._face;
            LineD line = new LineD(twin2._origin, twin1._origin);
            for (SubdivisionEdge edge : face.allCycleEdges()) {
                LineIntersection result;
                if (edge == edge1 || edge == twin1 || edge == edge2 || edge == twin2 || !(result = line.intersect(edge.toLine(), this.epsilon)).existsBetween()) continue;
                return false;
            }
        }
        edge1._face.moveEdge(edge1, twin2);
        edge2._face.moveEdge(edge2, twin1);
        twin1._twin = twin2;
        twin1._next = edge2._next;
        edge2._next._previous = twin1;
        twin2._twin = twin1;
        twin2._next = edge1._next;
        edge1._next._previous = twin2;
        this._edges.remove(edge1._key);
        this._edges.remove(edge2._key);
        this._vertices.remove(vertex);
        if (this._connectivity == 2) {
            this._connectivity = 0;
        }
        return true;
    }

    public boolean renumberEdges() {
        if (this._edges.size() == this._nextEdgeKey) {
            return false;
        }
        SubdivisionEdge[] edges = new SubdivisionEdge[this._edges.size()];
        int key = 0;
        for (SubdivisionEdge edge : this._edges.values()) {
            assert (edge._key >= key);
            edges[key] = edge;
            edge._key = key++;
        }
        this._edges.clear();
        for (SubdivisionEdge edge : edges) {
            this._edges.put(edge._key, edge);
        }
        this._nextEdgeKey = edges.length;
        return true;
    }

    public boolean renumberFaces() {
        if (this._faces.size() == this._nextFaceKey) {
            return false;
        }
        SubdivisionFace[] faces = new SubdivisionFace[this._faces.size()];
        int key = 0;
        for (SubdivisionFace face : this._faces.values()) {
            assert (face._key >= key);
            faces[key] = face;
            face._key = key++;
        }
        this._faces.clear();
        for (SubdivisionFace face : faces) {
            this._faces.put(face._key, face);
        }
        this._nextFaceKey = faces.length;
        return true;
    }

    public SubdivisionEdge splitEdge(int edgeKey) {
        SubdivisionEdge edge = (SubdivisionEdge)this._edges.get(edgeKey);
        if (edge == null) {
            return null;
        }
        PointD a = edge._origin;
        PointD b = edge._twin._origin;
        PointD vertex = new PointD((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
        if (this._vertices.containsKey(vertex)) {
            return null;
        }
        if (this._connectivity < 2) {
            this._connectivity = 2;
        }
        return this.splitEdgeAtVertex(edge, vertex, true);
    }

    public boolean structureEquals(Subdivision division) {
        if (this._nextEdgeKey != division._nextEdgeKey) {
            return false;
        }
        if (this._nextFaceKey != division._nextFaceKey) {
            return false;
        }
        if (this._faces.size() != division._faces.size()) {
            return false;
        }
        if (this._vertices.size() != division._vertices.size()) {
            return false;
        }
        for (PointD key : this._vertices.keySet()) {
            SubdivisionEdge otherEdge;
            SubdivisionEdge edge = (SubdivisionEdge)this._vertices.get(key);
            if (edge.equals(otherEdge = (SubdivisionEdge)division._vertices.get(key))) continue;
            return false;
        }
        Iterator iterator = this._faces.keySet().iterator();
        while (iterator.hasNext()) {
            SubdivisionFace otherFace;
            int key = (Integer)iterator.next();
            SubdivisionFace face = (SubdivisionFace)this._faces.get(key);
            if (face.equals(otherFace = (SubdivisionFace)division._faces.get(key))) continue;
            return false;
        }
        return true;
    }

    public LineD[] toLines() {
        LineD[] lines = new LineD[this._edges.size() / 2];
        int lineIndex = 0;
        for (SubdivisionEdge edge : this._edges.values()) {
            SubdivisionEdge twin = edge._twin;
            if (edge._key >= twin._key) continue;
            lines[lineIndex++] = new LineD(edge._origin, twin._origin);
        }
        assert (lineIndex == lines.length);
        return lines;
    }

    public PointD[][] toPolygons() {
        PointD[][] polygons = new PointD[this._faces.size() - 1][];
        int faceIndex = 0;
        for (SubdivisionFace face : this._faces.values()) {
            if (face._key <= 0) continue;
            polygons[faceIndex++] = face._outerEdge.cyclePolygon();
        }
        assert (faceIndex == polygons.length);
        return polygons;
    }

    public void validate() {
        SubdivisionEdge edge;
        boolean isEmpty = this._edges.isEmpty();
        assert (((PointDComparatorY)this._vertices.comparator()).epsilon == this.epsilon);
        assert (this._edges.size() % 2 == 0);
        assert (isEmpty && this._vertices.isEmpty() || !isEmpty && this._vertices.size() >= 2);
        assert (!this._faces.isEmpty());
        assert ((Integer)this._faces.firstKey() == 0);
        SubdivisionFace faceZero = (SubdivisionFace)this._faces.get(0);
        assert (faceZero._outerEdge == null);
        assert (isEmpty && faceZero._innerEdges == null || !isEmpty && faceZero._innerEdges != null);
        assert (faceZero._innerEdges == null || !faceZero._innerEdges.isEmpty());
        for (Map.Entry entry : this._edges.entrySet()) {
            SubdivisionEdge edge2 = (SubdivisionEdge)entry.getValue();
            assert ((Integer)entry.getKey() == edge2._key);
            assert (edge2._face != null);
            assert (edge2._face.owner == this);
            assert (edge2._twin._twin == edge2);
            assert (edge2._next._previous == edge2);
            assert (edge2._previous._next == edge2);
        }
        for (Map.Entry entry : this._vertices.entrySet()) {
            PointD vertex = (PointD)entry.getKey();
            edge = (SubdivisionEdge)entry.getValue();
            do {
                assert (edge._origin.equals(vertex));
            } while ((edge = edge._twin._next) != entry.getValue());
            do {
                assert (edge._origin.equals(vertex));
            } while ((edge = edge._previous._twin) != entry.getValue());
        }
        for (Map.Entry entry : this._faces.entrySet()) {
            SubdivisionFace face = (SubdivisionFace)entry.getValue();
            assert ((Integer)entry.getKey() == face._key);
            assert (face.owner == this);
            if (face._outerEdge != null) {
                edge = face._outerEdge;
                do {
                    assert (edge._face == face);
                } while ((edge = edge._next) != face._outerEdge);
                do {
                    assert (edge._face == face);
                } while ((edge = edge._previous) != face._outerEdge);
            }
            if (face._innerEdges == null) continue;
            Iterator<SubdivisionEdge> iterator = face._innerEdges.iterator();
            while (iterator.hasNext()) {
                SubdivisionEdge innerEdge;
                SubdivisionEdge edge3 = innerEdge = iterator.next();
                do {
                    assert (edge3._face == face);
                } while ((edge3 = edge3._next) != innerEdge);
                do {
                    assert (edge3._face == face);
                } while ((edge3 = edge3._previous) != innerEdge);
            }
        }
    }

    @Override
    public int connectivity() {
        if (this._connectivity == 0 && !this._vertices.isEmpty()) {
            for (SubdivisionEdge firstEdge : this._vertices.values()) {
                int count = 0;
                SubdivisionEdge edge = firstEdge;
                do {
                    ++count;
                } while ((edge = edge._twin._next) != firstEdge);
                if (this._connectivity >= count) continue;
                this._connectivity = count;
            }
        }
        return this._connectivity;
    }

    @Override
    public int nodeCount() {
        return this._vertices.size();
    }

    @Override
    public Set<PointD> nodes() {
        return this._vertices.keySet();
    }

    @Override
    public boolean contains(PointD node) {
        return this._vertices.containsKey(node);
    }

    @Override
    public PointD findNearestNode(PointD location) {
        return this.findNearestVertex(location);
    }

    @Override
    public double getDistance(PointD source, PointD target) {
        double dx = target.x - source.x;
        double dy = target.y - source.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public List<PointD> getNeighbors(PointD node) {
        SubdivisionEdge twin;
        SubdivisionEdge firstEdge = (SubdivisionEdge)this._vertices.get(node);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<PointD> neighbors = new ArrayList<PointD>(this.connectivity());
        SubdivisionEdge edge = firstEdge;
        do {
            twin = edge._twin;
            neighbors.add(twin._origin);
        } while ((edge = twin._next) != firstEdge);
        return neighbors;
    }

    @Override
    public PointD getWorldLocation(PointD node) {
        return node;
    }

    @Override
    public PointD[] getWorldRegion(PointD node) {
        return this._vertexRegions.get(node);
    }

    private static boolean checkCycleFaces(SubdivisionEdge edge, int face, Map<Integer, Integer> edgeToFace) {
        SubdivisionEdge cycle = edge;
        do {
            Integer mapFace;
            if ((mapFace = edgeToFace.get(cycle._key)) == null || mapFace == face) continue;
            return false;
        } while ((cycle = cycle._next) != edge);
        return true;
    }

    private Subdivision copyEdges() {
        Subdivision division = new Subdivision(this.epsilon);
        division._connectivity = this._connectivity;
        division._nextEdgeKey = this._nextEdgeKey;
        for (SubdivisionEdge oldEdge : this._edges.values()) {
            SubdivisionEdge newEdge = new SubdivisionEdge(oldEdge._key);
            division._edges.put(newEdge._key, newEdge);
            newEdge._origin = oldEdge._origin;
        }
        for (SubdivisionEdge oldEdge : this._vertices.values()) {
            division._vertices.put(oldEdge._origin, (SubdivisionEdge)division._edges.get(oldEdge._key));
        }
        for (SubdivisionEdge newEdge : division._edges.values()) {
            SubdivisionEdge oldEdge = (SubdivisionEdge)this._edges.get(newEdge._key);
            newEdge._twin = (SubdivisionEdge)division._edges.get(oldEdge._twin._key);
            newEdge._next = (SubdivisionEdge)division._edges.get(oldEdge._next._key);
            newEdge._previous = (SubdivisionEdge)division._edges.get(oldEdge._previous._key);
        }
        return division;
    }

    private int compareEdges(SubdivisionEdge a, SubdivisionEdge b) {
        double bx;
        double ax;
        if (a == b) {
            return 0;
        }
        LineD aLine = a.toLine();
        LineD bLine = b.toLine();
        double aSlope = aLine.inverseSlope();
        double bSlope = bLine.inverseSlope();
        if (this._cursorY == aLine.end.y || aSlope == Double.MAX_VALUE) {
            ax = aLine.end.x;
        } else if (this._cursorY == aLine.start.y) {
            ax = aLine.start.x;
            aSlope = -aSlope;
        } else {
            ax = aLine.start.x + (this._cursorY - aLine.start.y) * aSlope;
        }
        if (this._cursorY == bLine.end.y || bSlope == Double.MAX_VALUE) {
            bx = bLine.end.x;
        } else if (this._cursorY == bLine.start.y) {
            bx = bLine.start.x;
            bSlope = -bSlope;
        } else {
            bx = bLine.start.x + (this._cursorY - bLine.start.y) * bSlope;
        }
        if (ax < bx) {
            return -1;
        }
        if (ax > bx) {
            return 1;
        }
        if (aSlope < bSlope) {
            return -1;
        }
        if (aSlope > bSlope) {
            return 1;
        }
        return a._key - b._key;
    }

    private void createAllFromLines(LineD[] lines) {
        assert (this._edges.isEmpty());
        assert (this._faces.size() == 1);
        assert (this._vertices.isEmpty());
        for (LineD line : lines) {
            this.createTwinEdges(line.start, line.end);
        }
        List<EdgeCycle>[] cycles = this.findCycles();
        this.createFacesFromCycles(cycles[0], cycles[1]);
    }

    private void createAllFromPolygons(PointD[][] polygons) {
        assert (this._edges.isEmpty());
        assert (this._faces.size() == 1);
        assert (this._vertices.isEmpty());
        for (PointD[] polygon : polygons) {
            for (int j = 0; j < polygon.length; ++j) {
                PointD start = polygon[j];
                PointD end = polygon[(j + 1) % polygon.length];
                this.createTwinEdges(start, end);
            }
        }
        List<EdgeCycle>[] cycles = this.findCycles();
        this.createFacesFromCycles(cycles[0], cycles[1]);
    }

    private void createFacesFromCycles(List<EdgeCycle> innerCycles, List<EdgeCycle> outerCycles) {
        assert (this._faces.size() == 1);
        SubdivisionFace face = (SubdivisionFace)this._faces.get(0);
        for (int i = 0; i < innerCycles.size(); ++i) {
            EdgeCycle cycle = innerCycles.get(i);
            while (cycle != null) {
                cycle.addToFace(face, false);
                cycle = cycle.next;
            }
        }
        for (EdgeCycle cycle : outerCycles) {
            face = new SubdivisionFace(this, this._nextFaceKey++);
            this._faces.put(face._key, face);
            cycle.addToFace(face, true);
            cycle = cycle.next;
            while (cycle != null) {
                cycle.addToFace(face, false);
                cycle = cycle.next;
            }
        }
    }

    private CreateEdgeResult createTwinEdges(PointD start, PointD end) {
        SubdivisionEdge startEdge;
        if (start.equals(end)) {
            throw new IllegalArgumentException("start == end");
        }
        SubdivisionEdge oldStartEdge = (SubdivisionEdge)this._vertices.get(start);
        SubdivisionEdge oldEndEdge = (SubdivisionEdge)this._vertices.get(end);
        if (oldStartEdge != null && oldEndEdge != null) {
            startEdge = oldStartEdge;
            do {
                if (startEdge._twin._origin != oldEndEdge._origin) continue;
                return new CreateEdgeResult(startEdge, false);
            } while ((startEdge = startEdge._twin._next) != oldStartEdge);
        }
        startEdge = new SubdivisionEdge(this._nextEdgeKey++);
        this._edges.put(startEdge._key, startEdge);
        SubdivisionEdge endEdge = new SubdivisionEdge(this._nextEdgeKey++);
        this._edges.put(endEdge._key, endEdge);
        startEdge._twin = endEdge;
        endEdge._twin = startEdge;
        startEdge._next = startEdge._previous = endEdge;
        endEdge._next = endEdge._previous = startEdge;
        if (oldStartEdge == null) {
            startEdge._origin = start;
            this._vertices.put(start, startEdge);
        } else {
            startEdge._origin = oldStartEdge._origin;
        }
        if (oldEndEdge == null) {
            endEdge._origin = end;
            this._vertices.put(end, endEdge);
        } else {
            endEdge._origin = oldEndEdge._origin;
        }
        if (oldStartEdge != null) {
            Subdivision.insertAtEdge(startEdge, oldStartEdge);
        }
        if (oldEndEdge != null) {
            Subdivision.insertAtEdge(endEdge, oldEndEdge);
        }
        return new CreateEdgeResult(startEdge, true);
    }

    private List<EdgeCycle>[] findCycles() {
        PointDComparatorY vertexComparer = (PointDComparatorY)this._vertices.comparator();
        HashMap<Integer, EdgeCycle> edgeToCycle = new HashMap<Integer, EdgeCycle>(this._edges.size());
        HashMap<PointD, EdgeCycle> pivotToInnerCycle = new HashMap<PointD, EdgeCycle>(this._edges.size() / 4);
        ArrayList<EdgeCycle> outerCycles = new ArrayList<EdgeCycle>(this._edges.size() / 4);
        HashSet<Integer> cycleTwinEdges = new HashSet<Integer>();
        HashMap<Integer, SubdivisionEdge> edgeQueue = new HashMap<Integer, SubdivisionEdge>(this._edges);
        while (edgeQueue.size() > 0) {
            boolean isInnerCycle;
            SubdivisionEdge edge;
            SubdivisionEdge pivot = edge = (SubdivisionEdge)edgeQueue.values().iterator().next();
            EdgeCycle cycle = new EdgeCycle(edge);
            cycleTwinEdges.clear();
            int cycleTwinCount = 0;
            do {
                edgeToCycle.put(edge._key, cycle);
                if (cycleTwinEdges.contains(edge._twin._key)) {
                    ++cycleTwinCount;
                } else {
                    cycleTwinEdges.add(edge._key);
                }
                edgeQueue.remove(edge._key);
                edge = edge._next;
                if (vertexComparer.compare(pivot._origin, edge._origin) <= 0) continue;
                pivot = edge;
            } while (edge != cycle.firstEdge);
            if (cycleTwinCount == cycleTwinEdges.size()) {
                isInnerCycle = true;
            } else {
                double length = pivot._previous._origin.crossProductLength(pivot._origin, pivot._next._origin);
                boolean bl = isInnerCycle = length <= 0.0;
            }
            if (isInnerCycle) {
                pivotToInnerCycle.put(pivot._origin, cycle);
                continue;
            }
            outerCycles.add(cycle);
        }
        ArrayList<EdgeCycle> innerCycles = new ArrayList<EdgeCycle>(pivotToInnerCycle.size());
        int innerCyclesFound = 0;
        TreeSet<SubdivisionEdge> sweepLine = new TreeSet<SubdivisionEdge>(this::compareEdges);
        for (SubdivisionEdge firstEdge : this._vertices.values()) {
            this._cursorY = firstEdge._origin.y;
            EdgeCycle innerCycle = (EdgeCycle)pivotToInnerCycle.get(firstEdge._origin);
            if (innerCycle != null) {
                SubdivisionEdge leftNode = sweepLine.floor(firstEdge._twin);
                if (leftNode != null) {
                    EdgeCycle leftCycle = (EdgeCycle)edgeToCycle.get(leftNode._key);
                    innerCycle.next = leftCycle.next;
                    leftCycle.next = innerCycle;
                } else {
                    innerCycles.add(innerCycle);
                }
                if (++innerCyclesFound == pivotToInnerCycle.size()) break;
            }
            SubdivisionEdge edge = firstEdge;
            do {
                SubdivisionEdge downEdge;
                int direction = vertexComparer.compare(edge._origin, edge._twin._origin);
                assert (direction != 0);
                SubdivisionEdge subdivisionEdge = downEdge = direction < 0 ? edge._twin : edge;
                if (downEdge._origin.equals(firstEdge._origin)) {
                    assert (sweepLine.contains(downEdge));
                    sweepLine.remove(downEdge);
                    continue;
                }
                assert (downEdge._twin._origin.equals(firstEdge._origin));
                sweepLine.add(downEdge);
            } while ((edge = edge._twin._next) != firstEdge);
        }
        assert (innerCyclesFound == pivotToInnerCycle.size());
        assert (!innerCycles.isEmpty());
        List[] result = new List[]{innerCycles, outerCycles};
        return result;
    }

    private static Integer findCycleFace(SubdivisionEdge edge, Map<Integer, Integer> edgeToFace) {
        SubdivisionEdge cycle = edge;
        do {
            Integer face;
            if ((face = edgeToFace.get(cycle._key)) == null) continue;
            return face;
        } while ((cycle = cycle._next) != edge);
        return null;
    }

    private int findInputFace(SubdivisionEdge edge, Map<Integer, Integer> edgeToFace) {
        Integer oldFace = edgeToFace.get(edge._key);
        if (oldFace != null) {
            return oldFace;
        }
        oldFace = Subdivision.findCycleFace(edge, edgeToFace);
        if (oldFace != null) {
            return oldFace;
        }
        SubdivisionEdge nextCycle = edge._twin._next;
        while (nextCycle != edge._previous._twin) {
            oldFace = Subdivision.findCycleFace(nextCycle, edgeToFace);
            if (oldFace != null) {
                return oldFace;
            }
            nextCycle = nextCycle._twin._next;
        }
        SubdivisionFace face2 = this.findFace(edge._origin);
        return face2._key;
    }

    private static void insertAtEdge(SubdivisionEdge edge, SubdivisionEdge oldEdge) {
        assert (edge != oldEdge);
        if (!edge._origin.equals(oldEdge._origin)) {
            throw new IllegalArgumentException("edge.origin != oldEdge.origin");
        }
        if (oldEdge._previous == oldEdge._twin) {
            edge._previous = oldEdge._twin;
            edge._twin._next = oldEdge;
        } else {
            SubdivisionEdge[] neighbors = oldEdge.findEdgePosition(edge._twin._origin);
            edge._previous = neighbors[1]._twin;
            edge._twin._next = neighbors[0];
        }
        edge._previous._next = edge;
        edge._twin._next._previous = edge._twin;
    }

    private void insertAtOrigin(SubdivisionEdge edge) {
        PointD key = edge._origin;
        SubdivisionEdge oldEdge = (SubdivisionEdge)this._vertices.get(key);
        if (oldEdge == null) {
            this._vertices.put(key, edge);
            edge._previous = edge._twin;
            edge._twin._next = edge;
            return;
        }
        SubdivisionEdge cursor = oldEdge;
        do {
            if (cursor != edge) continue;
            return;
        } while ((cursor = cursor._twin._next) != oldEdge);
        Subdivision.insertAtEdge(edge, oldEdge);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void intersectEdges(Subdivision division2, Map<Integer, Integer> edgeToFace1, Map<Integer, Integer> edgeToFace2) {
        assert (this.epsilon <= division2.epsilon);
        assert (edgeToFace2.isEmpty());
        double minEpsilon = Math.max(this.epsilon, 1.0E-10);
        ArrayList<SubdivisionEdge> edge1List = new ArrayList<SubdivisionEdge>(this._edges.size());
        for (SubdivisionEdge edge1 : this._edges.values()) {
            if (edge1._key >= edge1._twin._key) continue;
            edge1List.add(edge1);
        }
        Stack<SubdivisionEdge> edge2Stack = new Stack<SubdivisionEdge>();
        Iterator edge2Iterator = division2._edges.values().iterator();
        block42: while (true) {
            SubdivisionEdge edge2;
            if (!edge2Stack.isEmpty()) {
                edge2 = (SubdivisionEdge)edge2Stack.pop();
            } else {
                if (!edge2Iterator.hasNext()) {
                    return;
                }
                SubdivisionEdge edge = (SubdivisionEdge)edge2Iterator.next();
                if (edge._key > edge._twin._key) continue;
                CreateEdgeResult result = this.createTwinEdges(edge._origin, edge._twin._origin);
                edge2 = result.startEdge;
                edgeToFace2.put(edge2._key, edge._face._key);
                edgeToFace2.put(edge2._twin._key, edge._twin._face._key);
                if (!result.isEdgeCreated) continue;
            }
            int edge1Index = 0;
            while (true) {
                block84: {
                    SplitEdgeResult split;
                    LineIntersection crossing;
                    SubdivisionEdge edge1;
                    block85: {
                        if (edge1Index >= edge1List.size()) continue block42;
                        edge1 = (SubdivisionEdge)edge1List.get(edge1Index);
                        crossing = LineIntersection.find(edge1._origin, edge1._twin._origin, edge2._origin, edge2._twin._origin, minEpsilon);
                        if (!crossing.exists()) break block84;
                        if (crossing.relation != LineRelation.COLLINEAR) break block85;
                        if (PointDComparatorY.compareEpsilon(edge1._origin, edge1._twin._origin, minEpsilon) > 0) {
                            edge1 = edge1._twin;
                        }
                        if (PointDComparatorY.compareEpsilon(edge2._origin, edge2._twin._origin, minEpsilon) > 0) {
                            edge2 = edge2._twin;
                        }
                        LineLocation edge2Start = LineIntersection.locateCollinear(edge1._origin, edge1._twin._origin, edge2._origin, minEpsilon);
                        LineLocation edge2End = LineIntersection.locateCollinear(edge1._origin, edge1._twin._origin, edge2._twin._origin, minEpsilon);
                        switch (edge2Start) {
                            case BEFORE: {
                                switch (edge2End) {
                                    case BEFORE: {
                                        throw new IllegalStateException("locateCollinear");
                                    }
                                    case START: {
                                        break block84;
                                    }
                                    case BETWEEN: {
                                        split = this.trySplitEdge(edge1, edge2._twin._origin);
                                        split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                        if (split.createdEdge != null) {
                                            edge1List.add(split.createdEdge);
                                        } else if (split.isEdgeDeleted) {
                                            throw new IllegalStateException("trySplitEdge found overlapping edges");
                                        }
                                        if (this.moveOriginToEdge(edge2._twin, split.originEdge) != null) {
                                            continue block42;
                                        }
                                        break block84;
                                    }
                                    case END: {
                                        if (this.moveOriginToEdge(edge2._twin, edge1) != null) {
                                            continue block42;
                                        }
                                        break block84;
                                    }
                                    case AFTER: {
                                        split = this.trySplitEdge(edge2, edge1._origin);
                                        split.updateFaces(edge2, edgeToFace1, edgeToFace2);
                                        if (split.createdEdge != null) {
                                            edge2Stack.push(split.createdEdge);
                                        } else if (split.isEdgeDeleted) {
                                            throw new IllegalStateException("trySplitEdge found overlapping edges");
                                        }
                                        if (this.moveOriginToEdge(split.destinationEdge, edge1._twin) != null) {
                                            if (split.destinationEdge == edge2) continue block42;
                                            if (split.destinationEdge == split.createdEdge) {
                                                edge2Stack.pop();
                                            }
                                        }
                                        break block84;
                                    }
                                }
                                break;
                            }
                            case START: {
                                switch (edge2End) {
                                    case BEFORE: {
                                        throw new IllegalStateException("locateCollinear");
                                    }
                                    case START: {
                                        throw new IllegalArgumentException("division contains zero-length edge");
                                    }
                                    case BETWEEN: {
                                        if (this.moveOriginToEdge(edge1, edge2._twin) != null) {
                                            throw new IllegalStateException("moveOriginToEdge found overlapping edges");
                                        }
                                        break block84;
                                    }
                                    case END: {
                                        throw new IllegalStateException("locateCollinear");
                                    }
                                    case AFTER: {
                                        if (this.moveOriginToEdge(edge2, edge1._twin) != null) {
                                            continue block42;
                                        }
                                        break block84;
                                    }
                                }
                                break;
                            }
                            case BETWEEN: {
                                switch (edge2End) {
                                    case START: 
                                    case BEFORE: {
                                        throw new IllegalStateException("locateCollinear");
                                    }
                                    case BETWEEN: {
                                        split = this.trySplitEdge(edge1, edge2._origin);
                                        split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                        if (split.createdEdge != null) {
                                            edge1List.add(split.createdEdge);
                                        } else if (split.isEdgeDeleted) {
                                            throw new IllegalStateException("trySplitEdge found overlapping edges");
                                        }
                                        if (this.moveOriginToEdge(split.destinationEdge, edge2._twin) != null) {
                                            throw new IllegalStateException("moveOriginToEdge found overlapping edges");
                                        }
                                        break block84;
                                    }
                                    case END: {
                                        if (this.moveOriginToEdge(edge1._twin, edge2) != null) {
                                            throw new IllegalStateException("moveOriginToEdge found overlapping edges");
                                        }
                                        break block84;
                                    }
                                    case AFTER: {
                                        split = this.trySplitEdge(edge1, edge2._origin);
                                        split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                        if (split.createdEdge != null) {
                                            edge1List.add(split.createdEdge);
                                        } else if (split.isEdgeDeleted) {
                                            throw new IllegalStateException("trySplitEdge found overlapping edges");
                                        }
                                        if (this.moveOriginToEdge(edge2, split.destinationEdge._twin) != null) {
                                            continue block42;
                                        }
                                        break block84;
                                    }
                                }
                                break;
                            }
                            case END: {
                                switch (edge2End) {
                                    case START: 
                                    case BETWEEN: 
                                    case BEFORE: {
                                        throw new IllegalStateException("locateCollinear");
                                    }
                                    case END: {
                                        throw new IllegalArgumentException("division contains zero-length edge");
                                    }
                                    case AFTER: {
                                        break block84;
                                    }
                                }
                                break;
                            }
                            case AFTER: {
                                throw new IllegalStateException("locateCollinear");
                            }
                        }
                        throw new IllegalStateException("locateCollinear");
                    }
                    assert (crossing.relation == LineRelation.DIVERGENT);
                    if (crossing.first == LineLocation.BETWEEN) {
                        switch (crossing.second) {
                            case START: {
                                split = this.trySplitEdge(edge1, edge2._origin);
                                split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge1List.add(split.createdEdge);
                                    break;
                                }
                                if (!split.isEdgeDeleted) break;
                                throw new IllegalStateException("trySplitEdge found overlapping edges");
                            }
                            case END: {
                                split = this.trySplitEdge(edge1, edge2._twin._origin);
                                split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge1List.add(split.createdEdge);
                                    break;
                                }
                                if (!split.isEdgeDeleted) break;
                                throw new IllegalStateException("trySplitEdge found overlapping edges");
                            }
                            case BETWEEN: {
                                split = this.trySplitEdge(edge1, crossing.shared);
                                split.updateFaces(edge1, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge1List.add(split.createdEdge);
                                } else if (split.isEdgeDeleted) {
                                    throw new IllegalStateException("trySplitEdge found overlapping edges");
                                }
                                split = this.trySplitEdge(edge2, split.destinationEdge._origin);
                                split.updateFaces(edge2, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge2Stack.push(split.createdEdge);
                                    break;
                                }
                                if (split.isEdgeDeleted) continue block42;
                            }
                        }
                    } else if (crossing.second == LineLocation.BETWEEN) {
                        switch (crossing.first) {
                            case START: {
                                split = this.trySplitEdge(edge2, edge1._origin);
                                split.updateFaces(edge2, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge2Stack.push(split.createdEdge);
                                    break;
                                }
                                if (!split.isEdgeDeleted) break;
                                continue block42;
                            }
                            case END: {
                                split = this.trySplitEdge(edge2, edge1._twin._origin);
                                split.updateFaces(edge2, edgeToFace1, edgeToFace2);
                                if (split.createdEdge != null) {
                                    edge2Stack.push(split.createdEdge);
                                    break;
                                }
                                if (!split.isEdgeDeleted) break;
                                continue block42;
                            }
                        }
                    }
                }
                ++edge1Index;
            }
            break;
        }
    }

    private SubdivisionEdge moveOriginToEdge(SubdivisionEdge edge, SubdivisionEdge oldEdge) {
        this.removeAtOrigin(edge);
        SubdivisionEdge twin = edge._twin;
        SubdivisionEdge cursor = oldEdge;
        do {
            if (cursor._twin._origin != twin._origin) continue;
            this.removeAtOrigin(twin);
            this._edges.remove(edge._key);
            this._edges.remove(twin._key);
            return cursor;
        } while ((cursor = cursor._twin._next) != oldEdge);
        edge._origin = oldEdge._origin;
        Subdivision.insertAtEdge(edge, oldEdge);
        return null;
    }

    private void removeAtOrigin(SubdivisionEdge edge) {
        SubdivisionEdge twin = edge._twin;
        PointD key = edge._origin;
        assert (this._vertices.containsKey(key));
        if (edge._previous == twin) {
            this._vertices.remove(key);
            return;
        }
        edge._previous._next = twin._next;
        twin._next._previous = edge._previous;
        if (this._vertices.get(key) == edge) {
            this._vertices.put(key, edge._twin._next);
        }
    }

    private SubdivisionEdge splitEdgeAtVertex(SubdivisionEdge edge, PointD vertex, boolean addVertex) {
        if (vertex == null) {
            throw new NullPointerException("vertex");
        }
        SubdivisionEdge twin = edge._twin;
        SubdivisionEdge newEdge = new SubdivisionEdge(this._nextEdgeKey++);
        this._edges.put(newEdge._key, newEdge);
        newEdge._origin = vertex;
        newEdge._face = edge._face;
        newEdge._twin = twin;
        twin._twin = newEdge;
        newEdge._next = edge._next;
        newEdge._next._previous = newEdge;
        SubdivisionEdge newTwin = new SubdivisionEdge(this._nextEdgeKey++);
        this._edges.put(newTwin._key, newTwin);
        newTwin._origin = vertex;
        newTwin._face = twin._face;
        newTwin._twin = edge;
        edge._twin = newTwin;
        newTwin._next = twin._next;
        twin._next._previous = newTwin;
        if (addVertex) {
            this._vertices.put(vertex, newEdge);
            edge._next = newEdge;
            newEdge._previous = edge;
            twin._next = newTwin;
            newTwin._previous = twin;
        } else {
            newEdge._previous = twin;
            twin._next = newEdge;
            newTwin._previous = edge;
            edge._next = newTwin;
            this.insertAtOrigin(newEdge);
            this.insertAtOrigin(newTwin);
        }
        return newEdge;
    }

    private SplitEdgeResult trySplitEdge(SubdivisionEdge edge, PointD vertex) {
        SubdivisionEdge twin = edge._twin;
        assert (vertex != edge._origin);
        assert (vertex != twin._origin);
        SubdivisionEdge originEdge = null;
        SubdivisionEdge destinationEdge = null;
        SubdivisionEdge incidentEdge = (SubdivisionEdge)this._vertices.get(vertex);
        if (incidentEdge != null) {
            SubdivisionEdge cursor = incidentEdge;
            do {
                PointD origin;
                if ((origin = cursor._twin._origin) == edge._origin) {
                    originEdge = cursor._twin;
                    if (destinationEdge == null) continue;
                    break;
                }
                if (origin != twin._origin) continue;
                destinationEdge = cursor;
                if (originEdge != null) break;
            } while ((cursor = cursor._twin._next) != incidentEdge);
            vertex = incidentEdge._origin;
        }
        if (originEdge == null && destinationEdge == null) {
            SubdivisionEdge newEdge = this.splitEdgeAtVertex(edge, vertex, incidentEdge == null);
            return new SplitEdgeResult(edge, newEdge, newEdge, false);
        }
        if (originEdge != null && destinationEdge != null) {
            this.removeAtOrigin(edge);
            this.removeAtOrigin(twin);
            this._edges.remove(edge._key);
            this._edges.remove(twin._key);
            return new SplitEdgeResult(originEdge, destinationEdge, null, true);
        }
        if (originEdge != null) {
            this.removeAtOrigin(edge);
            edge._origin = vertex;
            Subdivision.insertAtEdge(edge, originEdge._twin);
            return new SplitEdgeResult(originEdge, edge, null, false);
        }
        assert (destinationEdge != null);
        this.removeAtOrigin(edge._twin);
        edge._twin._origin = vertex;
        Subdivision.insertAtEdge(edge._twin, destinationEdge);
        return new SplitEdgeResult(edge, destinationEdge, null, false);
    }
}

