/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.kynosarges.tektosyne.MathUtils;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PolygonLocation;
import org.kynosarges.tektosyne.subdivision.SubdivisionFace;

public final class SubdivisionEdge {
    int _key;
    PointD _origin;
    SubdivisionFace _face;
    SubdivisionEdge _next;
    SubdivisionEdge _previous;
    SubdivisionEdge _twin;

    SubdivisionEdge(int key) {
        this._key = key;
    }

    SubdivisionEdge(int key, PointD origin, SubdivisionEdge twin, SubdivisionFace face, SubdivisionEdge next, SubdivisionEdge previous) {
        this._key = key;
        this._origin = origin;
        this._twin = twin;
        this._face = face;
        this._next = next;
        this._previous = previous;
    }

    public int key() {
        return this._key;
    }

    public PointD origin() {
        return this._origin;
    }

    public PointD destination() {
        return this._twin._origin;
    }

    public SubdivisionFace face() {
        return this._face;
    }

    public SubdivisionEdge next() {
        return this._next;
    }

    public SubdivisionEdge previous() {
        return this._previous;
    }

    public SubdivisionEdge twin() {
        return this._twin;
    }

    public double cycleArea() {
        SubdivisionEdge next;
        double area = 0.0;
        SubdivisionEdge edge = this;
        do {
            next = edge._next;
            area += edge._origin.x * next._origin.y - next._origin.x * edge._origin.y;
        } while ((edge = next) != this);
        return area / 2.0;
    }

    public PointD cycleCentroid() {
        SubdivisionEdge next;
        double area = 0.0;
        double x = 0.0;
        double y = 0.0;
        SubdivisionEdge edge = this;
        do {
            next = edge._next;
            double factor = edge._origin.x * next._origin.y - next._origin.x * edge._origin.y;
            area += factor;
            x += (edge._origin.x + next._origin.x) * factor;
            y += (edge._origin.y + next._origin.y) * factor;
        } while ((edge = next) != this);
        return new PointD(x / (area *= 3.0), y / area);
    }

    public List<SubdivisionEdge> cycleEdges() {
        ArrayList<SubdivisionEdge> edges = new ArrayList<SubdivisionEdge>();
        SubdivisionEdge edge = this;
        do {
            edges.add(edge);
        } while ((edge = edge._next) != this);
        return edges;
    }

    public PointD[] cyclePolygon() {
        int index = 0;
        SubdivisionEdge edge = this;
        do {
            ++index;
        } while ((edge = edge._next) != this);
        PointD[] points = new PointD[index];
        for (index = 0; index < points.length; ++index) {
            points[index] = edge._origin;
            edge = edge._next;
        }
        return points;
    }

    public boolean isCycleAreaZero() {
        SubdivisionEdge edge = this;
        do {
            if (edge._twin._face == this._face) continue;
            return false;
        } while ((edge = edge._next) != this);
        return true;
    }

    public List<SubdivisionEdge> originEdges() {
        ArrayList<SubdivisionEdge> edges = new ArrayList<SubdivisionEdge>();
        SubdivisionEdge edge = this;
        do {
            edges.add(edge);
        } while ((edge = edge._twin._next) != this);
        return edges;
    }

    public SubdivisionEdge findEdgeTo(PointD destination) {
        SubdivisionEdge twin;
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        SubdivisionEdge edge = this;
        do {
            twin = edge._twin;
            if (!twin._origin.equals(destination)) continue;
            return edge;
        } while ((edge = twin._next) != this);
        return null;
    }

    public SubdivisionEdge findEdgeTo(PointD destination, double epsilon) {
        SubdivisionEdge twin;
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        SubdivisionEdge edge = this;
        do {
            twin = edge._twin;
            if (!PointD.equals(twin._origin, destination, epsilon)) continue;
            return edge;
        } while ((edge = twin._next) != this);
        return null;
    }

    public PolygonLocation locate(PointD q) {
        if (q == null) {
            throw new NullPointerException("q");
        }
        int rightCrossings = 0;
        int leftCrossings = 0;
        SubdivisionEdge edge = this;
        double x1 = edge._origin.x - q.x;
        double y1 = edge._origin.y - q.y;
        do {
            boolean leftStraddle;
            edge = edge._next;
            double x0 = edge._origin.x - q.x;
            double y0 = edge._origin.y - q.y;
            if (x0 == 0.0 && y0 == 0.0) {
                return PolygonLocation.VERTEX;
            }
            boolean rightStraddle = y0 > 0.0 != y1 > 0.0;
            boolean bl = leftStraddle = y0 < 0.0 != y1 < 0.0;
            if (rightStraddle || leftStraddle) {
                double x = (x0 * y1 - x1 * y0) / (y1 - y0);
                if (rightStraddle && x > 0.0) {
                    ++rightCrossings;
                }
                if (leftStraddle && x < 0.0) {
                    ++leftCrossings;
                }
            }
            x1 = x0;
            y1 = y0;
        } while (edge != this);
        if (rightCrossings % 2 != leftCrossings % 2) {
            return PolygonLocation.EDGE;
        }
        return rightCrossings % 2 != 0 ? PolygonLocation.INSIDE : PolygonLocation.OUTSIDE;
    }

    public PolygonLocation locate(PointD q, double epsilon) {
        if (q == null) {
            throw new NullPointerException("q");
        }
        if (epsilon <= 0.0) {
            throw new IllegalArgumentException("epsilon <= 0");
        }
        int rightCrossings = 0;
        int leftCrossings = 0;
        SubdivisionEdge edge = this;
        double x1 = edge._origin.x - q.x;
        double y1 = edge._origin.y - q.y;
        int dy1 = MathUtils.compare(y1, 0.0, epsilon);
        do {
            boolean leftStraddle;
            edge = edge._next;
            double x0 = edge._origin.x - q.x;
            double y0 = edge._origin.y - q.y;
            int dx0 = MathUtils.compare(x0, 0.0, epsilon);
            int dy0 = MathUtils.compare(y0, 0.0, epsilon);
            if (dx0 == 0 && dy0 == 0) {
                return PolygonLocation.VERTEX;
            }
            boolean rightStraddle = dy0 > 0 != dy1 > 0;
            boolean bl = leftStraddle = dy0 < 0 != dy1 < 0;
            if (rightStraddle || leftStraddle) {
                double x = (x0 * y1 - x1 * y0) / (y1 - y0);
                int dx = MathUtils.compare(x, 0.0, epsilon);
                if (rightStraddle && dx > 0) {
                    ++rightCrossings;
                }
                if (leftStraddle && dx < 0) {
                    ++leftCrossings;
                }
            }
            x1 = x0;
            y1 = y0;
            dy1 = dy0;
        } while (edge != this);
        if (rightCrossings % 2 != leftCrossings % 2) {
            return PolygonLocation.EDGE;
        }
        return rightCrossings % 2 != 0 ? PolygonLocation.INSIDE : PolygonLocation.OUTSIDE;
    }

    public LineD toLine() {
        return new LineD(this._origin, this._twin._origin);
    }

    public LineD toLineReverse() {
        return new LineD(this._twin._origin, this._origin);
    }

    SubdivisionEdge[] findEdgePosition(PointD destination) {
        SubdivisionEdge nextEdge = this;
        SubdivisionEdge previousEdge = this;
        PointD pivot = this._twin._origin;
        double firstAngle = this._origin.angleBetween(destination, pivot);
        if (firstAngle > 0.0) {
            double angle;
            do {
                previousEdge = nextEdge;
                nextEdge = nextEdge._twin._next;
            } while ((angle = this._origin.angleBetween(destination, pivot = nextEdge._twin._origin)) > 0.0 && angle < firstAngle);
        } else {
            double angle;
            do {
                nextEdge = previousEdge;
                previousEdge = previousEdge._previous._twin;
            } while ((angle = this._origin.angleBetween(destination, pivot = previousEdge._twin._origin)) < 0.0 && angle > firstAngle);
        }
        return new SubdivisionEdge[]{nextEdge, previousEdge};
    }

    SubdivisionEdge getOtherCycleEdge(SubdivisionEdge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (this == edge) {
            if (this._next != this._twin) {
                return this._next;
            }
            if (this._previous != this._twin) {
                return this._previous;
            }
            return null;
        }
        if (this == edge._twin) {
            if (this._next != edge) {
                return this._next;
            }
            if (this._previous != edge) {
                return this._previous;
            }
            return null;
        }
        return this;
    }

    boolean isCompatibleDestination(PointD destination) {
        double nextAngle;
        if (destination == null) {
            throw new NullPointerException("destination");
        }
        if (this._next == this._twin) {
            return true;
        }
        PointD pivot = this._twin._origin;
        if (pivot.equals(destination)) {
            return true;
        }
        double pivotAngle = this._origin.angleBetween(pivot, destination);
        double prevAngle = this._origin.angleBetween(pivot, this._previous._origin);
        SubdivisionEdge next = this._twin._next._twin;
        double d = nextAngle = this._previous == next ? prevAngle : this._origin.angleBetween(pivot, next._origin);
        if (prevAngle > 0.0) {
            prevAngle -= Math.PI * 2;
        }
        if (nextAngle < 0.0) {
            nextAngle += Math.PI * 2;
        }
        if (pivotAngle < 0.0) {
            if (prevAngle < 0.0) {
                return pivotAngle > prevAngle;
            }
            assert (nextAngle < 0.0);
            return pivotAngle > nextAngle;
        }
        if (prevAngle > 0.0) {
            return pivotAngle < prevAngle;
        }
        assert (nextAngle > 0.0);
        return pivotAngle < nextAngle;
    }

    void setAllFaces(SubdivisionFace face) {
        if (face == null) {
            throw new NullPointerException("face");
        }
        SubdivisionEdge edge = this;
        do {
            edge._face = face;
        } while ((edge = edge._next) != this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SubdivisionEdge)) {
            return false;
        }
        SubdivisionEdge edge = (SubdivisionEdge)obj;
        return this._key == edge._key && Objects.equals(this._origin, edge._origin) && this._twin._key == edge._twin._key && this._face._key == edge._face._key && this._next._key == edge._next._key && this._previous._key == edge._previous._key;
    }

    public int hashCode() {
        return this._key;
    }

    public String toString() {
        ToIntFunction<SubdivisionEdge> edgeKey = e -> e == null ? -1 : e._key;
        ToIntFunction<SubdivisionFace> faceKey = e -> e == null ? -1 : e._key;
        return String.format("SubdivisionEdge[key=%d, origin=%s, twin=%d, face=%d, next=%d, previous=%d]", this._key, String.valueOf(this._origin), edgeKey.applyAsInt(this._twin), faceKey.applyAsInt(this._face), edgeKey.applyAsInt(this._next), edgeKey.applyAsInt(this._previous));
    }
}

