/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.Objects;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.subdivision.SubdivisionEdge;
import org.kynosarges.tektosyne.subdivision.SubdivisionElementType;
import org.kynosarges.tektosyne.subdivision.SubdivisionFace;

public final class SubdivisionElement {
    public static final SubdivisionElement NULL_FACE = new SubdivisionElement((SubdivisionFace)null);
    public final Object content;
    public final SubdivisionElementType type;

    public SubdivisionElement(SubdivisionEdge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        this.content = edge;
        this.type = SubdivisionElementType.EDGE;
    }

    public SubdivisionElement(SubdivisionFace face) {
        this.content = face;
        this.type = SubdivisionElementType.FACE;
    }

    public SubdivisionElement(PointD vertex) {
        if (vertex == null) {
            throw new NullPointerException("vertex");
        }
        this.content = vertex;
        this.type = SubdivisionElementType.VERTEX;
    }

    public SubdivisionEdge edge() {
        if (this.type != SubdivisionElementType.EDGE) {
            throw new IllegalStateException("type != EDGE");
        }
        return (SubdivisionEdge)this.content;
    }

    public SubdivisionFace face() {
        if (this.type != SubdivisionElementType.FACE) {
            throw new IllegalStateException("type != FACE");
        }
        return (SubdivisionFace)this.content;
    }

    public boolean isUnboundedFace() {
        return this.type == SubdivisionElementType.FACE && (this.content == null || ((SubdivisionFace)this.content)._key == 0);
    }

    public PointD vertex() {
        if (this.type != SubdivisionElementType.VERTEX) {
            throw new IllegalStateException("type != VERTEX");
        }
        return (PointD)this.content;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SubdivisionElement)) {
            return false;
        }
        SubdivisionElement element = (SubdivisionElement)obj;
        return this.type == element.type && Objects.equals(this.content, element.content);
    }

    public int hashCode() {
        return this.content != null ? this.content.hashCode() : this.type.ordinal();
    }

    public String toString() {
        return String.format("SubdivisionElement[type=%s, content=%s]", this.type.toString(), String.valueOf(this.content));
    }
}

