/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.subdivision.FindEdgeResult;
import org.kynosarges.tektosyne.subdivision.MoveEdgeResult;
import org.kynosarges.tektosyne.subdivision.Subdivision;
import org.kynosarges.tektosyne.subdivision.SubdivisionEdge;

public final class SubdivisionFace {
    public final Subdivision owner;
    int _key;
    SubdivisionEdge _outerEdge;
    List<SubdivisionEdge> _innerEdges;

    SubdivisionFace(Subdivision owner, int key) {
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        this.owner = owner;
        this._key = key;
    }

    SubdivisionFace(Subdivision owner, int key, SubdivisionEdge outerEdge, Collection<SubdivisionEdge> innerEdges) {
        this(owner, key);
        this._outerEdge = outerEdge;
        if (innerEdges != null) {
            this._innerEdges = new ArrayList<SubdivisionEdge>(innerEdges);
        }
    }

    public int key() {
        return this._key;
    }

    public List<SubdivisionEdge> allCycleEdges() {
        ArrayList<SubdivisionEdge> edges = new ArrayList<SubdivisionEdge>();
        if (this._outerEdge != null) {
            SubdivisionEdge edge = this._outerEdge;
            do {
                edges.add(edge);
            } while ((edge = edge._next) != this._outerEdge);
        }
        if (this._innerEdges == null) {
            return edges;
        }
        Iterator<SubdivisionEdge> iterator = this._innerEdges.iterator();
        while (iterator.hasNext()) {
            SubdivisionEdge innerEdge;
            SubdivisionEdge edge = innerEdge = iterator.next();
            do {
                edges.add(edge);
            } while ((edge = edge._next) != innerEdge);
        }
        return edges;
    }

    public SubdivisionEdge outerEdge() {
        return this._outerEdge;
    }

    public List<SubdivisionEdge> innerEdges() {
        return this._innerEdges == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._innerEdges);
    }

    public FindEdgeResult findNearestEdge(PointD q) {
        LineLocation location;
        Object edge;
        double distance = Double.MAX_VALUE;
        Object nearestEdge = null;
        if (this._outerEdge != null) {
            edge = this._outerEdge;
            do {
                double d;
                if (!(distance > (d = ((SubdivisionEdge)edge).toLine().distanceSquared(q)))) continue;
                if (d == 0.0) {
                    return new FindEdgeResult((SubdivisionEdge)edge, 0.0);
                }
                distance = d;
                nearestEdge = edge;
            } while ((edge = ((SubdivisionEdge)edge)._next) != this._outerEdge);
        }
        if (this._innerEdges != null) {
            edge = this._innerEdges.iterator();
            while (edge.hasNext()) {
                SubdivisionEdge innerEdge;
                SubdivisionEdge edge2 = innerEdge = (SubdivisionEdge)edge.next();
                do {
                    double d;
                    if (!(distance > (d = edge2.toLine().distanceSquared(q)))) continue;
                    if (d == 0.0) {
                        return new FindEdgeResult(edge2, 0.0);
                    }
                    distance = d;
                    nearestEdge = edge2;
                } while ((edge2 = edge2._next) != innerEdge);
            }
        }
        if (nearestEdge == null) {
            return new FindEdgeResult(null, Double.MAX_VALUE);
        }
        if (((SubdivisionEdge)nearestEdge)._twin._face == this && (location = ((SubdivisionEdge)nearestEdge).toLine().locate(q)) == LineLocation.RIGHT) {
            nearestEdge = ((SubdivisionEdge)nearestEdge)._twin;
        }
        return new FindEdgeResult((SubdivisionEdge)nearestEdge, Math.sqrt(distance));
    }

    void addInnerEdge(SubdivisionEdge edge) {
        if (edge == null) {
            throw new NullPointerException("edge");
        }
        if (this._innerEdges == null) {
            this._innerEdges = new ArrayList<SubdivisionEdge>();
        }
        this._innerEdges.add(edge);
    }

    void addInnerEdges(List<SubdivisionEdge> edges) {
        if (edges == null || edges.isEmpty()) {
            return;
        }
        if (this._innerEdges == null) {
            this._innerEdges = new ArrayList<SubdivisionEdge>();
        }
        this._innerEdges.addAll(edges);
    }

    MoveEdgeResult moveEdge(SubdivisionEdge oldEdge) {
        SubdivisionEdge oldTwin = oldEdge._twin;
        if (this._outerEdge == oldEdge || this._outerEdge == oldTwin) {
            this._outerEdge = this._outerEdge.getOtherCycleEdge(oldEdge);
            assert (this._outerEdge != null);
            return MoveEdgeResult.OUTER_CHANGED;
        }
        if (this._innerEdges == null) {
            return MoveEdgeResult.UNCHANGED;
        }
        for (int i = 0; i < this._innerEdges.size(); ++i) {
            SubdivisionEdge innerEdge = this._innerEdges.get(i);
            if (innerEdge != oldEdge && innerEdge != oldTwin) continue;
            if (oldEdge._next == oldTwin && oldEdge._previous == oldTwin) {
                this._innerEdges.remove(i);
                if (this._innerEdges.isEmpty()) {
                    this._innerEdges = null;
                }
                return MoveEdgeResult.INNER_REMOVED;
            }
            this._innerEdges.set(i, innerEdge.getOtherCycleEdge(oldEdge));
            assert (this._innerEdges.get(i) != null);
            return MoveEdgeResult.INNER_CHANGED;
        }
        return MoveEdgeResult.UNCHANGED;
    }

    MoveEdgeResult moveEdge(SubdivisionEdge oldEdge, SubdivisionEdge newEdge) {
        if (oldEdge == null) {
            throw new NullPointerException("oldEdge");
        }
        if (newEdge == null) {
            throw new NullPointerException("newEdge");
        }
        if (this._outerEdge == oldEdge) {
            this._outerEdge = newEdge;
            return MoveEdgeResult.OUTER_CHANGED;
        }
        if (this._innerEdges != null) {
            for (int i = 0; i < this._innerEdges.size(); ++i) {
                if (this._innerEdges.get(i) != oldEdge) continue;
                this._innerEdges.set(i, newEdge);
                return MoveEdgeResult.INNER_CHANGED;
            }
        }
        return MoveEdgeResult.UNCHANGED;
    }

    void setAllEdgeFaces(SubdivisionFace face) {
        if (face == null) {
            throw new NullPointerException("face");
        }
        if (this._outerEdge != null) {
            this._outerEdge.setAllFaces(face);
        }
        if (this._innerEdges != null) {
            for (SubdivisionEdge _innerEdge : this._innerEdges) {
                _innerEdge.setAllFaces(face);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SubdivisionFace)) {
            return false;
        }
        SubdivisionFace face = (SubdivisionFace)obj;
        return this._key == face._key && Objects.equals(this._outerEdge, face._outerEdge) && Objects.equals(this._innerEdges, face._innerEdges);
    }

    public int hashCode() {
        return this._key;
    }

    public String toString() {
        ToIntFunction<SubdivisionEdge> edgeKey = e -> e == null ? -1 : e._key;
        String innerEdges = this._innerEdges == null ? "none" : Arrays.toString(this._innerEdges.stream().mapToInt(edgeKey).toArray());
        return String.format("SubdivisionFace[key=%d, outerEdge=%d, innerEdges=%s]", this._key, edgeKey.applyAsInt(this._outerEdge), innerEdges);
    }
}

