/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.kynosarges.tektosyne.geometry.LineD;
import org.kynosarges.tektosyne.geometry.LineLocation;
import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.PointDComparatorX;
import org.kynosarges.tektosyne.subdivision.Subdivision;
import org.kynosarges.tektosyne.subdivision.SubdivisionEdge;
import org.kynosarges.tektosyne.subdivision.SubdivisionElement;

public class SubdivisionSearch {
    private Object _tree = new Trapezoid();
    public final double epsilon;
    public final Subdivision source;

    public SubdivisionSearch(Subdivision source, boolean ordered) {
        this.source = source;
        this.epsilon = Math.max(1.0E-10, source.epsilon);
        SubdivisionEdge[] edges = new SubdivisionEdge[source.edges().size() / 2];
        int index = 0;
        for (SubdivisionEdge edge : source.edges().values()) {
            if (PointDComparatorX.compareEpsilon(edge._origin, edge._twin._origin, this.epsilon) >= 0) continue;
            edges[index++] = edge;
        }
        assert (index == edges.length);
        if (!ordered) {
            Collections.shuffle(Arrays.asList(edges));
        }
        for (SubdivisionEdge edge : edges) {
            this.insertEdge(edge);
        }
    }

    public SubdivisionElement find(PointD q) {
        if (this._tree instanceof Trapezoid) {
            return SubdivisionElement.NULL_FACE;
        }
        return ((Node)this._tree).find(q);
    }

    public String format() {
        StringBuilder builder = new StringBuilder();
        builder.append("Root: ");
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(this._tree);
        while (!queue.isEmpty()) {
            Object obj = queue.remove();
            builder.append(obj);
            builder.append("\n\n");
            if (!(obj instanceof Node)) continue;
            Node node = (Node)obj;
            if (node.left != null) {
                queue.add(node.left);
            }
            if (node.right == null) continue;
            queue.add(node.right);
        }
        return builder.toString();
    }

    public void validate() {
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(this._tree);
        while (!queue.isEmpty()) {
            Object obj = queue.remove();
            if (obj instanceof VertexNode) {
                VertexNode vertexNode = (VertexNode)obj;
                assert (!(vertexNode.left instanceof VertexNode) || PointDComparatorX.compareEpsilon(vertexNode.vertex, ((VertexNode)vertexNode.left).vertex, this.epsilon) > 0);
                assert (!(vertexNode.right instanceof VertexNode) || PointDComparatorX.compareEpsilon(vertexNode.vertex, ((VertexNode)vertexNode.right).vertex, this.epsilon) < 0);
            }
            if (obj instanceof Node) {
                Node node = (Node)obj;
                assert (node.left != null);
                queue.add(node.left);
                assert (node.right != null);
                queue.add(node.right);
                continue;
            }
            Trapezoid delta = (Trapezoid)obj;
            assert (!delta.isDeleted());
            assert (this._tree == delta || !delta.parents.isEmpty());
            for (Node parent : delta.parents) {
                assert (parent.left == delta || parent.right == delta);
            }
            if (delta.upperLeft != null) {
                assert (!delta.upperLeft.isDeleted());
                assert (delta.upperLeft.upperRight == delta);
                assert (delta.topEdge == delta.upperLeft.topEdge);
                assert (delta.leftVertex == delta.upperLeft.rightVertex);
            }
            if (delta.upperRight != null) {
                assert (!delta.upperRight.isDeleted());
                assert (delta.upperRight.upperLeft == delta);
                assert (delta.topEdge == delta.upperRight.topEdge);
                assert (delta.rightVertex == delta.upperRight.leftVertex);
            }
            if (delta.lowerLeft != null) {
                assert (!delta.lowerLeft.isDeleted());
                assert (delta.lowerLeft.lowerRight == delta);
                assert (delta.bottomEdge == delta.lowerLeft.bottomEdge);
                assert (delta.leftVertex == delta.lowerLeft.rightVertex);
            }
            if (delta.lowerRight == null) continue;
            assert (!delta.lowerRight.isDeleted());
            assert (delta.lowerRight.lowerLeft == delta);
            assert (delta.bottomEdge == delta.lowerRight.bottomEdge);
            assert (delta.rightVertex == delta.lowerRight.leftVertex);
        }
    }

    private List<Trapezoid> findEdge(LineD edge) {
        assert (this._tree instanceof Node);
        assert (PointDComparatorX.compareEpsilon(edge.start, edge.end, this.epsilon) < 0);
        Trapezoid delta = ((Node)this._tree).findEdge(edge);
        ArrayList<Trapezoid> deltas = new ArrayList<Trapezoid>();
        deltas.add(delta);
        while (PointDComparatorX.compareEpsilon(edge.end, delta.rightVertex, this.epsilon) > 0) {
            LineLocation result = edge.locate(delta.rightVertex);
            switch (result) {
                case LEFT: {
                    delta = delta.lowerRight;
                    break;
                }
                case RIGHT: {
                    delta = delta.upperRight;
                    break;
                }
                default: {
                    throw new IllegalStateException("edge.locate != LEFT/RIGHT");
                }
            }
            assert (delta != null);
            deltas.add(delta);
        }
        return deltas;
    }

    private void insertEdge(SubdivisionEdge edge) {
        VertexNode node;
        Trapezoid leaf;
        Trapezoid lowerLastLeaf;
        Trapezoid upperLastLeaf;
        List<Trapezoid> deltas;
        LineD edgeLine = edge.toLine();
        assert (PointDComparatorX.compareEpsilon(edgeLine.start, edgeLine.end, this.epsilon) < 0);
        Trapezoid delta = null;
        if (this._tree instanceof Trapezoid) {
            delta = (Trapezoid)this._tree;
        }
        if (delta != null) {
            deltas = new ArrayList<Trapezoid>(1);
            deltas.add(delta);
        } else {
            deltas = this.findEdge(edgeLine);
        }
        Node[] nodes = new Node[deltas.size()];
        for (int i = 0; i < nodes.length; ++i) {
            EdgeNode node2 = new EdgeNode(edge, edgeLine, this.epsilon);
            nodes[i] = node2;
            delta = deltas.get(i);
            Trapezoid oldUpperLeaf = null;
            Trapezoid oldLowerLeaf = null;
            if (i > 0) {
                oldUpperLeaf = (Trapezoid)nodes[i - 1].left;
                oldLowerLeaf = (Trapezoid)nodes[i - 1].right;
            }
            if (oldUpperLeaf != null && delta.topEdge == oldUpperLeaf.topEdge) {
                oldUpperLeaf.rightVertex = delta.rightVertex;
                node2.setLeft(oldUpperLeaf);
            } else {
                Trapezoid upperLeaf = new Trapezoid();
                upperLeaf.leftVertex = delta.leftVertex;
                upperLeaf.rightVertex = delta.rightVertex;
                upperLeaf.bottomEdge = edge;
                upperLeaf.topEdge = delta.topEdge;
                if (oldUpperLeaf != null) {
                    upperLeaf.lowerLeft = oldUpperLeaf;
                    oldUpperLeaf.lowerRight = upperLeaf;
                    upperLeaf.copyUpperLeft(delta);
                    oldUpperLeaf.copyUpperRight(deltas.get(i - 1));
                }
                node2.setLeft(upperLeaf);
            }
            if (oldLowerLeaf != null && delta.bottomEdge == oldLowerLeaf.bottomEdge) {
                oldLowerLeaf.rightVertex = delta.rightVertex;
                node2.setRight(oldLowerLeaf);
                continue;
            }
            Trapezoid lowerLeaf = new Trapezoid();
            lowerLeaf.leftVertex = delta.leftVertex;
            lowerLeaf.rightVertex = delta.rightVertex;
            lowerLeaf.bottomEdge = delta.bottomEdge;
            lowerLeaf.topEdge = edge._twin;
            if (oldLowerLeaf != null) {
                lowerLeaf.upperLeft = oldLowerLeaf;
                oldLowerLeaf.upperRight = lowerLeaf;
                lowerLeaf.copyLowerLeft(delta);
                oldLowerLeaf.copyLowerRight(deltas.get(i - 1));
            }
            node2.setRight(lowerLeaf);
        }
        Trapezoid upperFirstLeaf = (Trapezoid)nodes[0].left;
        Trapezoid lowerFirstLeaf = (Trapezoid)nodes[0].right;
        if (nodes.length == 0) {
            upperLastLeaf = upperFirstLeaf;
            lowerLastLeaf = lowerFirstLeaf;
        } else {
            upperLastLeaf = (Trapezoid)nodes[nodes.length - 1].left;
            lowerLastLeaf = (Trapezoid)nodes[nodes.length - 1].right;
        }
        delta = deltas.get(deltas.size() - 1);
        if (delta.rightVertex != edgeLine.end) {
            upperLastLeaf.rightVertex = lowerLastLeaf.rightVertex = edgeLine.end;
            leaf = new Trapezoid();
            leaf.leftVertex = edgeLine.end;
            leaf.rightVertex = delta.rightVertex;
            leaf.bottomEdge = delta.bottomEdge;
            leaf.topEdge = delta.topEdge;
            leaf.copyUpperRight(delta);
            leaf.copyLowerRight(delta);
            upperLastLeaf.upperRight = lowerLastLeaf.lowerRight = leaf;
            leaf.upperLeft = upperLastLeaf;
            leaf.lowerLeft = lowerLastLeaf;
            node = new VertexNode(edgeLine.end, this.epsilon);
            node.setRight(leaf);
            node.left = nodes[nodes.length - 1];
            nodes[nodes.length - 1] = node;
        } else {
            upperLastLeaf.copyUpperRight(delta);
            lowerLastLeaf.copyLowerRight(delta);
        }
        delta = deltas.get(0);
        if (!delta.leftVertex.equals(edgeLine.start)) {
            upperFirstLeaf.leftVertex = lowerFirstLeaf.leftVertex = edgeLine.start;
            leaf = new Trapezoid();
            leaf.leftVertex = delta.leftVertex;
            leaf.rightVertex = edgeLine.start;
            leaf.bottomEdge = delta.bottomEdge;
            leaf.topEdge = delta.topEdge;
            leaf.copyUpperLeft(delta);
            leaf.copyLowerLeft(delta);
            upperFirstLeaf.upperLeft = lowerFirstLeaf.lowerLeft = leaf;
            leaf.upperRight = upperFirstLeaf;
            leaf.lowerRight = lowerFirstLeaf;
            node = new VertexNode(edgeLine.start, this.epsilon);
            node.setLeft(leaf);
            node.right = nodes[0];
            nodes[0] = node;
        } else {
            upperFirstLeaf.copyUpperLeft(delta);
            lowerFirstLeaf.copyLowerLeft(delta);
        }
        if (this._tree == deltas.get(0)) {
            this._tree = nodes[0];
            deltas.get(0).setIsDeleted();
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                delta = deltas.get(i);
                for (Node parent : delta.parents) {
                    if (parent.left == delta) {
                        assert (parent.right != delta);
                        parent.left = nodes[i];
                        continue;
                    }
                    assert (parent.right == delta);
                    parent.right = nodes[i];
                }
                delta.setIsDeleted();
            }
        }
    }

    private static String showHashCode(Object obj) {
        return obj == null ? "null" : Integer.toString(obj.hashCode());
    }

    private final class VertexNode
    extends Node {
        final PointD vertex;

        VertexNode(PointD vertex, double epsilon) {
            super(epsilon);
            this.vertex = vertex;
        }

        @Override
        final SubdivisionElement find(PointD q) {
            Object obj;
            int result = PointDComparatorX.compareEpsilon(q, this.vertex, this.epsilon);
            if (result == 0) {
                return new SubdivisionElement(this.vertex);
            }
            Object object = obj = result < 0 ? this.left : this.right;
            if (obj instanceof Node) {
                return ((Node)obj).find(q);
            }
            return ((Trapezoid)obj).face();
        }

        @Override
        final Trapezoid findEdge(LineD edge) {
            Object obj;
            int result = PointDComparatorX.compareEpsilon(edge.start, this.vertex, this.epsilon);
            Object object = obj = result < 0 ? this.left : this.right;
            if (obj instanceof Node) {
                return ((Node)obj).findEdge(edge);
            }
            return (Trapezoid)obj;
        }

        @Override
        public String toString() {
            return String.format("%d X-Node %s %n\t%s", this.hashCode(), this.vertex, super.toString());
        }
    }

    private final class EdgeNode
    extends Node {
        final SubdivisionEdge edge;
        final LineD edgeLine;

        EdgeNode(SubdivisionEdge edge, LineD edgeLine, double epsilon) {
            super(epsilon);
            assert (edge.toLine().equals(edgeLine));
            assert (PointDComparatorX.compareEpsilon(edgeLine.start, edgeLine.end, epsilon) < 0);
            this.edge = edge;
            this.edgeLine = edgeLine;
        }

        @Override
        final SubdivisionElement find(PointD q) {
            LineLocation result = this.edgeLine.locate(q, this.epsilon);
            Object obj = null;
            switch (result) {
                case START: {
                    return new SubdivisionElement(this.edgeLine.start);
                }
                case END: {
                    return new SubdivisionElement(this.edgeLine.end);
                }
                case BETWEEN: {
                    return new SubdivisionElement(this.edge);
                }
                case LEFT: 
                case BEFORE: {
                    obj = this.left;
                    break;
                }
                case RIGHT: 
                case AFTER: {
                    obj = this.right;
                }
            }
            if (obj instanceof Node) {
                return ((Node)obj).find(q);
            }
            assert (obj instanceof Trapezoid);
            return ((Trapezoid)obj).face();
        }

        @Override
        final Trapezoid findEdge(LineD edge) {
            Object obj;
            assert (PointDComparatorX.compareEpsilon(edge.start, edge.end, this.epsilon) < 0);
            LineLocation result = this.edgeLine.locate(edge.start);
            switch (result) {
                case LEFT: {
                    obj = this.left;
                    break;
                }
                case RIGHT: {
                    obj = this.right;
                    break;
                }
                default: {
                    assert (result == LineLocation.START);
                    if (Math.abs(edge.start.x - edge.end.x) <= this.epsilon) {
                        obj = this.left;
                        break;
                    }
                    if (Math.abs(this.edgeLine.start.x - this.edgeLine.end.x) <= this.epsilon) {
                        obj = this.right;
                        break;
                    }
                    Object object = obj = edge.slope() > this.edgeLine.slope() ? this.left : this.right;
                }
            }
            if (obj instanceof Node) {
                return ((Node)obj).findEdge(edge);
            }
            return (Trapezoid)obj;
        }

        @Override
        public String toString() {
            return String.format("%d Y-Node %s %n\t%s %n\t%s", this.hashCode(), this.edgeLine, this.edge, super.toString());
        }
    }

    private static abstract class Node {
        final double epsilon;
        Object left;
        Object right;

        Node(double epsilon) {
            assert (epsilon > 0.0);
            this.epsilon = epsilon;
        }

        abstract SubdivisionElement find(PointD var1);

        abstract Trapezoid findEdge(LineD var1);

        void setLeft(Trapezoid trapezoid) {
            this.left = trapezoid;
            trapezoid.parents.add(this);
        }

        void setRight(Trapezoid trapezoid) {
            this.right = trapezoid;
            trapezoid.parents.add(this);
        }

        public String toString() {
            return String.format("Left %s, Right %s", SubdivisionSearch.showHashCode(this.left), SubdivisionSearch.showHashCode(this.right));
        }
    }

    private static class Trapezoid {
        private static final SubdivisionEdge DELETED_EDGE = new SubdivisionEdge(-1);
        final List<Node> parents = new ArrayList<Node>(2);
        SubdivisionEdge bottomEdge;
        SubdivisionEdge topEdge;
        PointD leftVertex = new PointD(Double.NEGATIVE_INFINITY, 0.0);
        PointD rightVertex = new PointD(Double.POSITIVE_INFINITY, 0.0);
        Trapezoid lowerLeft;
        Trapezoid lowerRight;
        Trapezoid upperLeft;
        Trapezoid upperRight;

        private Trapezoid() {
        }

        void copyLowerLeft(Trapezoid trapezoid) {
            if (trapezoid.lowerLeft != null) {
                this.lowerLeft = trapezoid.lowerLeft;
                assert (this.lowerLeft.lowerRight == trapezoid);
                this.lowerLeft.lowerRight = this;
            }
        }

        void copyLowerRight(Trapezoid trapezoid) {
            if (trapezoid.lowerRight != null) {
                this.lowerRight = trapezoid.lowerRight;
                assert (this.lowerRight.lowerLeft == trapezoid);
                this.lowerRight.lowerLeft = this;
            }
        }

        void copyUpperLeft(Trapezoid trapezoid) {
            if (trapezoid.upperLeft != null) {
                this.upperLeft = trapezoid.upperLeft;
                assert (this.upperLeft.upperRight == trapezoid);
                this.upperLeft.upperRight = this;
            }
        }

        void copyUpperRight(Trapezoid trapezoid) {
            if (trapezoid.upperRight != null) {
                this.upperRight = trapezoid.upperRight;
                assert (this.upperRight.upperLeft == trapezoid);
                this.upperRight.upperLeft = this;
            }
        }

        SubdivisionElement face() {
            if (this.topEdge != null) {
                return new SubdivisionElement(this.topEdge._face);
            }
            if (this.bottomEdge != null) {
                return new SubdivisionElement(this.bottomEdge._face);
            }
            return SubdivisionElement.NULL_FACE;
        }

        boolean isDeleted() {
            return this.topEdge == DELETED_EDGE;
        }

        void setIsDeleted() {
            this.topEdge = DELETED_EDGE;
        }

        public String toString() {
            String parentString = "null";
            if (!this.parents.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (Node parent : this.parents) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(parent.hashCode());
                }
                parentString = builder.toString();
            }
            return String.format("%d Trapezoid Parents %s %n\tLeft %s %n\tRight %s %n\tTop %s %n\tBottom %s %n\tLeft Upper %s, Lower %s %n\tRight Upper %s, Lower %s", this.hashCode(), parentString, this.leftVertex, this.rightVertex, Objects.toString(this.topEdge), Objects.toString(this.bottomEdge), SubdivisionSearch.showHashCode(this.upperLeft), SubdivisionSearch.showHashCode(this.lowerLeft), SubdivisionSearch.showHashCode(this.upperRight), SubdivisionSearch.showHashCode(this.lowerRight));
        }
    }
}

