/*
 * Decompiled with CFR 0.152.
 */
package org.kynosarges.tektosyne.subdivision;

import org.kynosarges.tektosyne.geometry.PointD;
import org.kynosarges.tektosyne.geometry.VoronoiResults;
import org.kynosarges.tektosyne.subdivision.Subdivision;
import org.kynosarges.tektosyne.subdivision.SubdivisionFace;
import org.kynosarges.tektosyne.subdivision.SubdivisionMap;

public class VoronoiMap
implements SubdivisionMap<Integer> {
    private final Subdivision _source;
    private final VoronoiResults _target;
    private final int[] _faceToSite;
    private final SubdivisionFace[] _siteToFace;

    public VoronoiMap(VoronoiResults results) {
        PointD[][] regions = results.voronoiRegions();
        this._source = Subdivision.fromPolygons(regions, 0.0);
        this._target = results;
        assert (results.generatorSites.length == regions.length);
        assert (this._source.faces().size() == regions.length + 1);
        this._faceToSite = new int[regions.length];
        this._siteToFace = new SubdivisionFace[regions.length];
        for (int i = 0; i < regions.length; ++i) {
            PointD[] polygon = regions[i];
            SubdivisionFace face = this._source.findFace(polygon, false);
            this._faceToSite[face.key() - 1] = i;
            this._siteToFace[i] = face;
        }
    }

    @Override
    public VoronoiResults target() {
        return this._target;
    }

    @Override
    public Subdivision source() {
        return this._source;
    }

    @Override
    public Integer fromFace(SubdivisionFace face) {
        return this._faceToSite[face.key() - 1];
    }

    @Override
    public SubdivisionFace toFace(Integer value) {
        return this._siteToFace[value];
    }

    @Override
    public SubdivisionFace toFace(int value) {
        return this._siteToFace[value];
    }
}

