/*
 * Decompiled with CFR 0.152.
 */
package org.l88.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.l88.common.utils.Strings;

public class StringsTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)Strings.isEmpty(null));
        Assert.assertTrue((boolean)Strings.isEmpty((String)""));
        Assert.assertFalse((boolean)Strings.isEmpty((String)" "));
    }

    @Test
    public void testNullableObjectString() {
        Assert.assertEquals((Object)"", (Object)Strings.nullable(null));
        Assert.assertEquals((Object)"", (Object)Strings.nullable((Object)""));
        Assert.assertEquals((Object)" ", (Object)Strings.nullable((Object)" "));
    }

    @Test
    public void testToStringObject() {
        Assert.assertEquals((Object)"e", (Object)Strings.toString(null, (String)"e"));
        Assert.assertEquals((Object)"e", (Object)Strings.toString((Object)"", (String)"e"));
        Assert.assertEquals((Object)" ", (Object)Strings.toString((Object)" ", (String)"e"));
    }

    @Test
    public void testJoin() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("str1");
        list.add("");
        list.add("str2");
        list.add("");
        Assert.assertEquals((Object)"str1<>str2", (Object)Strings.join(list, (String)"<>"));
    }

    @Test
    public void testSplitLines() {
        Object[] lines = Strings.splitLines((String)"line1\nline2\r\n\r\nline3");
        Object[] exp = new String[]{"line1", "line2", "", "line3"};
        Assert.assertArrayEquals((Object[])exp, (Object[])lines);
    }

    @Test
    public void testSplitStringCharBoolean() {
        List vs = Strings.split((String)"aa,bbb,, ,cc,", (char)',', (boolean)false);
        Object[] exp = new String[]{"aa", "bbb", "", " ", "cc", ""};
        Assert.assertArrayEquals((Object[])exp, (Object[])vs.toArray());
    }

    @Test
    public void testSplitStringChar() {
        List vs = Strings.split((String)"aa,bbb,, ,cc,", (char)',');
        Object[] exp = new String[]{"aa", "bbb", "", "", "cc", ""};
        Assert.assertArrayEquals((Object[])exp, (Object[])vs.toArray());
    }

    @Test
    public void testSplitString() {
        List vs = Strings.split((String)"aa,bbb,, ,cc,");
        Object[] exp = new String[]{"aa", "bbb", "cc"};
        Assert.assertArrayEquals((Object[])exp, (Object[])vs.toArray());
    }

    @Test
    public void testSplitStringString() {
        List vs = Strings.split((String)"aa,bbb,, ,cc,", (String)",");
        Object[] exp = new String[]{"aa", "bbb", " ", "cc"};
        Assert.assertArrayEquals((Object[])exp, (Object[])vs.toArray());
    }

    @Test
    public void testReplace() {
        String v = Strings.replace((String)"aabbcc", (String)"ab", (String)"dd");
        Assert.assertEquals((Object)"addbcc", (Object)v);
    }

    @Test
    public void testEscapeXML() {
        String v = Strings.escapeXML((String)"a<b>c&d;'e\"f");
        Assert.assertEquals((Object)"a&lt;b&gt;c&amp;d;&apos;e&quot;f", (Object)v);
    }

    @Test
    public void testUnescapeXML() {
        String v = Strings.unescapeXML((String)"a&lt;b&gt;c&amp;d;&apos;e&quot;f");
        Assert.assertEquals((Object)"a<b>c&d;'e\"f", (Object)v);
    }

    @Test
    public void testEscapeHTML() {
        String v = Strings.escapeHTML((String)"a<b>c&d;'e\"f\ng\r\nh");
        Assert.assertEquals((Object)"a&lt;b&gt;c&amp;d;&apos;e&quot;f<br>g<br>h", (Object)v);
    }

    @Test
    public void testCapitalize() {
        String v = Strings.capitalize((String)"a<b>c&D ;'e\"f\ng\r\nh");
        Assert.assertEquals((Object)"A<b>c&D ;'e\"f\ng\r\nh", (Object)v);
    }

    @Test
    public void testUnCapitalize() {
        String v = Strings.unCapitalize((String)"A<b>c&D ;'e\"f\ng\r\nh");
        Assert.assertEquals((Object)"a<b>c&D ;'e\"f\ng\r\nh", (Object)v);
    }

    @Test
    public void testReplaceVar() {
        HashMap<String, String> vs = new HashMap<String, String>();
        vs.put("var1", "v1");
        vs.put("var2", "v2");
        vs.put("var3", "v3");
        String v = Strings.replaceVar((String)"${var3}--${var1}--${var2}", vs);
        Assert.assertEquals((Object)"v3--v1--v2", (Object)v);
    }

    @Test
    public void testToHex() {
        byte[] hash = new byte[]{0, -1, 1, 26, 31};
        String v = Strings.toHex((byte[])hash);
        Assert.assertEquals((Object)"00ff011a1f", (Object)v);
    }

    @Test
    public void testHexToBytes() {
        byte[] hash = new byte[]{0, -1, 1, 26, 31};
        byte[] v = Strings.hexToBytes((String)"00ff011a1f");
        Assert.assertArrayEquals((byte[])hash, (byte[])v);
    }

    @Test
    public void testCompactSize() {
        Assert.assertEquals((Object)"1,023B", (Object)Strings.compactSize((long)1023L));
        Assert.assertEquals((Object)"1K", (Object)Strings.compactSize((long)1024L));
        Assert.assertEquals((Object)"1M", (Object)Strings.compactSize((long)0x100000L));
        Assert.assertEquals((Object)"1,023M", (Object)Strings.compactSize((long)0x3FF00000L));
        Assert.assertEquals((Object)"1G", (Object)Strings.compactSize((long)0x40000000L));
        Assert.assertEquals((Object)"1T", (Object)Strings.compactSize((long)0x10000000000L));
    }

    @Test
    public void testGetDefaultCharacterEncoding() {
        Strings.getDefaultCharacterEncoding();
    }

    @Test
    public void testSubstr() {
        Assert.assertEquals((Object)"abc", (Object)Strings.substr((String)"abcdef", (int)0, (int)3));
    }

    @Test
    public void testGbsubstrStringIntIntBoolean() {
        Assert.assertEquals((Object)"abc", (Object)Strings.gbsubstr((String)"abcdef", (int)0, (int)3, (boolean)true));
    }

    @Test
    public void testGbsubstrStringIntInt() {
        Assert.assertEquals((Object)"abc", (Object)Strings.gbsubstr((String)"abcdef", (int)0, (int)3));
    }

    @Test
    public void testGbStrLen() {
        Assert.assertEquals((long)3L, (long)Strings.gbStrLen((String)"a\u4e2d"));
        Assert.assertEquals((long)5L, (long)Strings.gbStrLen((String)"a\u4e2d\u6587"));
        Assert.assertEquals((long)3L, (long)Strings.gbStrLen((String)"abc"));
    }

    @Test
    public void testReplicateStr() {
        Assert.assertEquals((Object)"0000000000", (Object)Strings.replicateStr((char)'0', (int)10));
        Assert.assertEquals((Object)"0", (Object)Strings.replicateStr((char)'0', (int)1));
        Assert.assertEquals((Object)"", (Object)Strings.replicateStr((char)'0', (int)0));
        Assert.assertEquals((Object)"", (Object)Strings.replicateStr((char)'0', (int)-1));
    }

    @Test
    public void testLFillStr() {
        Assert.assertEquals((Object)"abc\u4e2ddef00", (Object)Strings.lFillStr((String)"abc\u4e2ddef", (char)'0', (int)10));
        Assert.assertEquals((Object)"a", (Object)Strings.lFillStr((String)"abc\u4e2ddef", (char)'0', (int)1));
        Assert.assertEquals((Object)"\u4e2d\u6587000000", (Object)Strings.lFillStr((String)"\u4e2d\u6587", (char)'0', (int)10));
    }

    @Test
    public void testRFillStrStringCharInt() {
        Assert.assertEquals((Object)"00abc\u4e2ddef", (Object)Strings.rFillStr((String)"abc\u4e2ddef", (char)'0', (int)10));
        Assert.assertEquals((Object)"000000\u4e2d\u6587", (Object)Strings.rFillStr((String)"\u4e2d\u6587", (char)'0', (int)10));
    }

    @Test
    public void testRFillStrStringCharIntBoolean() {
        Assert.assertEquals((Object)"00abc\u4e2ddef", (Object)Strings.rFillStr((String)"abc\u4e2ddef", (char)'0', (int)10, (boolean)true));
        Assert.assertEquals((Object)"000000\u4e2d\u6587", (Object)Strings.rFillStr((String)"\u4e2d\u6587", (char)'0', (int)10, (boolean)true));
    }

    @Test
    public void testOmitStringInt() {
        Assert.assertEquals((Object)"abcdef", (Object)Strings.omit((String)"abcdef", (int)8));
        Assert.assertEquals((Object)"ab...", (Object)Strings.omit((String)"abcdef", (int)5));
        Assert.assertEquals((Object)"abcdef", (Object)Strings.omit((String)"abcdef", (int)6));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (int)3));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (int)2));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (int)0));
        Assert.assertEquals((Object)"abc", (Object)Strings.omit((String)"abc", (int)3));
        Assert.assertEquals((Object)"ab", (Object)Strings.omit((String)"ab", (int)2));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abc", (int)2));
    }

    @Test
    public void testOmitStringStringInt() {
        Assert.assertEquals((Object)"ab\u4e2def", (Object)Strings.omit((String)"ab\u4e2def", (String)"GBK", (int)7));
        Assert.assertEquals((Object)"\u4e2d...", (Object)Strings.omit((String)"\u4e2dbcdef", (String)"GBK", (int)5));
        Assert.assertEquals((Object)"ab\u4e2def", (Object)Strings.omit((String)"ab\u4e2def", (String)"GBK", (int)6));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (String)"GBK", (int)3));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (String)"GBK", (int)2));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abcdef", (String)"GBK", (int)0));
        Assert.assertEquals((Object)"abc", (Object)Strings.omit((String)"abc", (String)"GBK", (int)3));
        Assert.assertEquals((Object)"ab", (Object)Strings.omit((String)"ab", (String)"GBK", (int)2));
        Assert.assertEquals((Object)"...", (Object)Strings.omit((String)"abc", (String)"GBK", (int)2));
    }

    @Test
    public void testTrimPunct() {
        String v = Strings.trimPunct((String)"a,b.c:d;e'f\"");
        Assert.assertEquals((Object)"abcdef", (Object)v);
    }

    @Test
    public void testEqualsStringString() {
        Assert.assertTrue((boolean)Strings.equals((String)"1", (String)"1"));
        Assert.assertTrue((boolean)Strings.equals(null, null));
        Assert.assertFalse((boolean)Strings.equals((String)"", null));
        Assert.assertFalse((boolean)Strings.equals(null, (String)""));
        Assert.assertFalse((boolean)Strings.equals((String)"1", (String)"2"));
    }
}

