/*
 * Decompiled with CFR 0.152.
 */
package org.lable.oss.dynamicconfig.di;

import com.google.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.lable.oss.dynamicconfig.core.ConfigurationException;
import org.lable.oss.dynamicconfig.core.ConfigurationInitializer;
import org.lable.oss.dynamicconfig.core.spi.HierarchicalConfigurationDeserializer;
import org.lable.oss.dynamicconfig.di.ConfigurationDefaults;

@Singleton
public class ConfigurationProvider
implements Provider<Configuration> {
    final HierarchicalConfigurationDeserializer deserializer;
    HierarchicalConfiguration defaults;

    @Inject
    ConfigurationProvider(HierarchicalConfigurationDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Inject(optional=true)
    public void setDefaults(@ConfigurationDefaults HierarchicalConfiguration defaults) {
        this.defaults = defaults;
    }

    public Configuration get() {
        Configuration result;
        try {
            result = ConfigurationInitializer.configureFromProperties((HierarchicalConfiguration)this.defaults, (HierarchicalConfigurationDeserializer)this.deserializer);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

